/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.entity;

import com.starfish_studios.naturalist.entity.ai.goal.AttackPlayerNearBabiesGoal;
import com.starfish_studios.naturalist.entity.ai.goal.BabyHurtByTargetGoal;
import com.starfish_studios.naturalist.entity.ai.goal.BabyPanicGoal;
import com.starfish_studios.naturalist.entity.ai.goal.DistancedFollowParentGoal;
import com.starfish_studios.naturalist.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.registry.NaturalistSoundEvents;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class Elephant
extends Animal
implements IAnimatable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final EntityDataAccessor<Integer> DIRTY_TICKS = SynchedEntityData.m_135353_(Elephant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DRINKING = SynchedEntityData.m_135353_(Elephant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Nullable
    protected BlockPos waterPos;

    public Elephant(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22277_, 20.0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        AgeableMob.AgeableMobGroupData ageableMobGroupData;
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(true);
        }
        if ((ageableMobGroupData = (AgeableMob.AgeableMobGroupData)spawnData).m_146777_() > 1) {
            this.m_146762_(-24000);
        }
        ageableMobGroupData.m_146778_();
        RandomSource random = level.m_213780_();
        this.m_21051_(Attributes.f_22277_).m_22125_(new AttributeModifier("Random spawn bonus", random.m_216328_(0.0, 0.11485000000000001), AttributeModifier.Operation.MULTIPLY_BASE));
        return spawnData;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)NaturalistEntityTypes.ELEPHANT.get().m_20615_((Level)serverLevel);
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigation((Mob)this, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Bee.class, 8.0f, 1.5, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new ElephantMeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(3, (Goal)new BabyPanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(4, (Goal)new DistancedFollowParentGoal(this, 1.25, 24.0, 6.0, 12.0));
        this.f_21345_.m_25352_(5, (Goal)new ElephantDrinkWaterGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new ElephantMoveToWaterGoal(this, 1.0, 8, 4));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new BabyHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new AttackPlayerNearBabiesGoal((Mob)this, 0.5f));
    }

    public int m_8085_() {
        return 35;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return NaturalistSoundEvents.ELEPHANT_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return NaturalistSoundEvents.ELEPHANT_AMBIENT.get();
    }

    public boolean m_7327_(Entity target) {
        boolean shouldHurt = target.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
        if (shouldHurt && target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            Vec3 knockbackDirection = new Vec3((double)this.m_20183_().m_123341_() - target.m_20185_(), 0.0, (double)this.m_20183_().m_123343_() - target.m_20189_()).m_82541_();
            float shieldBlockModifier = livingEntity.m_21275_(DamageSource.m_19370_((LivingEntity)this)) ? 0.5f : 1.0f;
            livingEntity.m_147240_((double)shieldBlockModifier * 3.0, knockbackDirection.m_7096_(), knockbackDirection.m_7094_());
            double knockbackResistance = Math.max(0.0, 1.0 - livingEntity.m_21133_(Attributes.f_22278_));
            livingEntity.m_20256_(livingEntity.m_20184_().m_82520_(0.0, 0.5 * knockbackResistance, 0.0));
        }
        this.m_5496_(SoundEvents.f_12357_, 1.0f, 1.0f);
        return shouldHurt;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DIRTY_TICKS, (Object)0);
        this.f_19804_.m_135372_(DRINKING, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("DirtyTicks", this.getDirtyTicks());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setDirtyTicks(pCompound.m_128451_("DirtyTicks"));
    }

    public void setDirtyTicks(int ticks) {
        this.f_19804_.m_135381_(DIRTY_TICKS, (Object)ticks);
    }

    public int getDirtyTicks() {
        return (Integer)this.f_19804_.m_135370_(DIRTY_TICKS);
    }

    public boolean isDirty() {
        return this.getDirtyTicks() > 0;
    }

    public void setDrinking(boolean drinking) {
        this.f_19804_.m_135381_(DRINKING, (Object)drinking);
    }

    public boolean isDrinking() {
        return (Boolean)this.f_19804_.m_135370_(DRINKING);
    }

    public void m_8107_() {
        super.m_8107_();
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isDirty()) {
                this.setDirtyTicks(this.m_20069_() ? 0 : Math.max(0, this.getDirtyTicks() - 1));
            } else {
                long dayTime = serverLevel.m_46468_();
                if (dayTime > 4300L && dayTime < 11000L && this.m_20096_() && this.m_217043_().m_188501_() < 0.001f && !this.isDrinking()) {
                    this.m_6674_(InteractionHand.MAIN_HAND);
                    this.setDirtyTicks(1000);
                    serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50493_.m_49966_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 200, 0.5, 3.0, 0.5, 10.0);
                }
            }
        }
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_20184_().m_165925_() > 1.0E-6) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("elephant.walk", Boolean.valueOf(true)));
        } else if (this.isDrinking()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("elephant.water", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("elephant.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState swingPredicate(AnimationEvent<E> event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(new AnimationBuilder().addAnimation("elephant.swing", Boolean.valueOf(false)));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(10.0);
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "swingController", 0.0f, this::swingPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class ElephantMeleeAttackGoal
    extends MeleeAttackGoal {
        public ElephantMeleeAttackGoal(PathfinderMob pathfinderMob, double speedMultiplier, boolean followingTargetEvenIfNotSeen) {
            super(pathfinderMob, speedMultiplier, followingTargetEvenIfNotSeen);
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return Mth.m_14207_((float)this.f_25540_.m_20205_());
        }
    }

    static class ElephantDrinkWaterGoal
    extends Goal {
        private final Elephant elephant;
        private int drinkTicks;

        public ElephantDrinkWaterGoal(Elephant elephant) {
            this.elephant = elephant;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.elephant.waterPos == null || this.elephant.m_20238_(Vec3.m_82512_((Vec3i)this.elephant.waterPos)) > 15.0) {
                this.elephant.setDrinking(false);
                return false;
            }
            return this.elephant.isDrinking();
        }

        public boolean m_8045_() {
            return this.drinkTicks > 0 && super.m_8045_();
        }

        public void m_8056_() {
            this.drinkTicks = 150;
            if (this.elephant.waterPos != null) {
                this.elephant.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)this.elephant.waterPos));
            }
        }

        public void m_8037_() {
            --this.drinkTicks;
            if (this.elephant.waterPos != null) {
                this.elephant.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)this.elephant.waterPos));
            }
        }

        public void m_8041_() {
            this.elephant.waterPos = null;
            this.elephant.setDrinking(false);
        }
    }

    static class ElephantMoveToWaterGoal
    extends MoveToBlockGoal {
        private final Elephant elephant;

        public ElephantMoveToWaterGoal(Elephant pathfinderMob, double speedModifier, int searchRange, int verticalSearchRange) {
            super((PathfinderMob)pathfinderMob, speedModifier, searchRange, verticalSearchRange);
            this.elephant = pathfinderMob;
        }

        public boolean m_8036_() {
            return !this.elephant.m_6162_() && !this.elephant.isDrinking() && this.elephant.waterPos == null && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.m_25625_() && super.m_8045_();
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            if (level.m_8055_(pos).m_60713_(Blocks.f_50440_)) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    if (!level.m_6425_(pos.m_121945_(direction)).m_192917_((Fluid)Fluids.f_76193_)) continue;
                    this.elephant.waterPos = pos.m_121945_(direction);
                    return true;
                }
            }
            return false;
        }

        public double m_8052_() {
            return 2.5;
        }

        public void m_8041_() {
            this.elephant.setDrinking(true);
            super.m_8041_();
        }
    }
}

