/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config.networking;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import pregenerator.ChunkPregenerator;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.utils.config.Config;
import pregenerator.common.utils.config.ConfigEntry;
import pregenerator.common.utils.config.ConfigHandler;

public class SyncConfigPacket
implements IPregenPacket {
    String configName;
    Map<String, byte[]> data = new Object2ObjectOpenHashMap();

    public SyncConfigPacket() {
    }

    public SyncConfigPacket(String configName, Map<String, byte[]> data) {
        this.configName = configName;
        this.data = data;
    }

    public static SyncConfigPacket create(Config config, boolean forceSync) {
        Object2ObjectOpenHashMap data = new Object2ObjectOpenHashMap();
        ByteBuf buf = Unpooled.buffer();
        FriendlyByteBuf buffer = new FriendlyByteBuf(buf);
        for (Map.Entry<String, ConfigEntry<?>> entry : config.getSyncedEntries().entrySet()) {
            if (!entry.getValue().hasChanged() && !forceSync) continue;
            buf.clear();
            entry.getValue().serialize(buffer);
            byte[] configData = new byte[buf.writerIndex()];
            buf.readBytes(configData);
            data.put(entry.getKey(), configData);
            entry.getValue().onSynced();
        }
        return data.isEmpty() ? null : new SyncConfigPacket(config.getName(), (Map<String, byte[]>)data);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.configName);
        buffer.m_130130_(this.data.size());
        for (Map.Entry<String, byte[]> entry : this.data.entrySet()) {
            buffer.m_130070_(entry.getKey());
            buffer.m_130087_(entry.getValue());
        }
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.configName = buffer.m_130136_(Short.MAX_VALUE);
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            this.data.put(buffer.m_130136_(Short.MAX_VALUE), buffer.m_130052_());
        }
    }

    @Override
    public void process(Player source) {
        if (this.data.isEmpty()) {
            return;
        }
        ConfigHandler cfg = ChunkPregenerator.FILE_WATCHER.getConfig(this.configName);
        if (cfg != null) {
            Map<String, ConfigEntry<?>> entries = cfg.getConfig().getSyncedEntries();
            if (entries.isEmpty()) {
                return;
            }
            boolean synced = false;
            boolean reload = false;
            boolean restart = false;
            for (Map.Entry<String, byte[]> dataEntry : this.data.entrySet()) {
                ConfigEntry<?> entry = entries.get(dataEntry.getKey());
                if (entry == null) continue;
                entry.deserialize(new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])dataEntry.getValue())));
                boolean changed = entry.hasChanged();
                synced |= changed;
                if (changed) {
                    reload |= entry.needsWorldReload();
                    restart |= entry.needsGameReload();
                }
                entry.onSynced();
            }
            if (synced) {
                cfg.onSynced();
                if (restart) {
                    source.m_5661_((Component)Component.m_237113_((String)"Config synced a Setting that requires a Game Restart, Please restart the game"), false);
                } else if (reload) {
                    source.m_5661_((Component)Component.m_237113_((String)"Config synced a Setting that requires a World reload, Please rejoin the Server and everything should work fine"), false);
                }
            }
        }
    }
}

