/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import pregenerator.common.utils.config.ConfigEntry;
import pregenerator.common.utils.config.FileSystemWatcher;

public class ConfigSection {
    private String name;
    private ConfigSection parent = null;
    private boolean used = false;
    private Object2ObjectMap<String, ConfigEntry<?>> entries = new Object2ObjectLinkedOpenHashMap();
    private Object2ObjectMap<String, ConfigSection> subSections = new Object2ObjectLinkedOpenHashMap();

    public ConfigSection(String name) {
        if (FileSystemWatcher.check(name)) {
            throw new IllegalArgumentException("ConfigSection name must not be null, empty or start/end with white spaces");
        }
        if (name.contains(".")) {
            throw new IllegalArgumentException("ConfigSection name must not contain period signs. Name: " + name);
        }
        this.name = name;
    }

    public <V, T extends ConfigEntry<V>> T add(T entry) {
        ConfigEntry presentKey = (ConfigEntry)this.entries.get((Object)entry.getKey());
        if (presentKey != null) {
            if (presentKey instanceof ConfigEntry.StringValue && entry instanceof ConfigEntry.EnumValue) {
                entry.parseValue(presentKey.serializedValue());
            } else {
                return (T)(presentKey.getPrefix() != entry.getPrefix() ? entry : presentKey.setUsed());
            }
        }
        this.entries.put((Object)entry.getKey(), entry.setUsed());
        return entry;
    }

    <V, T extends ConfigEntry<V>> T addParsed(T entry) {
        this.entries.putIfAbsent((Object)entry.getKey(), entry);
        return entry;
    }

    public ConfigEntry.BoolValue addBool(String key, boolean value, String ... comment) {
        return this.add(new ConfigEntry.BoolValue(key, value, comment));
    }

    public ConfigEntry.BoolValue addBool(String key, boolean value) {
        return this.add(new ConfigEntry.BoolValue(key, value));
    }

    public ConfigEntry.IntValue addInt(String key, int value, String ... comment) {
        return this.add(new ConfigEntry.IntValue(key, value, comment));
    }

    public ConfigEntry.IntValue addInt(String key, int value) {
        return this.add(new ConfigEntry.IntValue(key, value));
    }

    public ConfigEntry.DoubleValue addDouble(String key, double value, String ... comment) {
        return this.add(new ConfigEntry.DoubleValue(key, value, comment));
    }

    public ConfigEntry.DoubleValue addDouble(String key, double value) {
        return this.add(new ConfigEntry.DoubleValue(key, value));
    }

    public ConfigEntry.StringValue addString(String key, String value, String ... comment) {
        return this.add(new ConfigEntry.StringValue(key, value, comment));
    }

    public ConfigEntry.StringValue addString(String key, String value) {
        return this.add(new ConfigEntry.StringValue(key, value));
    }

    public ConfigEntry.ArrayValue addArray(String key, String[] value, String ... comment) {
        return this.add(new ConfigEntry.ArrayValue(key, value, comment));
    }

    public ConfigEntry.ArrayValue addArray(String key, String[] value) {
        return this.add(new ConfigEntry.ArrayValue(key, value));
    }

    public ConfigEntry.ArrayValue addArray(String key, String comment) {
        return this.add(new ConfigEntry.ArrayValue(key, comment));
    }

    public ConfigEntry.ArrayValue addArray(String key) {
        return this.add(new ConfigEntry.ArrayValue(key));
    }

    public <E extends Enum<E>> ConfigEntry.EnumValue<E> addEnum(String key, E value, Class<E> enumClass, String ... comment) {
        return this.add(new ConfigEntry.EnumValue<E>(key, value, enumClass, comment));
    }

    public <E extends Enum<E>> ConfigEntry.EnumValue<E> addEnum(String key, E value, Class<E> enumClass) {
        return this.add(new ConfigEntry.EnumValue<E>(key, value, enumClass));
    }

    public ConfigSection addSubSection(String name) {
        ConfigSection subSection = (ConfigSection)this.subSections.get((Object)name);
        if (subSection == null) {
            subSection = new ConfigSection(name);
            subSection.parent = this;
            this.subSections.put((Object)name, (Object)subSection);
        }
        return subSection.setUsed();
    }

    public ConfigSection add(ConfigSection section) {
        if (section.parent != null) {
            throw new IllegalStateException("ConfigSection must not be added to multiple sections. Section name: " + section.getName());
        }
        section.parent = this;
        this.subSections.putIfAbsent((Object)section.name, (Object)section);
        return section.setUsed();
    }

    public ConfigEntry<?> getEntry(String name) {
        return (ConfigEntry)this.entries.get((Object)name);
    }

    public ConfigSection getSubSection(String name) {
        return (ConfigSection)this.subSections.get((Object)name);
    }

    ConfigSection parseSubSection(String name) {
        ConfigSection section = (ConfigSection)this.subSections.get((Object)name);
        if (section == null) {
            section = new ConfigSection(name);
            this.subSections.put((Object)name, (Object)section);
        }
        return section;
    }

    public List<ConfigSection> getChildren() {
        return new ObjectArrayList(this.subSections.values());
    }

    public List<ConfigEntry<?>> getEntries() {
        return new ObjectArrayList(this.entries.values());
    }

    public void resetDefault() {
        this.subSections.values().forEach(ConfigSection::resetDefault);
        this.entries.values().forEach(ConfigEntry::resetDefault);
    }

    boolean hasChanged() {
        for (ConfigEntry entry : this.entries.values()) {
            if (!entry.hasChanged()) continue;
            return true;
        }
        for (ConfigSection section : this.subSections.values()) {
            if (!section.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public ConfigSection getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getSectionPath() {
        return (String)(this.parent != null ? this.parent.getSectionPath() + "." : "") + this.name;
    }

    boolean isUsed() {
        return this.used;
    }

    ConfigSection setUsed() {
        this.used = true;
        return this;
    }

    public void getSyncedEntries(Map<String, ConfigEntry<?>> syncedEntries) {
        for (ConfigEntry entry : this.entries.values()) {
            if (!entry.isSynced()) continue;
            syncedEntries.put(this.getSectionPath() + "." + entry.getKey(), entry);
        }
        for (ConfigSection section : this.subSections.values()) {
            section.getSyncedEntries(syncedEntries);
        }
    }

    public String serialize() {
        return this.serialize(0);
    }

    public String serialize(int indentationLevel) {
        if (this.entries.size() == 0 && this.subSections.size() == 0) {
            return null;
        }
        AtomicInteger written = new AtomicInteger(0);
        StringBuilder builder = new StringBuilder((String)(this.parent == null ? "" : "\n" + StringUtils.repeat((char)' ', (int)(indentationLevel * 2))));
        builder.append('[');
        builder.append(this.getSectionPath());
        builder.append(']');
        int finalIndentationLevel = indentationLevel + 1;
        Object2ObjectMaps.fastForEach(this.entries, entry -> {
            if (((ConfigEntry)entry.getValue()).isUsed()) {
                builder.append(((ConfigEntry)entry.getValue()).serialize(finalIndentationLevel));
                written.incrementAndGet();
            }
        });
        StringJoiner joiner = new StringJoiner("\n", this.entries.size() == 0 || this.subSections.size() == 0 ? "" : "\n", "");
        Object2ObjectMaps.fastForEach(this.subSections, entry -> {
            String val;
            if (((ConfigSection)entry.getValue()).isUsed() && (val = ((ConfigSection)entry.getValue()).serialize(finalIndentationLevel)) != null) {
                joiner.add(val);
                written.getAndIncrement();
            }
        });
        builder.append(joiner.toString());
        return written.get() > 0 ? builder.toString() : null;
    }
}

