/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.common.tracker.WorldTracker;
import pregenerator.common.utils.misc.AverageCounter;
import pregenerator.common.utils.misc.TimeTracker;

public class ServerTracker {
    public static ServerTracker INSTANCE = new ServerTracker();
    TimeTracker timer = new TimeTracker(40);
    AverageCounter packets = new AverageCounter(40);
    Object2ObjectMap<ResourceKey<Level>, WorldTracker> trackers = new Object2ObjectLinkedOpenHashMap();
    boolean active = false;

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean toggle(boolean newValue) {
        if (this.disabled() == newValue) {
            this.active = newValue;
            return true;
        }
        return false;
    }

    public byte[] getProfilerData(ResourceKey<Level> type, Player player) {
        if (this.disabled()) {
            return new byte[0];
        }
        ByteBuf buf = Unpooled.buffer();
        FriendlyByteBuf buffer = new FriendlyByteBuf(buf);
        buffer.m_130130_(this.packets.getAverage());
        buffer.m_130130_(this.packets.getLast());
        Runtime runtime = Runtime.getRuntime();
        buffer.writeLong(runtime.totalMemory());
        buffer.writeLong(runtime.maxMemory());
        buffer.writeLong(runtime.freeMemory());
        buffer.m_130103_(this.timer.getAverage());
        buffer.m_130103_(this.timer.getLastValue());
        buffer.m_130130_(this.trackers.size());
        for (Object2ObjectMap.Entry entry : this.trackers.object2ObjectEntrySet()) {
            buffer.m_130085_(((ResourceKey)entry.getKey()).m_135782_());
            buffer.m_130103_(((WorldTracker)entry.getValue()).getAverageLag());
        }
        WorldTracker tracker = (WorldTracker)this.trackers.get(type);
        buffer.writeBoolean(tracker != null);
        if (tracker != null) {
            tracker.writeTrackingData(buffer);
        }
        byte[] data = new byte[buf.writerIndex()];
        buffer.readBytes(data);
        return data;
    }

    @SubscribeEvent
    public void onBlockUpdate(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor world = event.getLevel();
        if (!(world instanceof Level)) {
            return;
        }
        WorldTracker tracker = (WorldTracker)this.trackers.get((Object)((Level)world).m_46472_());
        if (tracker != null) {
            tracker.onBlockUpdate();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (this.disabled()) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            this.timer.start();
            this.packets.addMore(ServerLifecycleHooks.getCurrentServer().m_18696_());
            this.packets.onFinished();
            return;
        }
        this.timer.finish();
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.side.isClient() || this.disabled()) {
            return;
        }
        WorldTracker tracker = (WorldTracker)this.trackers.get((Object)event.level.m_46472_());
        if (tracker != null) {
            if (event.phase == TickEvent.Phase.START) {
                tracker.start();
                return;
            }
            tracker.stop();
        }
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor world = event.getLevel();
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            this.trackers.put((Object)server.m_46472_(), (Object)new WorldTracker(server));
        }
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        this.trackers.remove((Object)((Level)event.getLevel()).m_46472_());
    }

    protected boolean disabled() {
        return !this.active;
    }

    public Set<ResourceLocation> getAllDimensions() {
        ObjectOpenHashSet locations = new ObjectOpenHashSet();
        for (ResourceKey type : ServerLifecycleHooks.getCurrentServer().m_129784_()) {
            locations.add(type.m_135782_());
        }
        return locations;
    }

    public Set<ResourceLocation> getLoadedDimensions() {
        ObjectOpenHashSet locations = new ObjectOpenHashSet();
        for (ResourceKey type : this.trackers.keySet()) {
            locations.add(type.m_135782_());
        }
        return locations;
    }

    public WorldTracker getWorldTracker(ResourceKey<Level> dimension) {
        return (WorldTracker)this.trackers.get(dimension);
    }
}

