/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.LongPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.SectionStorage;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import pregenerator.ChunkPregenerator;
import pregenerator.PregenConfig;
import pregenerator.base.api.MixinHelper;
import pregenerator.base.mixins.common.storage.RegionSectionCacheMixin;
import pregenerator.base.mixins.common.storage.ServerChunkProviderMixin;
import pregenerator.base.mixins.common.storage.TicketManagerMixin;
import pregenerator.common.base.GenTaskStorage;
import pregenerator.common.base.IInteruptable;
import pregenerator.common.base.PregenEvent;
import pregenerator.common.base.PregenTaskEvent;
import pregenerator.common.base.TaskStorage;
import pregenerator.common.generator.ChunkEntry;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.GeneratorQueue;
import pregenerator.common.manager.IProcess;
import pregenerator.common.utils.collections.Long2ObjectCustomMap;
import pregenerator.common.utils.misc.TrackedRegionFile;

public class ChunkProcess
implements IInteruptable {
    public static final Runnable EMPTY = () -> {};
    public static final BooleanSupplier FALSE = () -> false;
    private static final TicketType<ChunkPos> PREGEN_TICKET = TicketType.m_9462_((String)"chunkpregen", Comparator.comparingLong(ChunkPos::m_45588_));
    private GenerationType genType;
    private ObjectArrayList<ChunkEntry> tasks = ObjectArrayList.wrap((Object[])new ChunkEntry[0]);
    private ServerLevel world;
    private ServerChunkCache provider;
    private ChunkMap manager;
    private DistanceManager ticketing;
    private Path regionFolder;
    private GenTaskStorage.ExecutionMemory memory;
    private Long2ObjectLinkedOpenHashMap<RegionFile> cache;
    private ProcessorHandle<ChunkTaskPriorityQueueSorter.Release> lightTasks;
    private Long2ObjectMap<Optional<PoiSection>> pointsOfInterest;
    private boolean lithiumFound;
    int spawnX;
    int spawnZ;
    String taskName;
    UUID taskId;
    private long totalChunks = 0L;
    private boolean throwEvents = false;
    private boolean disableMemoryLeak;

    public ChunkProcess(ServerLevel world, GenerationType genType) {
        this.world = world;
        this.genType = genType;
        BlockPos pos = world.m_220360_();
        this.spawnX = pos.m_123341_() >> 4;
        this.spawnZ = pos.m_123343_() >> 4;
        this.provider = world.m_7726_();
        this.manager = this.provider.f_8325_;
        this.ticketing = ((ServerChunkProviderMixin)this.provider).getTicketManager();
        this.regionFolder = DimensionType.m_196975_((ResourceKey)world.m_46472_(), (Path)world.m_7654_().m_129843_(LevelResource.f_78182_).getParent()).resolve("region");
        if (Files.notExists(this.regionFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(this.regionFolder, new FileAttribute[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.disableMemoryLeak = PregenConfig.INSTANCE.disableMemoryLeakFix.get();
        this.lightTasks = ((TicketManagerMixin)this.ticketing).getLightTasks();
        this.cache = this.getCache(this.provider);
        this.lithiumFound = MixinHelper.isLithiumLoaded(SectionStorage.class);
        Long2ObjectMap map = ((RegionSectionCacheMixin)this.provider.m_8484_()).getStorage();
        if (this.lithiumFound || this.disableMemoryLeak) {
            this.pointsOfInterest = map;
        } else if (map instanceof Long2ObjectCustomMap) {
            this.pointsOfInterest = map;
        } else {
            this.pointsOfInterest = new Long2ObjectCustomMap(map);
            ((RegionSectionCacheMixin)this.provider.m_8484_()).setStorage(this.pointsOfInterest);
        }
    }

    public void init(Long2ObjectMap<BitSet> maps, ChunkPos center, String taskName, UUID taskId, boolean event, IProcess.PrepaireProgress progress) {
        if (!progress.isAlive()) {
            return;
        }
        this.taskName = taskName;
        this.taskId = taskId;
        this.memory = TaskStorage.getGenStorage().getMemory(taskName);
        progress.growMax(maps.size());
        this.tasks.ensureCapacity(maps.size());
        this.clearFiles();
        RegionProvider region = new RegionProvider(this);
        LongPredicate tester = null;
        if (event) {
            PregenEvent.Check check = new PregenEvent.Check(this.world, taskName, taskId);
            MinecraftForge.EVENT_BUS.post((Event)check);
            tester = check.getPredicate();
        }
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(maps)) {
            progress.growValue(1);
            ChunkEntry task = new ChunkEntry(this, new ChunkPos(ChunkPos.m_45592_((long)entry.getLongKey()) << 5, ChunkPos.m_45602_((long)entry.getLongKey()) << 5), (BitSet)entry.getValue());
            if (task.init(region, event, tester)) continue;
            this.tasks.add((Object)task);
            this.totalChunks += (long)task.getTotalSize();
        }
        ObjectArrays.parallelQuickSort((Object[])((ChunkEntry[])this.tasks.elements()), (int)0, (int)this.tasks.size(), (o1, o2) -> Long.compare(o2.getDistanceToCenter(center), o1.getDistanceToCenter(center)));
        if (this.genType.requiresAccurateScan()) {
            ChunkEntry[] entries = (ChunkEntry[])this.tasks.elements();
            int m = this.tasks.size();
            for (int i = 0; i < m; ++i) {
                entries[i].checkAccuratly(ChunkPregenerator.CHUNK_PROCESS_QUEUE);
            }
        }
        this.provider.m_7827_().m_9310_(1000);
    }

    public void onTaskFinished() {
        MinecraftForge.EVENT_BUS.post((Event)new PregenTaskEvent.Stopped(this.taskName));
        this.provider.m_7827_().m_9310_(5);
        if (this.disableMemoryLeak || this.lithiumFound) {
            return;
        }
        ((RegionSectionCacheMixin)this.provider.m_8484_()).setStorage(new Long2ObjectLinkedOpenHashMap(this.pointsOfInterest));
    }

    @Override
    public void interrupt() {
        int m = this.tasks.size();
        for (int i = 0; i < m; ++i) {
            ((ChunkEntry)this.tasks.get(i)).interrupt();
        }
        this.tasks.clear();
        this.onTaskFinished();
    }

    public void clearTasks() {
        while (!this.tasks.isEmpty()) {
            ((ChunkEntry)this.tasks.pop()).interrupt();
        }
    }

    public void onTick() {
        if (this.world.m_46467_() % 80L == 0L) {
            if (!this.disableMemoryLeak && this.pointsOfInterest.size() > 50000) {
                long start = System.currentTimeMillis();
                PoiManager manager = this.provider.m_8484_();
                if (this.pointsOfInterest instanceof Long2ObjectCustomMap) {
                    Long2ObjectCustomMap map = (Long2ObjectCustomMap)this.pointsOfInterest;
                    while (this.pointsOfInterest.size() > 50000 && System.currentTimeMillis() - start < 10L) {
                        manager.m_63796_(SectionPos.m_123184_((long)map.firstLongKey()).m_123251_());
                        map.removeFirst();
                    }
                } else {
                    LongIterator iter = this.pointsOfInterest.keySet().iterator();
                    while (iter.hasNext() && this.pointsOfInterest.size() > 50000 && System.currentTimeMillis() - start < 10L) {
                        manager.m_63796_(SectionPos.m_123184_((long)iter.nextLong()).m_123251_());
                        iter.remove();
                    }
                }
            }
            while (this.cache.size() > 50) {
                try {
                    ((RegionFile)this.cache.removeLast()).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean isValidating() {
        return this.tasks.size() > 0 && ((ChunkEntry)this.tasks.top()).isValidating();
    }

    public int getPointsOfInterest() {
        return this.pointsOfInterest.size();
    }

    public void drainIntoQueue(GeneratorQueue queue) {
        if (this.tasks.isEmpty()) {
            return;
        }
        while (this.tasks.size() > 0 && queue.enqueue((ChunkEntry)this.tasks.top())) {
            this.tasks.pop();
        }
    }

    public void startTask(long[] chunks, ChunkStatus requestedStatus, CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>[] adder) {
        int i;
        int finalStatus = 33 + ChunkStatus.m_62370_((ChunkStatus)requestedStatus);
        int m = chunks.length;
        for (i = 0; i < m; ++i) {
            ChunkPos pos = new ChunkPos(chunks[i]);
            this.ticketing.m_140792_(PREGEN_TICKET, pos, finalStatus, (Object)pos);
        }
        this.flipChunks();
        m = chunks.length;
        for (i = 0; i < m; ++i) {
            ChunkHolder chunkholder = ChunkProcess.getHolder(this.provider, chunks[i]);
            if (chunkholder == null || chunkholder.m_140093_() > finalStatus) {
                throw new IllegalStateException("No chunk holder after ticket has been added");
            }
            adder[i] = chunkholder.m_140049_(requestedStatus, this.manager);
        }
    }

    public void startTask(long[] chunks, int radius, CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>[] adder) {
        int i;
        int finalStatus = 33 - radius;
        int m = chunks.length;
        for (i = 0; i < m; ++i) {
            ChunkPos pos = new ChunkPos(chunks[i]);
            this.ticketing.m_140792_(PREGEN_TICKET, pos, finalStatus, (Object)pos);
        }
        this.flipChunks();
        m = chunks.length;
        for (i = 0; i < m; ++i) {
            ChunkHolder chunkholder = ChunkProcess.getHolder(this.provider, chunks[i]);
            if (chunkholder == null || chunkholder.m_140093_() > finalStatus) {
                throw new IllegalStateException("No chunk holder after ticket has been added");
            }
            adder[i] = chunkholder.m_140049_(ChunkStatus.f_62326_, this.manager);
        }
    }

    public void finishTickets(long[] chunks, int start, int end, ChunkStatus statusToRemove) {
        int status = 33 + ChunkStatus.m_62370_((ChunkStatus)statusToRemove);
        boolean light = statusToRemove == ChunkStatus.f_62326_ || !this.genType.hasSubTask();
        int m = end;
        for (int i = start; i < m; ++i) {
            ChunkPos pos = new ChunkPos(chunks[i]);
            this.ticketing.m_140823_(PREGEN_TICKET, pos, status, (Object)pos);
            if (light) {
                this.getProvider().m_7827_().m_6462_(pos, false);
            }
            this.lightTasks.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140628_((Runnable)EMPTY, (long)chunks[i], (boolean)false));
        }
    }

    public void finishTickets(long[] chunks, int start, int end, int radius) {
        int status = 33 - radius;
        int m = end;
        for (int i = start; i < m; ++i) {
            ChunkPos pos = new ChunkPos(chunks[i]);
            this.ticketing.m_140823_(PREGEN_TICKET, pos, status, (Object)pos);
            this.getProvider().m_7827_().m_6462_(pos, false);
            this.lightTasks.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140628_((Runnable)EMPTY, (long)chunks[i], (boolean)false));
        }
    }

    private void flipChunks() {
        ((ServerChunkProviderMixin)this.provider).syncChunkUpdates();
    }

    public boolean containsChunk(ServerChunkCache provider, long value) {
        return ChunkProcess.getHolder(provider, value) != null;
    }

    public static ChunkHolder getHolder(ServerChunkCache provider, long key) {
        return ((ServerChunkProviderMixin)provider).getChunkIfPresent(key);
    }

    public boolean isDone() {
        return this.tasks.isEmpty();
    }

    public boolean isThrowingEvents() {
        return this.throwEvents;
    }

    public GenerationType getTaskType() {
        return this.genType;
    }

    public ServerChunkCache getProvider() {
        return this.provider;
    }

    public int getLoadedChunks() {
        return this.manager.m_140394_();
    }

    public long getTotalChunks() {
        return this.totalChunks;
    }

    public int getActiveRegionFiles() {
        return this.cache == null ? 0 : this.cache.size();
    }

    public GenTaskStorage.ExecutionMemory getMemory() {
        return this.memory;
    }

    public ChunkMap getManager() {
        return this.manager;
    }

    public DistanceManager getTicketing() {
        return this.ticketing;
    }

    public ServerLevel getWorld() {
        return this.world;
    }

    public boolean hasLithium() {
        return this.lithiumFound;
    }

    public boolean isSpawn(int x, int z) {
        return Math.abs(this.spawnZ - z) <= 12 && Math.abs(this.spawnX - x) <= 12;
    }

    public TrackedRegionFile getFile(ChunkPos pos) {
        try {
            Path path;
            while (this.cache.size() >= 100) {
                ((RegionFile)this.cache.removeLast()).close();
            }
            long data = ChunkPos.m_45589_((int)pos.m_45610_(), (int)pos.m_45612_());
            RegionFile parent = (RegionFile)this.cache.getAndMoveToFirst(data);
            if (parent instanceof TrackedRegionFile && ((TrackedRegionFile)parent).isValid()) {
                return (TrackedRegionFile)parent;
            }
            if (parent != null) {
                this.cache.remove(data);
                try {
                    parent.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (Files.exists(path = this.regionFolder.resolve("r." + pos.m_45610_() + "." + pos.m_45612_() + ".mca"), new LinkOption[0])) {
                TrackedRegionFile region = new TrackedRegionFile(path, path.getParent());
                this.cache.putAndMoveToFirst(data, (Object)region);
                return region;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> getChunk(long pos) {
        ChunkHolder holder = ChunkProcess.getHolder(this.provider, pos);
        return holder == null ? null : holder.m_140049_(ChunkStatus.f_62326_, this.manager);
    }

    private void clearFiles() {
        ObjectArrayList files = new ObjectArrayList(this.cache.values());
        this.cache.clear();
        int m = files.size();
        for (int i = 0; i < m; ++i) {
            try {
                ((RegionFile)files.get(i)).close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class RegionProvider {
        static final BitSet EMPTY = new BitSet(0);
        static final BitSet FULL = RegionProvider.create();
        Long2ObjectMap<BitSet> map = new Long2ObjectOpenHashMap();
        ChunkProcess process;

        public RegionProvider(ChunkProcess process) {
            this.process = process;
        }

        public boolean getChunk(int chunkX, int chunkZ) {
            return this.get(chunkX, chunkZ).get((chunkZ & 0x1F) * 32 + (chunkX & 0x1F));
        }

        public BitSet get(int chunkX, int chunkZ) {
            BitSet set = (BitSet)this.map.get(ChunkPos.m_45589_((int)(chunkX >> 5), (int)(chunkZ >> 5)));
            if (set == null) {
                TrackedRegionFile file = this.process.getFile(new ChunkPos(chunkX, chunkZ));
                if (file != null) {
                    set = new BitSet(1024);
                    set.clear();
                    for (int i = 0; i < 1024; ++i) {
                        boolean result = file.m_63682_(new ChunkPos(i % 32, i / 32));
                        if (!result) continue;
                        set.set(i);
                    }
                    if (set.equals(FULL)) {
                        set = FULL;
                    }
                    this.map.put(ChunkPos.m_45589_((int)(chunkX >> 5), (int)(chunkZ >> 5)), (Object)set);
                } else {
                    this.map.put(ChunkPos.m_45589_((int)(chunkX >> 5), (int)(chunkZ >> 5)), (Object)EMPTY);
                    set = EMPTY;
                }
            }
            return set;
        }

        static BitSet create() {
            BitSet set = new BitSet(1024);
            set.set(0, 1023);
            return set;
        }
    }
}

