/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter.tasks;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.tasks.BaseDeletionTask;
import pregenerator.common.generator.ChunkShapeBuilder;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class DeletionSquareExpansion
extends BaseDeletionTask {
    long center;
    int minRadius;
    int maxRadius;

    public DeletionSquareExpansion(CompoundTag nbt) {
        super(nbt);
        this.center = nbt.m_128454_("center");
        this.minRadius = nbt.m_128451_("minRadius");
        this.maxRadius = nbt.m_128451_("maxRadius");
    }

    public DeletionSquareExpansion(String name, ResourceKey<Level> type, ChunkPos center, int minRadius, int maxRadius) {
        super(name, type);
        this.center = center.m_45588_();
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
    }

    @Override
    public CompoundTag write() {
        CompoundTag nbt = super.write();
        nbt.m_128356_("center", this.center);
        nbt.m_128405_("minRadius", this.minRadius);
        nbt.m_128405_("maxRadius", this.maxRadius);
        return nbt;
    }

    @Override
    public byte getId() {
        return 3;
    }

    @Override
    public String getShapeName() {
        return "Square Expansion";
    }

    @Override
    public void append(MutableComponent builder) {
        ChunkPos center = new ChunkPos(this.center);
        ITask.convert("Type=Square Expansion, ", builder, ChatFormatting.DARK_PURPLE);
        ITask.convert("X=" + center.f_45578_ + ", ", builder, ChatFormatting.YELLOW);
        ITask.convert("Z=" + center.f_45579_ + ", ", builder, ChatFormatting.YELLOW);
        ITask.convert("MinRadius=" + this.minRadius + ", ", builder, ChatFormatting.BLUE);
        ITask.convert("MaxRadius=" + this.maxRadius, builder, ChatFormatting.BLUE);
    }

    @Override
    public long getTaskSize() {
        long minDiameter = (long)this.minRadius * 2L;
        long maxDiameter = (long)this.maxRadius * 2L;
        return maxDiameter * maxDiameter - minDiameter * minDiameter;
    }

    @Override
    public ChunkDeleter createTask(ServerLevel world, IProcess.PrepaireProgress progress) {
        progress.setMax(this.getTaskSize());
        ChunkDeleter deleter = new ChunkDeleter((ResourceKey<Level>)this.type, this.getSaveFile(), world);
        ChunkPos center = new ChunkPos(this.center);
        return deleter.init(ChunkShapeBuilder.getSquareExspansionShape(center.f_45578_, center.f_45579_, this.minRadius, this.maxRadius, progress), center, progress);
    }
}

