/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import pregenerator.common.commands.arguments.CenterLocation;
import pregenerator.common.commands.arguments.ICoordinate;

public class CenterArgument
implements ArgumentType<Coordinates> {
    private static final Collection<String> EXAMPLES = ObjectArrayList.wrap((Object[])new String[]{"0 0", "~ ~", "^ ^", "^1 ^-5", "~0.5 ~-5", "0b 0", "^1b ^-5b", "~0.5 ~-5b"});
    public static final SimpleCommandExceptionType POS_INCOMPLETE = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Center Coordinate Incomplete"));
    public static final SuggestionEntry[] SUGGESTIONS = new SuggestionEntry[]{new SuggestionEntry("0 0", "Chunk Position"), new SuggestionEntry("~ ~", "Player Position (~)"), new SuggestionEntry("^ ^", "Spawn Point (^)"), new SuggestionEntry("1b 100", "Block Position, (b)"), new SuggestionEntry("^100 ^", "Spawn Point with Chunk Offset (^)"), new SuggestionEntry("^100b 100", "Spawn Point with Block Offset (^)"), new SuggestionEntry("~100 ~", "Player Position with Chunk Offset (~)"), new SuggestionEntry("~100b ^100", "Player Position with Block Offset (~)")};
    public static final SuggestionEntry[] SIMPLE_SUGGESTION = new SuggestionEntry[]{new SuggestionEntry("0 0", "Chunk Position"), new SuggestionEntry("~ ~", "Player Position (~)")};

    public static CenterArgument center() {
        return new CenterArgument();
    }

    public Coordinates parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        ICoordinate coord = ICoordinate.parseCoordinate(reader);
        if (reader.canRead() && reader.peek() == ' ') {
            reader.skip();
            return new CenterLocation(coord, ICoordinate.parseCoordinate(reader));
        }
        reader.setCursor(start);
        throw POS_INCOMPLETE.createWithContext((ImmutableStringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String[] value = builder.getRemaining().split(" ");
        for (int i = 0; i < value.length; ++i) {
            for (int j = 0; j < SUGGESTIONS.length; ++j) {
                if (!SUGGESTIONS[j].matches(value[i])) continue;
                SUGGESTIONS[j].suggest(builder);
            }
        }
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> listSimpleSuggestion(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        String[] value = builder.getRemaining().split(" ");
        for (int i = 0; i < value.length; ++i) {
            for (int j = 0; j < SIMPLE_SUGGESTION.length; ++j) {
                if (!SIMPLE_SUGGESTION[j].matches(value[i])) continue;
                SIMPLE_SUGGESTION[j].suggest(builder);
            }
        }
        return builder.buildFuture();
    }

    public static BlockPos getBlockPos(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        return ((Coordinates)context.getArgument(name, Coordinates.class)).m_119568_((CommandSourceStack)context.getSource());
    }

    public static BlockPos getVanillaBlockPos(Coordinates argument, CommandSourceStack source) {
        if (argument instanceof WorldCoordinates) {
            WorldCoordinates input = (WorldCoordinates)argument;
            Vec3 result = input.m_6955_(source);
            if (input.m_6888_()) {
                result = result.m_82492_(source.m_81371_().m_7096_(), 0.0, 0.0).m_82520_(source.m_81371_().m_7096_() / 16.0, 0.0, 0.0);
            }
            if (input.m_6892_()) {
                result = result.m_82492_(0.0, source.m_81371_().m_7098_(), 0.0).m_82520_(0.0, source.m_81371_().m_7098_() / 16.0, 0.0);
            }
            if (input.m_6900_()) {
                result = result.m_82492_(0.0, 0.0, source.m_81371_().m_7094_()).m_82520_(0.0, 0.0, source.m_81371_().m_7094_() / 16.0);
            }
            return new BlockPos(result);
        }
        return argument.m_119568_(source);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static class SuggestionEntry {
        String entry;
        String tooltip;

        public SuggestionEntry(String entry, String tooltip) {
            this.entry = entry;
            this.tooltip = tooltip;
        }

        public boolean matches(String s) {
            return this.entry.toLowerCase(Locale.ROOT).startsWith(s.toLowerCase(Locale.ROOT));
        }

        public void suggest(SuggestionsBuilder builder) {
            builder.suggest(this.entry, (Message)new LiteralMessage(this.tooltip));
        }
    }
}

