/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.base;

import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import pregenerator.common.base.ProcessListener;

public class ListenerStorage {
    Object2BooleanMap<ProcessListener> listeners = new Object2BooleanLinkedOpenHashMap();

    public void read(CompoundTag nbt) {
        ListTag list = nbt.m_128437_("autoListeners", 10);
        int m = list.size();
        for (int i = 0; i < m; ++i) {
            CompoundTag data = list.m_128728_(i);
            this.listeners.put((Object)ProcessListener.create(data.m_128461_("id")), data.m_128471_("state"));
        }
    }

    public CompoundTag write(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (Object2BooleanMap.Entry entry : Object2BooleanMaps.fastIterable(this.listeners)) {
            CompoundTag data = new CompoundTag();
            data.m_128379_("state", entry.getBooleanValue());
            data.m_128359_("id", ((ProcessListener)entry.getKey()).save());
            list.add((Object)data);
        }
        nbt.m_128365_("autoListeners", (Tag)list);
        return nbt;
    }

    public void updateListeners(Set<ProcessListener> globalListeners) {
        for (Object2BooleanMap.Entry entry : Object2BooleanMaps.fastIterable(this.listeners)) {
            if (!entry.getBooleanValue()) continue;
            globalListeners.add((ProcessListener)entry.getKey());
        }
    }

    public boolean add(UUID id, boolean listen) {
        ProcessListener listener = ProcessListener.create(id);
        if (this.listeners.containsKey((Object)listener)) {
            return this.listeners.put((Object)listener, listen) != listen;
        }
        this.listeners.put((Object)listener, listen);
        return true;
    }

    public boolean remove(UUID id) {
        ProcessListener listener = ProcessListener.create(id);
        if (this.listeners.containsKey((Object)listener)) {
            this.listeners.removeBoolean((Object)listener);
            return true;
        }
        return false;
    }

    public boolean contains(UUID id) {
        return this.listeners.containsKey((Object)ProcessListener.create(id));
    }

    public boolean isIgnoring(UUID id) {
        ProcessListener listener = ProcessListener.create(id);
        return this.listeners.containsKey((Object)listener) && !this.listeners.getBoolean((Object)listener);
    }

    public boolean isAutoListening(UUID id) {
        return this.listeners.getBoolean((Object)ProcessListener.create(id));
    }

    public int getState(UUID id) {
        ProcessListener listener = ProcessListener.create(id);
        return this.listeners.containsKey((Object)listener) ? (this.listeners.getBoolean((Object)listener) ? 1 : 2) : 0;
    }
}

