/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.info;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pregenerator.base.api.Align;
import pregenerator.base.api.IRenderHelper;
import pregenerator.client.info.IProcessorInfo;
import pregenerator.common.generator.ChunkLogger;
import pregenerator.common.generator.tasks.ITask;

public class PregenProcessorInfo
implements IProcessorInfo {
    boolean running;
    boolean prepairing;
    long duration;
    long totalChunks;
    long terrainDone;
    long lightDone;
    float speed_light;
    float speed_terrain;
    int pointsOfInterest;
    int chunksLoaded;
    long lightQueue;
    int chunksToUnload;
    long prepaireValue;
    long prepaireMax;
    ITask task;
    String taskName;
    long totalMemory;
    long maxMemory;
    long freeMemory;
    float zoomIn = 0.0f;

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.prepairing = buffer.readBoolean();
        this.taskName = buffer.m_130277_();
        this.totalMemory = buffer.readLong();
        this.maxMemory = buffer.readLong();
        this.freeMemory = buffer.readLong();
        if (this.prepairing) {
            this.prepaireValue = buffer.readLong();
            this.prepaireMax = buffer.readLong();
            return;
        }
        this.running = buffer.readBoolean();
        this.duration = buffer.readLong();
        this.totalChunks = buffer.readLong();
        this.terrainDone = buffer.readLong();
        this.lightDone = buffer.readLong();
        this.speed_light = buffer.readFloat();
        this.speed_terrain = buffer.readFloat();
        this.pointsOfInterest = buffer.readInt();
        this.chunksLoaded = buffer.readInt();
        this.lightQueue = buffer.readLong();
        this.chunksToUnload = buffer.readInt();
        this.task = ITask.loadTask(buffer.m_130260_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(IRenderHelper helper, int x, int y) {
        ResourceKey<Level> type = this.task == null ? Level.f_46428_ : this.task.getDimension();
        helper.drawArea(x, y, 100, this.prepairing || !this.running ? 27 : 65);
        helper.drawText(x + 54, y + 3, Align.CENTER, "Pregen Task");
        helper.drawText(x + 4, y + 8, Align.START, "Task Name: " + this.taskName);
        helper.drawText(x + 4, y + 13, Align.START, "Dimension: " + ChunkLogger.toPascalCase(type.m_135782_().m_135815_()));
        if (this.prepairing) {
            helper.drawText(x + 4, y + 18, Align.START, "Prepairing Task");
            helper.drawProgressBar(x + 4, y + 23, 100, 5, this.maxMemory <= 0L ? 0.0f : (float)(this.totalMemory - this.freeMemory) / (float)this.maxMemory, "Ram: (" + FORMAT.format(IProcessorInfo.toMB(this.totalMemory - this.freeMemory)) + " MB / " + FORMAT.format(IProcessorInfo.toMB(this.maxMemory)) + " MB)");
            helper.drawProgressBar(x + 4, y + 28, 100, 5, this.prepaireMax <= 0L ? 0.0f : (float)this.prepaireValue / (float)this.prepaireMax, "Progress: " + FORMAT.format(this.prepaireValue) + " / " + FORMAT.format(this.prepaireMax));
            return;
        }
        if (!this.running) {
            helper.drawText(x + 4, y + 18, Align.START, "Task Paused");
            helper.drawProgressBar(x + 4, y + 23, 100, 5, this.maxMemory <= 0L ? 0.0f : (float)(this.totalMemory - this.freeMemory) / (float)this.maxMemory, "Ram: (" + FORMAT.format(IProcessorInfo.toMB(this.totalMemory - this.freeMemory)) + " MB / " + FORMAT.format(IProcessorInfo.toMB(this.maxMemory)) + " MB)");
            return;
        }
        helper.drawText(x + 4, y + 18, Align.START, "Running Time: " + this.getTime(this.duration));
        helper.drawText(x + 4, y + 23, Align.START, "ETA: Terrain: " + this.getTime((long)((float)(this.totalChunks - this.terrainDone) / this.speed_terrain) * 50L) + ", Light: " + this.getTime((long)((float)(this.totalChunks - this.lightDone) / this.speed_light) * 50L));
        helper.drawProgressBar(x + 4, y + 28, 100, 5, this.maxMemory <= 0L ? 0.0f : (float)(this.totalMemory - this.freeMemory) / (float)this.maxMemory, "Ram: (" + FORMAT.format(IProcessorInfo.toMB(this.totalMemory - this.freeMemory)) + " MB / " + FORMAT.format(IProcessorInfo.toMB(this.maxMemory)) + " MB)");
        helper.drawText(x + 4, y + 38, Align.START, "Terrain Progress: (" + ItemStack.f_41584_.format(this.speed_terrain) + " Chunks/t)");
        helper.drawProgressBar(x + 4, y + 43, 100, 5, this.totalChunks == 0L ? 0.0f : (float)this.terrainDone / (float)this.totalChunks, FORMAT.format(this.terrainDone) + " / " + FORMAT.format(this.totalChunks));
        helper.drawText(x + 4, y + 50, Align.START, "Lighting Progress: (" + ItemStack.f_41584_.format(this.speed_light) + " Chunks/t)");
        helper.drawProgressBar(x + 4, y + 55, 100, 5, this.totalChunks == 0L ? 0.0f : (float)this.lightDone / (float)this.totalChunks, FORMAT.format(this.lightDone) + " / " + FORMAT.format(this.totalChunks));
        helper.drawText(x + 4, y + 62, Align.START, "Light Queue: " + FORMAT.format(this.lightQueue) + ", To Unload: " + FORMAT.format(this.chunksToUnload));
        helper.drawText(x + 4, y + 67, Align.START, "Loaded Chunks: " + FORMAT.format(this.chunksLoaded) + ", POI: " + FORMAT.format(this.pointsOfInterest));
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public int getWidth() {
        return 109;
    }

    @Override
    public int getHeight() {
        return this.prepairing || !this.running ? 37 : 75;
    }
}

