/*
 * Decompiled with CFR 0.152.
 */
package pregenerator;

import net.minecraftforge.fml.loading.FMLEnvironment;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.Align;
import pregenerator.common.utils.config.Config;
import pregenerator.common.utils.config.ConfigEntry;
import pregenerator.common.utils.config.ConfigHandler;
import pregenerator.common.utils.config.ConfigSection;
import pregenerator.common.utils.config.impl.PregenOverlay;
import pregenerator.common.utils.plugins.IPlugin;

public class PregenConfig {
    public static final PregenConfig INSTANCE = new PregenConfig();
    ConfigHandler handler;
    public ConfigEntry.IntValue threadingRule;
    public ConfigEntry.IntValue playerLimit;
    public ConfigEntry.IntValue deletionTimeLimit;
    public ConfigEntry.BoolValue threadScheduler;
    public ConfigEntry.BoolValue autoRestart;
    public ConfigEntry.BoolValue disableDiskProtection;
    public ConfigEntry.BoolValue disableWatchDogOverride;
    public ConfigEntry.BoolValue disableMemoryLeakFix;
    public ConfigEntry.BoolValue advancedArguments;
    public ConfigEntry.BoolValue showDockerWarning;
    public ConfigEntry.BoolValue enableMemoryProtector;
    public ConfigEntry.IntValue requiredFreeMemory;
    public PregenOverlay pregenOverlay = new PregenOverlay();
    public ConfigEntry.BoolValue info;

    private PregenConfig() {
    }

    public void init() {
        Config config = new Config("base");
        this.handler = new ConfigHandler("pregen", config, true);
        ConfigSection common = config.add("Common");
        ConfigSection commands = common.addSubSection("Commands");
        this.advancedArguments = commands.addBool("Advanced Commands", FMLEnvironment.dist.isClient(), "Defines if better command arguments should be used that support Autocompletion better.", "When enabled it requires the mod to be installed on the client too");
        ConfigSection gen = common.addSubSection("Generator");
        this.threadingRule = gen.addInt("Threading Rule", 2, "Defines how many dimensions can be generated based on how many threads the CPU has.", "This is done due to how many threads mc takes, on average 6-8 can be required", "0: 1 Dimension generator no matter the CPU threads", "1>=: 1 Dimension per 10 - (configValue*2) the CPU threads").setRange(0, 5);
        this.threadScheduler = gen.addBool("Advanced Thread Scheduler", false, "Defines if the Terrain & Post processing step should be split from each other.", "This is done because Terrain gen is usually (not anymore) faster then Post Processing", "Allowing the CPU to do more work and less waiting.");
        this.playerLimit = gen.addInt("Player Limit", -1, "Define if the pregenerator should be paused if the player amount is reached").setMin(-1);
        this.autoRestart = gen.addBool("Auto Restart", false, "Defines if the Pregenerator should auto continue if the server restarts for any reason.", "This doesn't automatically restart the game");
        ConfigSection deletion = common.addSubSection("Deleter");
        this.deletionTimeLimit = deletion.addInt("Deletion Time", 10, "Defines how many Milliseconds per tic the Deletor has to do it's work.").setRange(1, 1000);
        ConfigSection tweaks = common.addSubSection("Tweaks");
        this.disableDiskProtection = tweaks.addBool("Disable Disk Protection", false, "Defines if a Small change that minecraft added to chunk writing should be not fixed.", "Said change simply ensures that everything is written in sync to disk.", "This may lead to less chunk corruption.", "Chunk Pregen disables this change due to how much more it strains the storage the data is written to.", "To the Point where damaging your hardware isn't out of the question", "1.12 and older ran without this small change and world corruption wasn't an issue to begin.", "Setting this to \"True\", will remove the disabling of the setting. Do it at your own risk");
        this.disableWatchDogOverride = tweaks.addBool("Disable Watchdog Override", false, "Defines if the Watchdog override should be disabled", "Said override increases the to much lag time from 60 seconds to 10 minutes.", "While for vanilla it isn't nessesary for modded this still is.", "This reduces the amount of crashes due to worldgen lag and ensures that there is still a fail safe present");
        this.disableMemoryLeakFix = tweaks.addBool("Disable Poi Memory Leak Fix", false, "Disables a Fix that prevents Minecraft from leaking Memory with the Points of Interest system", "This fix is incompatible with Lithium and Lithium Ports and can be fixed by disabling the \"ai.poi\" section in their Mixin Configs or by disabling this", "When this is disabled your Maximum Pregeneration Radius is a lot smaller due to the memory leaks. So if you plan larger scale pregenerations this fix shouldn't be disabled");
        this.showDockerWarning = tweaks.addBool("Show Docker Warning", true, "Defines if Chunk Pregen should throw warnings if it discovers a badly configured Docker Container that would lead to lag issues");
        this.enableMemoryProtector = tweaks.addBool("Enable Memory Protector", true, "Defines if the Memory Protector should be enabled", "If your Game runs out of Ram during Pregen. Instead of causing World Corruption the Pregenerator then will instead save the game and Kill the Process", "Then when the game restarted it will continue with fresh free ram.", "This is not nessesary for every pregeneration, but if you do a large one that takes days and you have world corruption that is the last thing you want!");
        this.requiredFreeMemory = tweaks.addInt("Required Free Memory", 384, "How low the free memory for 30 second should be before the trigger kicks in.").setMin(32);
        ConfigSection client = config.add("Client");
        this.info = client.addBool("Info Trigger", true);
        this.pregenOverlay.init(client.addSubSection("Pregen Overlay"), true, Align.START, Align.START, 1.0);
        ConfigSection plugins = config.add("Plugins");
        ChunkPregenerator.PLUGINS.init(plugins);
        ChunkPregenerator.PLUGINS.fireEvent(IPlugin::load);
        this.handler.init();
    }

    public void save() {
        this.handler.save();
    }
}

