/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.entity.BalmBlockEntity;
import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.CombinedContainer;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.container.SubContainer;
import net.blay09.mods.balm.api.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.ModSounds;
import net.blay09.mods.cookingforblockheads.api.capability.DefaultKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenSmeltingProvider;
import net.blay09.mods.cookingforblockheads.api.event.OvenCookedEvent;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.OvenBlock;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.menu.OvenMenu;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.IMutableNameable;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.tile.util.DoorAnimator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class OvenBlockEntity
extends BalmBlockEntity
implements IKitchenSmeltingProvider,
BalmMenuProvider,
IMutableNameable,
BalmContainerProvider,
BalmEnergyStorageProvider,
CustomRenderBoundingBox {
    private static final int COOK_TIME = 200;
    private final DefaultContainer container = new DefaultContainer(20){

        public boolean m_7013_(int slot, ItemStack itemStack) {
            if (slot < 3) {
                return !OvenBlockEntity.this.getSmeltingResult(itemStack).m_41619_();
            }
            if (slot == 3) {
                return OvenBlockEntity.isItemFuel(itemStack);
            }
            return true;
        }

        public void slotChanged(int slot) {
            if (slot >= 7 && slot < 16) {
                OvenBlockEntity.this.slotCookTime[slot - 7] = 0;
            }
            OvenBlockEntity.this.isDirty = true;
            OvenBlockEntity.this.m_6596_();
        }
    };
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int id) {
            if (id == 0) {
                return OvenBlockEntity.this.furnaceBurnTime;
            }
            if (id == 1) {
                return OvenBlockEntity.this.currentItemBurnTime;
            }
            if (id >= 2 && id <= 11) {
                return OvenBlockEntity.this.slotCookTime[id - 2];
            }
            return 0;
        }

        public void m_8050_(int id, int value) {
            if (id == 0) {
                OvenBlockEntity.this.furnaceBurnTime = value;
            } else if (id == 1) {
                OvenBlockEntity.this.currentItemBurnTime = value;
            } else if (id >= 2 && id <= 11) {
                OvenBlockEntity.this.slotCookTime[id - 2] = value;
            }
        }

        public int m_6499_() {
            return 11;
        }
    };
    private final EnergyStorage energyStorage = new EnergyStorage(10000){

        public int fill(int maxReceive, boolean simulate) {
            if (!simulate) {
                OvenBlockEntity.this.m_6596_();
            }
            return super.fill(maxReceive, simulate);
        }

        public int drain(int maxExtract, boolean simulate) {
            if (!simulate) {
                OvenBlockEntity.this.m_6596_();
            }
            return super.drain(maxExtract, simulate);
        }
    };
    private final SubContainer inputContainer = new SubContainer((Container)this.container, 0, 3);
    private final SubContainer fuelContainer = new SubContainer((Container)this.container, 3, 4);
    private final SubContainer outputContainer = new SubContainer((Container)this.container, 4, 7);
    private final SubContainer processingContainer = new SubContainer((Container)this.container, 7, 16);
    private final SubContainer toolsContainer = new SubContainer((Container)this.container, 16, 20);
    private final DefaultKitchenItemProvider itemProvider = new DefaultKitchenItemProvider((Container)new CombinedContainer(new Container[]{this.toolsContainer, this.outputContainer}));
    private final DoorAnimator doorAnimator = new DoorAnimator((BlockEntity)this, 1, 2);
    private Component customName;
    private boolean isFirstTick = true;
    public int[] slotCookTime = new int[9];
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    private boolean isDirty;
    private boolean hasPowerUpgrade;
    private Direction facing;
    private final Container singleSlotRecipeWrapper = new DefaultContainer(1);

    public OvenBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.oven.get(), pos, state);
        this.doorAnimator.setSoundEventOpen((SoundEvent)ModSounds.ovenOpen.get());
        this.doorAnimator.setSoundEventClose((SoundEvent)ModSounds.ovenClose.get());
    }

    public boolean m_7531_(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.m_7531_(id, type);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, OvenBlockEntity blockEntity) {
        blockEntity.clientTick(level, pos, state);
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
        this.doorAnimator.update();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, OvenBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.isFirstTick && state.m_60734_() == ModBlocks.oven) {
            this.facing = (Direction)state.m_61143_((Property)OvenBlock.FACING);
            this.isFirstTick = false;
        }
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
        boolean hasChanged = false;
        int burnPotential = 200 - this.furnaceBurnTime;
        if (this.hasPowerUpgrade && burnPotential > 0 && this.shouldConsumeFuel()) {
            this.furnaceBurnTime += this.energyStorage.drain(burnPotential, false);
        }
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!level.f_46443_) {
            ItemStack itemStack;
            if (this.furnaceBurnTime == 0 && this.shouldConsumeFuel()) {
                for (int i = 0; i < this.fuelContainer.m_6643_(); ++i) {
                    ItemStack fuelItem = this.fuelContainer.m_8020_(i);
                    if (fuelItem.m_41619_()) continue;
                    this.currentItemBurnTime = this.furnaceBurnTime = (int)Math.max(1.0, (double)OvenBlockEntity.getBurnTime(fuelItem) * CookingForBlockheadsConfig.getActive().ovenFuelTimeMultiplier);
                    if (this.furnaceBurnTime == 0) break;
                    ItemStack containerItem = Balm.getHooks().getCraftingRemainingItem(fuelItem);
                    fuelItem.m_41774_(1);
                    if (fuelItem.m_41619_()) {
                        this.fuelContainer.m_6836_(i, containerItem);
                    }
                    hasChanged = true;
                    break;
                }
            }
            int firstEmptySlot = -1;
            int firstTransferSlot = -1;
            for (int i = 0; i < this.processingContainer.m_6643_(); ++i) {
                itemStack = this.processingContainer.m_8020_(i);
                if (!itemStack.m_41619_()) {
                    if (this.slotCookTime[i] != -1) {
                        ItemStack smeltingResult;
                        double maxCookTime = 200.0 * CookingForBlockheadsConfig.getActive().ovenCookTimeMultiplier;
                        if ((double)this.slotCookTime[i] >= maxCookTime && firstTransferSlot == -1) {
                            firstTransferSlot = i;
                            continue;
                        }
                        if (this.furnaceBurnTime > 0) {
                            int n = i;
                            this.slotCookTime[n] = this.slotCookTime[n] + 1;
                        }
                        if (!((double)this.slotCookTime[i] >= maxCookTime) || (smeltingResult = this.getSmeltingResult(itemStack)).m_41619_()) continue;
                        ItemStack resultStack = smeltingResult.m_41777_();
                        this.processingContainer.m_6836_(i, resultStack);
                        Balm.getEvents().fireEvent((Object)new OvenCookedEvent(level, this.f_58858_, resultStack));
                        this.slotCookTime[i] = -1;
                        if (firstTransferSlot != -1) continue;
                        firstTransferSlot = i;
                        continue;
                    }
                    if (firstTransferSlot != -1) continue;
                    firstTransferSlot = i;
                    continue;
                }
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
            }
            if (firstTransferSlot != -1) {
                ItemStack transferStack = this.processingContainer.m_8020_(firstTransferSlot);
                transferStack = ContainerUtils.insertItemStacked((Container)this.outputContainer, (ItemStack)transferStack, (boolean)false);
                this.processingContainer.m_6836_(firstTransferSlot, transferStack);
                if (transferStack.m_41619_()) {
                    this.slotCookTime[firstTransferSlot] = 0;
                }
                hasChanged = true;
            }
            if (firstEmptySlot != -1) {
                for (int j = 0; j < this.inputContainer.m_6643_(); ++j) {
                    itemStack = this.inputContainer.m_8020_(j);
                    if (itemStack.m_41619_()) continue;
                    this.processingContainer.m_6836_(firstEmptySlot, itemStack.m_41620_(1));
                    if (itemStack.m_41613_() > 0) break;
                    this.inputContainer.m_6836_(j, ItemStack.f_41583_);
                    break;
                }
            }
        }
        if (hasChanged) {
            this.m_6596_();
        }
    }

    public ItemStack getSmeltingResult(ItemStack itemStack) {
        ItemStack result = CookingRegistry.getSmeltingResult(itemStack);
        if (!result.m_41619_()) {
            return result;
        }
        this.singleSlotRecipeWrapper.m_6836_(0, itemStack);
        Recipe recipe = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44108_, this.singleSlotRecipeWrapper, this.f_58857_).orElse(null);
        if (recipe != null && !(result = recipe.m_8043_()).m_41619_() && result.m_41720_().m_41472_()) {
            return result;
        }
        if (!result.m_41619_() && CookingRegistry.isNonFoodRecipe(result)) {
            return result;
        }
        return ItemStack.f_41583_;
    }

    public static boolean isItemFuel(ItemStack itemStack) {
        if (CookingForBlockheadsConfig.getActive().ovenRequiresCookingOil) {
            return itemStack.m_204117_(Compat.getCookingOilTag());
        }
        return OvenBlockEntity.getBurnTime(itemStack) > 0;
    }

    protected static int getBurnTime(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return 0;
        }
        if (CookingForBlockheadsConfig.getActive().ovenRequiresCookingOil && itemStack.m_204117_(Compat.getCookingOilTag())) {
            return 800;
        }
        return Balm.getHooks().getBurnTime(itemStack);
    }

    private boolean shouldConsumeFuel() {
        for (int i = 0; i < this.processingContainer.m_6643_(); ++i) {
            ItemStack cookingStack = this.processingContainer.m_8020_(i);
            if (cookingStack.m_41619_() || this.slotCookTime[i] == -1) continue;
            return true;
        }
        return false;
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.container.deserialize(tagCompound.m_128469_("ItemHandler"));
        this.furnaceBurnTime = tagCompound.m_128448_("BurnTime");
        this.currentItemBurnTime = tagCompound.m_128448_("CurrentItemBurnTime");
        this.slotCookTime = tagCompound.m_128465_("CookTimes");
        if (this.slotCookTime.length != 9) {
            this.slotCookTime = new int[9];
        }
        this.hasPowerUpgrade = tagCompound.m_128471_("HasPowerUpgrade");
        this.energyStorage.setEnergy(tagCompound.m_128451_("EnergyStored"));
        if (tagCompound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)tagCompound.m_128461_("CustomName"));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("ItemHandler", (Tag)this.container.serialize());
        tag.m_128376_("BurnTime", (short)this.furnaceBurnTime);
        tag.m_128376_("CurrentItemBurnTime", (short)this.currentItemBurnTime);
        tag.m_128385_("CookTimes", ArrayUtils.clone((int[])this.slotCookTime));
        tag.m_128379_("HasPowerUpgrade", this.hasPowerUpgrade);
        tag.m_128405_("EnergyStored", this.energyStorage.getEnergy());
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        if (tag.m_128425_("IsForcedOpen", 1)) {
            this.doorAnimator.setForcedOpen(tag.m_128471_("IsForcedOpen"));
        }
        if (tag.m_128425_("NumPlayersUsing", 1)) {
            this.doorAnimator.setNumPlayersUsing(tag.m_128445_("NumPlayersUsing"));
        }
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.m_183515_(tag);
        tag.m_128379_("IsForcedOpen", this.doorAnimator.isForcedOpen());
        tag.m_128344_("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
    }

    public boolean hasPowerUpgrade() {
        return this.hasPowerUpgrade;
    }

    public void setHasPowerUpgrade(boolean hasPowerUpgrade) {
        this.hasPowerUpgrade = hasPowerUpgrade;
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)OvenBlock.POWERED, (Comparable)Boolean.valueOf(hasPowerUpgrade)));
        this.m_6596_();
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public float getBurnTimeProgress() {
        if (this.currentItemBurnTime == 0 && this.furnaceBurnTime > 0) {
            return 1.0f;
        }
        return (float)this.furnaceBurnTime / (float)this.currentItemBurnTime;
    }

    public float getCookProgress(int i) {
        return (float)this.slotCookTime[i] / (float)(200.0 * CookingForBlockheadsConfig.getActive().ovenCookTimeMultiplier);
    }

    @Override
    public ItemStack smeltItem(ItemStack itemStack) {
        return ContainerUtils.insertItemStacked((Container)this.inputContainer, (ItemStack)itemStack, (boolean)false);
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public ItemStack getToolItem(int i) {
        return this.toolsContainer.m_8020_(i);
    }

    public void setToolItem(int i, ItemStack itemStack) {
        this.toolsContainer.m_6836_(i, itemStack);
    }

    public Container getContainer(Direction side) {
        if (side == null) {
            return this.getContainer();
        }
        return switch (side) {
            case Direction.UP -> this.inputContainer;
            case Direction.DOWN -> this.outputContainer;
            default -> this.fuelContainer;
        };
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(IKitchenItemProvider.class, (Object)this.itemProvider), new BalmProvider(IKitchenSmeltingProvider.class, (Object)this)});
    }

    public Container getInputContainer() {
        return this.inputContainer;
    }

    public Container getFuelContainer() {
        return this.fuelContainer;
    }

    public Direction getFacing() {
        return this.facing == null ? Direction.NORTH : this.facing;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new OvenMenu(i, playerInventory, this);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(-1, 0, -1), this.f_58858_.m_7918_(2, 1, 2));
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public void setCustomName(Component customName) {
        this.customName = customName;
        this.m_6596_();
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)"container.cookingforblockheads.oven");
    }

    public Container getContainer() {
        return this.container;
    }

    public ContainerData getContainerData() {
        return this.dataAccess;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }
}

