/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.nodes;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.ICoverable;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.SlottedCraftingRequest;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import edivad.extrastorage.blockentity.AdvancedExporterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class AdvancedExporterNetworkNode
extends NetworkNode
implements IComparable,
IType,
ICoverable {
    public static final ResourceLocation ID = new ResourceLocation("extrastorage", "advanced_exporter");
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private static final int SLOTS = 18;
    private final BaseItemHandler itemFilters = new BaseItemHandler(18).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private final FluidInventory fluidFilters = new FluidInventory(18).addListener((InventoryListener)new NetworkNodeFluidInventoryListener((INetworkNode)this));
    private final CoverManager coverManager;
    private int compare = 1;
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, new UpgradeItem.Type[]{UpgradeItem.Type.SPEED, UpgradeItem.Type.CRAFTING, UpgradeItem.Type.STACK, UpgradeItem.Type.REGULATOR}).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this)).addListener((handler, slot, reading) -> {
        if (!reading && !this.getUpgrades().hasUpgrade(UpgradeItem.Type.REGULATOR)) {
            boolean changed = false;
            for (int i = 0; i < 18; ++i) {
                FluidStack filteredFluid;
                ItemStack filteredItem = this.itemFilters.getStackInSlot(i);
                if (filteredItem.m_41613_() > 1) {
                    filteredItem.m_41764_(1);
                    changed = true;
                }
                if ((filteredFluid = this.fluidFilters.getFluid(i)).isEmpty() || filteredFluid.getAmount() == 1000) continue;
                filteredFluid.setAmount(1000);
                changed = true;
            }
            if (changed) {
                this.markDirty();
            }
        }
    });
    private int type = 0;
    private int filterSlot;

    public AdvancedExporterNetworkNode(Level level, BlockPos pos) {
        super(level, pos);
        this.coverManager = new CoverManager((NetworkNode)this);
    }

    public int getEnergyUsage() {
        return 4 * (RS.SERVER_CONFIG.getExporter().getUsage() + this.upgrades.getEnergyUsage());
    }

    public void update() {
        super.update();
        if (this.canUpdate() && this.ticks % this.upgrades.getSpeed() == 0 && this.level.m_46749_(this.pos)) {
            if (this.type == 0) {
                IItemHandler handler = LevelUtils.getItemHandler((BlockEntity)this.getFacingBlockEntity(), (Direction)this.getDirection().m_122424_());
                if (handler != null) {
                    ItemStack slot;
                    int handlerSlots = handler.getSlots();
                    while (this.filterSlot + 1 < 18 && this.itemFilters.getStackInSlot(this.filterSlot).m_41619_()) {
                        ++this.filterSlot;
                    }
                    if (this.filterSlot == 17 && this.itemFilters.getStackInSlot(this.filterSlot).m_41619_() || this.filterSlot >= 18) {
                        this.filterSlot = 0;
                    }
                    if (!(slot = this.itemFilters.getStackInSlot(this.filterSlot)).m_41619_()) {
                        int stackSize = this.upgrades.getStackInteractCount();
                        if (this.upgrades.hasUpgrade(UpgradeItem.Type.REGULATOR)) {
                            int found = 0;
                            for (int i = 0; i < handlerSlots; ++i) {
                                ItemStack stackInConnectedHandler = handler.getStackInSlot(i);
                                if (!API.instance().getComparer().isEqual(slot, stackInConnectedHandler, this.compare)) continue;
                                found += stackInConnectedHandler.m_41613_();
                            }
                            int needed = 0;
                            for (int i = 0; i < 18; ++i) {
                                if (!API.instance().getComparer().isEqualNoQuantity(slot, this.itemFilters.getStackInSlot(i))) continue;
                                needed += this.itemFilters.getStackInSlot(i).m_41613_();
                            }
                            stackSize = Math.min(stackSize, needed - found);
                        }
                        if (stackSize > 0) {
                            ItemStack took = this.network.extractItem(slot, Math.min(slot.m_41741_(), stackSize), this.compare, Action.SIMULATE);
                            if (took.m_41619_()) {
                                if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
                                    this.network.getCraftingManager().request((Object)new SlottedCraftingRequest((INetworkNode)this, this.filterSlot), slot, stackSize);
                                }
                            } else {
                                ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)took, (boolean)true);
                                int correctedStackSize = took.m_41613_() - remainder.m_41613_();
                                if (correctedStackSize > 0) {
                                    took = this.network.extractItem(slot, correctedStackSize, this.compare, Action.PERFORM);
                                    ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)took, (boolean)false);
                                }
                            }
                        }
                    }
                    ++this.filterSlot;
                }
            } else if (this.type == 1) {
                IFluidHandler handler;
                FluidStack[] fluids = this.fluidFilters.getFluids();
                while (this.filterSlot + 1 < fluids.length && fluids[this.filterSlot] == null) {
                    ++this.filterSlot;
                }
                if (this.filterSlot == fluids.length - 1 && fluids[this.filterSlot] == null || this.filterSlot >= fluids.length) {
                    this.filterSlot = 0;
                }
                if ((handler = LevelUtils.getFluidHandler((BlockEntity)this.getFacingBlockEntity(), (Direction)this.getDirection().m_122424_())) != null) {
                    FluidStack stack = fluids[this.filterSlot];
                    if (stack != null) {
                        int toExtract = 1000 * this.upgrades.getStackInteractCount();
                        FluidStack stackInStorage = (FluidStack)this.network.getFluidStorageCache().getList().get((Object)stack, this.compare);
                        if (stackInStorage != null) {
                            FluidStack took;
                            int filled;
                            toExtract = Math.min(toExtract, stackInStorage.getAmount());
                            if (this.upgrades.hasUpgrade(UpgradeItem.Type.REGULATOR)) {
                                int found = 0;
                                for (int i = 0; i < handler.getTanks(); ++i) {
                                    FluidStack stackInConnectedHandler = handler.getFluidInTank(i);
                                    if (!API.instance().getComparer().isEqual(stack, stackInConnectedHandler, this.compare)) continue;
                                    found += stackInConnectedHandler.getAmount();
                                }
                                int needed = 0;
                                for (int i = 0; i < 18; ++i) {
                                    if (!API.instance().getComparer().isEqual(stack, this.fluidFilters.getFluid(i), 1)) continue;
                                    needed += this.fluidFilters.getFluid(i).getAmount();
                                }
                                toExtract = Math.min(toExtract, needed - found);
                            }
                            if (toExtract > 0 && (filled = handler.fill(took = this.network.extractFluid(stack, toExtract, this.compare, Action.SIMULATE), IFluidHandler.FluidAction.SIMULATE)) > 0) {
                                took = this.network.extractFluid(stack, filled, this.compare, Action.PERFORM);
                                handler.fill(took, IFluidHandler.FluidAction.EXECUTE);
                            }
                        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
                            this.network.getCraftingManager().request((Object)this, stack, toExtract);
                        }
                    }
                    ++this.filterSlot;
                }
            }
        }
    }

    public int getCompare() {
        return this.compare;
    }

    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    public ResourceLocation getId() {
        return ID;
    }

    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        tag.m_128365_(CoverManager.NBT_COVER_MANAGER, (Tag)this.coverManager.writeToNbt());
        StackUtils.writeItems((IItemHandler)this.upgrades, (int)1, (CompoundTag)tag);
        return tag;
    }

    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        tag.m_128405_(NBT_COMPARE, this.compare);
        tag.m_128405_(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilters, (int)0, (CompoundTag)tag);
        tag.m_128365_(NBT_FLUID_FILTERS, (Tag)this.fluidFilters.writeToNbt());
        return tag;
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        if (tag.m_128441_(CoverManager.NBT_COVER_MANAGER)) {
            this.coverManager.readFromNbt(tag.m_128469_(CoverManager.NBT_COVER_MANAGER));
        }
        StackUtils.readItems((BaseItemHandler)this.upgrades, (int)1, (CompoundTag)tag);
    }

    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        if (tag.m_128441_(NBT_COMPARE)) {
            this.compare = tag.m_128451_(NBT_COMPARE);
        }
        if (tag.m_128441_(NBT_TYPE)) {
            this.type = tag.m_128451_(NBT_TYPE);
        }
        StackUtils.readItems((BaseItemHandler)this.itemFilters, (int)0, (CompoundTag)tag);
        if (tag.m_128441_(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.m_128469_(NBT_FLUID_FILTERS));
        }
    }

    public UpgradeItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getDrops() {
        return this.getUpgrades();
    }

    public int getType() {
        return this.level.f_46443_ ? (Integer)AdvancedExporterBlockEntity.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    public CoverManager getCoverManager() {
        return this.coverManager;
    }
}

