/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.mixin.oxygen;

import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import earth.terrarium.ad_astra.common.registry.ModBlocks;
import earth.terrarium.ad_astra.common.registry.ModTags;
import earth.terrarium.ad_astra.common.util.OxygenUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockItem.class})
public abstract class BlockItemMixin {
    @Unique
    private static void adastra_playFireExtinguish(BlockPos pos, Level level) {
        level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Inject(method={"place*"}, at={@At(value="TAIL")})
    public void adastra_place(BlockPlaceContext context, CallbackInfoReturnable<InteractionResult> cir) {
        BlockPos pos;
        if (!AdAstraConfig.doOxygen) {
            return;
        }
        Level level = context.m_43725_();
        if (!level.f_46443_ && !OxygenUtils.posHasOxygen(level, pos = context.m_8083_())) {
            BlockState blockstate = level.m_8055_(context.m_8083_());
            Block block = blockstate.m_60734_();
            boolean playSound = false;
            if (blockstate.m_204336_(ModTags.BURNS_OUT) && blockstate.m_61138_((Property)BlockStateProperties.f_61443_)) {
                level.m_7731_(pos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 3);
                playSound = true;
            } else if (block instanceof WallTorchBlock && !block.equals(Blocks.f_50140_)) {
                level.m_7731_(pos, (BlockState)((Block)ModBlocks.WALL_EXTINGUISHED_TORCH.get()).m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)((Direction)blockstate.m_61143_((Property)WallTorchBlock.f_58119_))), 3);
                playSound = true;
            } else if (block instanceof TorchBlock && !block.equals(Blocks.f_50139_) && !block.equals(Blocks.f_50140_)) {
                if (!block.equals(Blocks.f_50174_) && !block.equals(Blocks.f_50123_)) {
                    level.m_7731_(pos, ((Block)ModBlocks.EXTINGUISHED_TORCH.get()).m_49966_(), 3);
                    playSound = true;
                }
            } else if (block instanceof LanternBlock && !block.equals(Blocks.f_50682_)) {
                level.m_7731_(pos, (BlockState)((Block)ModBlocks.EXTINGUISHED_LANTERN.get()).m_49966_().m_61124_((Property)LanternBlock.f_153459_, (Comparable)((Boolean)blockstate.m_61143_((Property)LanternBlock.f_153459_))), 3);
                playSound = true;
            } else if (block instanceof CampfireBlock && !block.equals(Blocks.f_50684_) && ((Boolean)blockstate.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                level.m_7731_(pos, (BlockState)blockstate.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)), 3);
                playSound = true;
            }
            if (playSound) {
                BlockItemMixin.adastra_playFireExtinguish(pos, level);
            }
        }
    }
}

