/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.mixin.gravity;

import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import earth.terrarium.ad_astra.common.util.ModUtils;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityGravityMixin {
    @Unique
    private static final double CONSTANT = 0.08;

    @Inject(method={"travel"}, at={@At(value="TAIL")})
    public void adastra_travel(CallbackInfo ci) {
        if (AdAstraConfig.doLivingEntityGravity) {
            LivingEntity entity = (LivingEntity)this;
            Vec3 velocity = entity.m_20184_();
            if (!(entity.m_20068_() || entity.m_20069_() || entity.m_20077_() || entity.m_21255_() || entity.m_21023_(MobEffects.f_19591_))) {
                double newGravity = 0.08 * (double)ModUtils.getEntityGravity((Entity)entity);
                entity.m_20334_(velocity.m_7096_(), velocity.m_7098_() + 0.08 - newGravity, velocity.m_7094_());
            }
        }
    }

    @ModifyVariable(method={"causeFallDamage"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true)
    private float adastra_causeFallDamage(float damageMultiplier) {
        LivingEntity entity = (LivingEntity)this;
        return damageMultiplier * ModUtils.getEntityGravity((Entity)entity);
    }
}

