/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.mixin.client;

import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.ad_astra.common.util.OxygenUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SoundManager.class})
public class SoundManagerMixin {
    @Shadow
    @Final
    public SoundEngine f_120349_;

    @Unique
    private static SoundInstance getSpaceSoundInstance(final SoundInstance sound, final float volume, final float pitch) {
        return new SoundInstance(){

            public ResourceLocation m_7904_() {
                return sound.m_7904_();
            }

            public WeighedSoundEvents m_6775_(SoundManager manager) {
                return sound.m_6775_(manager);
            }

            public Sound m_5891_() {
                return sound.m_5891_();
            }

            public SoundSource m_8070_() {
                return sound.m_8070_();
            }

            public boolean m_7775_() {
                return sound.m_7775_();
            }

            public boolean m_7796_() {
                return sound.m_7796_();
            }

            public int m_7766_() {
                return sound.m_7766_();
            }

            public float m_7769_() {
                return sound.m_7769_() * volume;
            }

            public float m_7783_() {
                return sound.m_7783_() * pitch;
            }

            public double m_7772_() {
                return sound.m_7772_();
            }

            public double m_7780_() {
                return sound.m_7780_();
            }

            public double m_7778_() {
                return sound.m_7778_();
            }

            public SoundInstance.Attenuation m_7438_() {
                return sound.m_7438_();
            }
        };
    }

    @Inject(method={"play(Lnet/minecraft/client/resources/sounds/SoundInstance;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void adastra_play(SoundInstance sound, CallbackInfo ci) {
        this.adastra_modifySound(sound, 0, ci);
    }

    @Inject(method={"playDelayed(Lnet/minecraft/client/resources/sounds/SoundInstance;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void adastra_play(SoundInstance sound, int delay, CallbackInfo ci) {
        this.adastra_modifySound(sound, delay, ci);
    }

    @Unique
    private void adastra_modifySound(SoundInstance sound, int delay, CallbackInfo ci) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            return;
        }
        if (!AdAstraConfig.doSpaceMuffler) {
            return;
        }
        if (sound.m_8070_().equals((Object)SoundSource.MASTER)) {
            return;
        }
        if (sound.m_7904_().equals((Object)new ResourceLocation("ad_astra", "rocket_fly"))) {
            return;
        }
        if (sound.m_7904_().equals((Object)SoundEvents.f_11886_.m_11660_())) {
            return;
        }
        if (ModUtils.isOrbitlevel((Level)minecraft.f_91073_)) {
            boolean noOxygen;
            boolean bl = noOxygen = !OxygenUtils.posHasOxygen((Level)minecraft.f_91073_, new BlockPos(sound.m_7772_(), sound.m_7780_(), sound.m_7778_()));
            if (minecraft.f_91073_ != null && noOxygen || sound.m_8070_().equals((Object)SoundSource.MUSIC) || sound.m_8070_().equals((Object)SoundSource.RECORDS) || sound.m_8070_().equals((Object)SoundSource.AMBIENT)) {
                ci.cancel();
                SoundInstance newSound = SoundManagerMixin.getSpaceSoundInstance(sound, sound.m_8070_().equals((Object)SoundSource.MUSIC) || sound.m_8070_().equals((Object)SoundSource.RECORDS) || sound.m_8070_().equals((Object)SoundSource.AMBIENT) ? 1.0f : 0.1f, 0.1f);
                this.f_120349_.m_120312_(newSound);
            }
        }
    }
}

