/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.mixin;

import earth.terrarium.ad_astra.common.entity.system.EntityAcidRainSystem;
import earth.terrarium.ad_astra.common.entity.system.EntityOxygenSystem;
import earth.terrarium.ad_astra.common.entity.system.EntityTemperatureSystem;
import earth.terrarium.ad_astra.common.entity.vehicle.Vehicle;
import earth.terrarium.ad_astra.common.registry.ModTags;
import earth.terrarium.ad_astra.common.util.ModUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void adastra_handleFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        Vehicle vehicle;
        LivingEntity entity = (LivingEntity)this;
        Entity entity2 = entity.m_20202_();
        if (entity2 instanceof Vehicle && !(vehicle = (Vehicle)entity2).canRiderTakeFallDamage()) {
            cir.setReturnValue((Object)false);
        }
        if (fallDistance <= 3.0f / ModUtils.getEntityGravity((Entity)entity)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void adastra_damage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if ((source.m_19384_() || source.equals(DamageSource.f_19309_)) && (entity.m_6060_() || source.equals(DamageSource.f_19309_)) && ModUtils.checkTag((Entity)entity, ModTags.FIRE_IMMUNE)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void adastra_tick(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        Level level = entity.f_19853_;
        if (!level.f_46443_ && level.m_46467_() % 10L == 0L) {
            Player player;
            if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_())) {
                return;
            }
            EntityOxygenSystem.oxygenTick(entity, (ServerLevel)level);
            if (!ModUtils.isSpacelevel(level)) {
                return;
            }
            EntityTemperatureSystem.temperatureTick(entity, (ServerLevel)level);
            EntityAcidRainSystem.acidRainTick(entity, (ServerLevel)level);
        }
    }
}

