/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.util.forge;

import earth.terrarium.ad_astra.common.util.forge.AdAstraTeleporter;
import earth.terrarium.ad_astra.mixin.forge.AxeItemAccessor;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.NotNull;

public class PlatformUtilsImpl {
    public static CreativeModeTab createTab(ResourceLocation loc, final Supplier<ItemStack> icon) {
        return new CreativeModeTab(loc.m_135827_() + "." + loc.m_135815_()){

            @NotNull
            public ItemStack m_6976_() {
                return (ItemStack)icon.get();
            }
        };
    }

    public static <T extends Entity> T teleportToDimension(T entity, ServerLevel level, PortalInfo target) {
        return (T)entity.changeDimension(level, (ITeleporter)new AdAstraTeleporter(target));
    }

    public static void registerStrippedLog(Block log, Block strippedLog) {
        HashMap<Block, Block> strippedBlocks = new HashMap<Block, Block>(AxeItemAccessor.adastra_getStrippables());
        strippedBlocks.put(log, strippedLog);
        AxeItemAccessor.adastra_setStrippables(strippedBlocks);
    }

    public static Supplier<Item> createSpawnEggItem(Supplier<? extends EntityType<? extends Mob>> type, int primaryColor, int secondaryColor, Item.Properties properties) {
        return () -> new ForgeSpawnEggItem(type, primaryColor, secondaryColor, properties);
    }

    public static <T extends Mob> void registerSpawnPlacement(EntityType<T> entityType, SpawnPlacements.Type decoratorType, Heightmap.Types heightMapType, SpawnPlacements.SpawnPredicate<T> decoratorPredicate) {
        SpawnPlacements.m_21754_(entityType, (SpawnPlacements.Type)decoratorType, (Heightmap.Types)heightMapType, decoratorPredicate);
    }
}

