/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.item.armor;

import dev.architectury.injectables.annotations.PlatformOnly;
import earth.terrarium.ad_astra.client.screen.PlayerOverlayScreen;
import earth.terrarium.ad_astra.common.config.SpaceSuitConfig;
import earth.terrarium.ad_astra.common.item.armor.NetheriteSpaceSuit;
import earth.terrarium.ad_astra.common.registry.ModItems;
import earth.terrarium.ad_astra.common.util.ModKeyBindings;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.botarium.api.energy.EnergyHooks;
import earth.terrarium.botarium.api.energy.EnergyItem;
import earth.terrarium.botarium.api.energy.ItemEnergyContainer;
import earth.terrarium.botarium.api.energy.PlatformItemEnergyManager;
import earth.terrarium.botarium.api.item.ItemStackHolder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JetSuit
extends NetheriteSpaceSuit
implements EnergyItem {
    public boolean isFallFlying;

    public JetSuit(ArmorMaterial material, EquipmentSlot slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    public static void spawnParticles(Level level, LivingEntity entity, HumanoidModel<LivingEntity> model) {
        if (!SpaceSuitConfig.spawnJetSuitParticles) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            CompoundTag nbt = chest.m_41784_();
            if (nbt.m_128441_("SpawnParticles")) {
                if (!nbt.m_128471_("SpawnParticles")) {
                    return;
                }
            } else {
                return;
            }
        }
        JetSuit.spawnParticles(level, entity, (double)model.f_102811_.f_104203_ + 0.05, entity.m_21255_() ? 0.0 : 0.8, -0.45);
        JetSuit.spawnParticles(level, entity, (double)model.f_102812_.f_104203_ + 0.05, entity.m_21255_() ? 0.0 : 0.8, 0.45);
        JetSuit.spawnParticles(level, entity, (double)model.f_102813_.f_104203_ + 0.05, entity.m_21255_() ? 0.1 : 0.0, -0.1);
        JetSuit.spawnParticles(level, entity, (double)model.f_102814_.f_104203_ + 0.05, entity.m_21255_() ? 0.1 : 0.0, 0.1);
    }

    private static void spawnParticles(Level level, LivingEntity entity, double pitch, double yOffset, double zOffset) {
        double yaw = entity.f_20883_;
        double xRotator = Math.cos(yaw * Math.PI / 180.0) * zOffset;
        double zRotator = Math.sin(yaw * Math.PI / 180.0) * zOffset;
        double xRotator1 = Math.cos((yaw - 90.0) * Math.PI / 180.0) * pitch;
        double zRotator1 = Math.sin((yaw - 90.0) * Math.PI / 180.0) * pitch;
        level.m_6493_((ParticleOptions)ParticleTypes.f_123745_, true, entity.m_20185_() + xRotator + xRotator1, entity.m_20186_() + yOffset, entity.m_20189_() + zRotator1 + zRotator, 0.0, 0.0, 0.0);
    }

    public static boolean hasFullSet(LivingEntity entity) {
        for (ItemStack stack : entity.m_6168_()) {
            if (stack.m_41720_() instanceof JetSuit) continue;
            return false;
        }
        return true;
    }

    public static void updateBatteryOverlay(ItemStack suit) {
        PlatformItemEnergyManager energy = EnergyHooks.getItemEnergyManager((ItemStack)suit);
        PlayerOverlayScreen.batteryRatio = (double)energy.getStoredEnergy() / (double)energy.getCapacity();
    }

    @Override
    public long getTankSize() {
        return SpaceSuitConfig.jetSuitTankSize;
    }

    @Override
    public void m_7373_(ItemStack stack, Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag context) {
        super.m_7373_(stack, level, tooltip, context);
        if (stack.m_150930_((Item)ModItems.JET_SUIT.get())) {
            long energy = EnergyHooks.getItemEnergyManager((ItemStack)stack).getStoredEnergy();
            tooltip.add((Component)Component.m_237110_((String)"gauge_text.ad_astra.storage", (Object[])new Object[]{energy, SpaceSuitConfig.jetSuitMaxEnergy}).m_6270_(Style.f_131099_.m_131140_(energy > 0L ? ChatFormatting.GREEN : ChatFormatting.RED)));
        }
    }

    public void fly(Player player, ItemStack stack) {
        if (!SpaceSuitConfig.enableJetSuitFlight) {
            return;
        }
        ItemStackHolder stackHolder = new ItemStackHolder(stack);
        if (player.m_150110_().f_35935_) {
            stack.m_41784_().m_128379_("SpawnParticles", false);
            return;
        }
        if (EnergyHooks.getItemEnergyManager((ItemStack)stack).getStoredEnergy() <= 0L) {
            stack.m_41784_().m_128379_("SpawnParticles", false);
            return;
        }
        stack.m_41784_().m_128379_("SpawnParticles", true);
        if (ModKeyBindings.sprintKeyDown(player)) {
            this.fallFly(player, stackHolder);
        } else {
            this.flyUpward(player, stackHolder);
        }
        if (!player.f_19853_.f_46443_) {
            if (this.isFallFlying) {
                if (!player.m_21255_()) {
                    player.m_36320_();
                }
            } else if (player.m_21255_()) {
                player.m_36321_();
            }
        }
        if (stackHolder.isDirty()) {
            player.m_8061_(EquipmentSlot.CHEST, stackHolder.getStack());
        }
    }

    public void flyUpward(Player player, ItemStackHolder stack) {
        if (EnergyHooks.isEnergyItem((ItemStack)stack.getStack())) {
            player.f_19789_ /= 2.0f;
            PlatformItemEnergyManager energy = EnergyHooks.getItemEnergyManager((ItemStack)stack.getStack());
            long tickEnergy = SpaceSuitConfig.jetSuitEnergyPerTick;
            if (!player.m_7500_()) {
                energy.extract(stack, tickEnergy, false);
            }
            this.isFallFlying = false;
            double speed = SpaceSuitConfig.jetSuitUpwardsSpeed;
            player.m_20256_(player.m_20184_().m_82520_(0.0, speed, 0.0));
            if (player.m_20184_().m_7098_() > speed) {
                player.m_20334_(player.m_20184_().m_7096_(), speed, player.m_20184_().m_7094_());
            }
        }
    }

    public void fallFly(Player player, ItemStackHolder stack) {
        if (player.m_20096_()) {
            player.f_19789_ /= 2.0f;
        }
        PlatformItemEnergyManager energy = EnergyHooks.getItemEnergyManager((ItemStack)stack.getStack());
        long tickEnergy = SpaceSuitConfig.jetSuitEnergyPerTick;
        if (!player.m_7500_()) {
            energy.extract(stack, tickEnergy, false);
        }
        this.isFallFlying = true;
        double speed = SpaceSuitConfig.jetSuitSpeed - (double)ModUtils.getEntityGravity((Entity)player) * 0.25;
        Vec3 rotationVector = player.m_20154_().m_82490_(speed);
        Vec3 velocity = player.m_20184_();
        player.m_20256_(velocity.m_82520_(rotationVector.m_7096_() * 0.1 + (rotationVector.m_7096_() * 1.5 - velocity.m_7096_()) * 0.5, rotationVector.m_7098_() * 0.1 + (rotationVector.m_7098_() * 1.5 - velocity.m_7098_()) * 0.5, rotationVector.m_7094_() * 0.1 + (rotationVector.m_7094_() * 1.5 - velocity.m_7094_()) * 0.5));
    }

    public ItemEnergyContainer getEnergyStorage(ItemStack itemStack) {
        return new ItemEnergyContainer(itemStack, SpaceSuitConfig.jetSuitMaxEnergy){

            public long maxInsert() {
                return 512L;
            }

            public long maxExtract() {
                return 256L;
            }
        };
    }

    @Override
    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        if (slot.equals((Object)EquipmentSlot.CHEST) && stack.m_41720_() instanceof JetSuit) {
            PlatformItemEnergyManager energy = EnergyHooks.getItemEnergyManager((ItemStack)stack);
            return new ResourceLocation("ad_astra", "textures/entity/armour/jet_suit/jet_suit_" + (energy.getStoredEnergy() == 0L ? 0 : (int)Math.min(energy.getStoredEnergy() * 5L / energy.getCapacity() + 1L, 5L)) + ".png").toString();
        }
        return "ad_astra:textures/entity/armour/jet_suit/jet_suit_5.png";
    }

    @PlatformOnly(value={"forge"})
    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        int nextFlightTick;
        ItemStack chest;
        if (!entity.f_19853_.f_46443_ && (chest = entity.m_6844_(EquipmentSlot.CHEST)).m_41720_() instanceof JetSuit && (nextFlightTick = flightTicks + 1) % 10 == 0) {
            if (nextFlightTick % 20 == 0) {
                stack.m_41622_(1, entity, e -> e.m_21166_(EquipmentSlot.CHEST));
            }
            entity.m_146850_(GameEvent.f_223705_);
        }
        return true;
    }

    @PlatformOnly(value={"forge"})
    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return this.isFallFlying;
    }
}

