/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.entity.vehicle;

import earth.terrarium.ad_astra.common.block.door.LocationState;
import earth.terrarium.ad_astra.common.block.launchpad.LaunchPad;
import earth.terrarium.ad_astra.common.config.VehiclesConfig;
import earth.terrarium.ad_astra.common.entity.vehicle.Vehicle;
import earth.terrarium.ad_astra.common.item.armor.NetheriteSpaceSuit;
import earth.terrarium.ad_astra.common.registry.ModCriteria;
import earth.terrarium.ad_astra.common.registry.ModDamageSource;
import earth.terrarium.ad_astra.common.registry.ModParticleTypes;
import earth.terrarium.ad_astra.common.registry.ModSoundEvents;
import earth.terrarium.ad_astra.common.registry.ModTags;
import earth.terrarium.ad_astra.common.screen.PlanetSelectionMenuProvider;
import earth.terrarium.ad_astra.common.screen.menu.PlanetSelectionMenu;
import earth.terrarium.ad_astra.common.util.ModKeyBindings;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import earth.terrarium.botarium.api.menu.ExtraDataMenuProvider;
import earth.terrarium.botarium.api.menu.MenuHooks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Rocket
extends Vehicle {
    protected static final EntityDataAccessor<Boolean> HAS_LAUNCH_PAD = SynchedEntityData.m_135353_(Rocket.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(Rocket.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> COUNTDOWN_TICKS = SynchedEntityData.m_135353_(Rocket.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> TIER = SynchedEntityData.m_135353_(Rocket.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(Rocket.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Player lastRider;

    public Rocket(EntityType<?> type, Level level, int tier) {
        super(type, level);
        this.setTier(tier);
    }

    public static void stopRocketSoundForRider(ServerPlayer rider) {
        ClientboundStopSoundPacket stopSoundS2CPacket = new ClientboundStopSoundPacket(new ResourceLocation("ad_astra", "rocket_fly"), SoundSource.AMBIENT);
        rider.f_8906_.m_9829_((Packet)stopSoundS2CPacket);
    }

    public static long getRequiredAmountForLaunch(Fluid fluid) {
        if (fluid.m_205067_(ModTags.EFFICIENT_FUELS)) {
            return VehiclesConfig.RocketConfig.efficientFuelLaunchCost;
        }
        return VehiclesConfig.RocketConfig.fuelLaunchCost;
    }

    @Override
    public int getInventorySize() {
        return 10;
    }

    @Override
    public long getTankSize() {
        return VehiclesConfig.RocketConfig.tankSize;
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        super.m_6096_(player, hand);
        this.openInventory(player);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_LAUNCH_PAD, (Object)false);
        this.f_19804_.m_135372_(FLYING, (Object)false);
        this.f_19804_.m_135372_(COUNTDOWN_TICKS, (Object)0);
        this.f_19804_.m_135372_(TIER, (Object)0);
        this.f_19804_.m_135372_(PHASE, (Object)0);
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        super.m_7688_(passenger);
        int exitDirection = Math.round(passenger.m_146908_() / 90.0f) * 90;
        Vec3 pos = passenger.m_20182_();
        Vec3 exitPos = switch (exitDirection) {
            case 0, 360 -> new Vec3(pos.m_7096_(), pos.m_7098_(), pos.m_7094_() + 1.5);
            case -270, 90 -> new Vec3(pos.m_7096_() - 1.5, pos.m_7098_(), pos.m_7094_());
            case -90, 270 -> new Vec3(pos.m_7096_() + 1.5, pos.m_7098_(), pos.m_7094_());
            case -180, 180 -> new Vec3(pos.m_7096_(), pos.m_7098_(), pos.m_7094_() - 1.5);
            default -> super.m_7688_(passenger);
        };
        BlockPos exitBlockPos = new BlockPos(exitPos);
        for (int checks = 3; !this.f_19853_.m_8055_(exitBlockPos).m_60796_((BlockGetter)this.f_19853_, exitBlockPos) && checks > 0; --checks) {
            exitBlockPos = exitBlockPos.m_7495_();
        }
        BlockState exitBlockState = this.f_19853_.m_8055_(exitBlockPos.m_7494_());
        VoxelShape collisionShape = exitBlockState.m_60812_((BlockGetter)this.f_19853_, exitBlockPos);
        double yOffset = 0.0;
        if (!collisionShape.m_83281_()) {
            yOffset = exitBlockState.m_60812_((BlockGetter)this.f_19853_, exitBlockPos).m_83215_().m_82376_();
        }
        return new Vec3((double)exitBlockPos.m_123341_(), (double)exitBlockPos.m_7494_().m_123342_() + yOffset, (double)exitBlockPos.m_123343_());
    }

    public void assignLaunchPad(boolean value) {
        this.setLaunchPad(value);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            Player player;
            this.lastRider = player = (Player)entity;
            if (ModKeyBindings.leftKeyDown(player)) {
                this.rotateRocketAndPassengers(-1.0f);
            }
            if (ModKeyBindings.rightKeyDown(player)) {
                this.rotateRocketAndPassengers(1.0f);
            }
        }
        if (this.m_20186_() >= (double)VehiclesConfig.RocketConfig.atmosphereLeave || this.m_146888_() > 1000) {
            this.setFlying(true);
        }
        if (!this.isFlying()) {
            if (this.hasLaunchPad()) {
                BlockState below = this.f_19853_.m_8055_(this.m_20183_());
                if (!(below.m_60734_() instanceof LaunchPad)) {
                    this.drop();
                } else if (below.m_60734_() instanceof LaunchPad && below.m_61143_(LaunchPad.LOCATION) != LocationState.CENTER) {
                    this.drop();
                }
            }
        } else {
            this.setCountdownTicks(this.getCountdownTicks() - 1);
            if (this.getCountdownTicks() > 0) {
                this.spawnSmokeParticles();
                this.setPhase(1);
            } else if (this.m_20186_() < (double)VehiclesConfig.RocketConfig.atmosphereLeave) {
                this.spawnAfterburnerParticles();
                this.burnEntitiesUnderRocket();
                this.travel();
                if (this.getCountdownTicks() < -30) {
                    this.explodeIfStopped();
                }
                this.setPhase(2);
            } else if (this.m_20186_() >= (double)VehiclesConfig.RocketConfig.atmosphereLeave) {
                this.openPlanetSelectionGui();
                this.setPhase(3);
            }
        }
        if (this.m_204029_(FluidTags.f_13132_)) {
            this.explode(0.45f);
        }
    }

    @Override
    public void drop() {
        if (!this.isFlying()) {
            super.drop();
        }
    }

    public void openPlanetSelectionGui() {
        if (!this.m_20160_()) {
            if (!this.f_19853_.f_46443_ && this.lastRider != null) {
                ModCriteria.ROCKET_DESTROYED.trigger((ServerPlayer)this.lastRider);
            }
            this.explode();
            return;
        }
        this.m_20197_().forEach(passenger -> {
            if (passenger instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)passenger;
                if (!(player.f_36096_ instanceof PlanetSelectionMenu)) {
                    player.m_6915_();
                    if (!this.f_19853_.f_46443_) {
                        MenuHooks.openMenu((ServerPlayer)player, (ExtraDataMenuProvider)new PlanetSelectionMenuProvider(this.getTier()));
                        Rocket.stopRocketSoundForRider(player);
                    }
                }
            }
        });
    }

    public void spawnSmokeParticles() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            Vec3 pos = this.m_20182_();
            ModUtils.spawnForcedParticles(serverWorld, ParticleTypes.f_123777_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 6, 0.1, 0.1, 0.1, 0.023);
        }
    }

    public void spawnAfterburnerParticles() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            Vec3 pos = this.m_20182_();
            ModUtils.spawnForcedParticles(serverWorld, (SimpleParticleType)ModParticleTypes.LARGE_FLAME.get(), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 20, 0.1, 0.1, 0.1, 0.001);
            ModUtils.spawnForcedParticles(serverWorld, (SimpleParticleType)ModParticleTypes.LARGE_SMOKE.get(), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 10, 0.1, 0.1, 0.1, 0.001);
        }
    }

    private void burnEntitiesUnderRocket() {
        List entities = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82377_(2.0, 30.0, 2.0).m_82386_(0.0, -37.0, 0.0), entity -> true);
        for (LivingEntity entity2 : entities) {
            if (NetheriteSpaceSuit.hasFullSet(entity2) || entity2.m_20202_() != null && entity2.m_20202_().equals((Object)this) || !VehiclesConfig.RocketConfig.entitiesBurnUnderRocket || entity2.m_5825_()) continue;
            entity2.m_20254_(10);
            entity2.m_6469_(ModDamageSource.ROCKET_FLAMES, 10.0f);
            BlockState belowBlock = this.f_19853_.m_8055_(entity2.m_20183_().m_7495_());
            if (!belowBlock.m_60838_((BlockGetter)this.f_19853_, entity2.m_20183_().m_7495_()) || !belowBlock.m_60795_()) continue;
            this.f_19853_.m_46597_(entity2.m_20183_(), Blocks.f_50083_.m_49966_());
        }
    }

    private void travel() {
        double multiplier;
        double d = multiplier = this.getTankHolder().getFluid().m_205067_(ModTags.EFFICIENT_FUELS) ? 2.5 : 1.0;
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, VehiclesConfig.RocketConfig.acceleration * multiplier, 0.0));
        }
        if (this.m_20184_().m_7098_() > VehiclesConfig.RocketConfig.maxSpeed * multiplier) {
            this.m_20334_(0.0, VehiclesConfig.RocketConfig.maxSpeed, 0.0);
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public void initiateLaunchSequenceFromServer() {
        this.initiateLaunchSequence();
        this.f_19853_.m_5594_(null, this.m_20183_(), (SoundEvent)ModSoundEvents.ROCKET_LAUNCH_SOUND_EVENT.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
    }

    public void initiateLaunchSequence() {
        this.setFlying(true);
        this.setCountdownTicks(VehiclesConfig.RocketConfig.countDownTicks);
        this.m_146917_(Integer.MAX_VALUE);
        this.getTank().extractFluid(FluidHooks.newFluidHolder((Fluid)this.getTankHolder().getFluid(), (long)Rocket.getRequiredAmountForLaunch(this.getTankHolder().getFluid()), (CompoundTag)this.getTankHolder().getCompound()), false);
    }

    public boolean hasLaunchPad() {
        return (Boolean)this.f_19804_.m_135370_(HAS_LAUNCH_PAD);
    }

    public void setLaunchPad(boolean value) {
        this.f_19804_.m_135381_(HAS_LAUNCH_PAD, (Object)value);
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean value) {
        this.f_19804_.m_135381_(FLYING, (Object)value);
    }

    public int getCountdownTicks() {
        return (Integer)this.f_19804_.m_135370_(COUNTDOWN_TICKS);
    }

    public void setCountdownTicks(int value) {
        this.f_19804_.m_135381_(COUNTDOWN_TICKS, (Object)value);
    }

    public int getPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE);
    }

    public void setPhase(int value) {
        this.f_19804_.m_135381_(PHASE, (Object)value);
    }

    public int getTier() {
        return (Integer)this.f_19804_.m_135370_(TIER);
    }

    public void setTier(int value) {
        this.f_19804_.m_135381_(TIER, (Object)value);
    }

    public int getCountdownSeconds() {
        return (this.getCountdownTicks() + 20) / 20;
    }

    @Override
    public boolean doHighFov() {
        return true;
    }

    @Override
    public boolean fullyConcealsRider() {
        return true;
    }

    @Override
    public boolean canRiderTakeFallDamage() {
        return false;
    }

    @Override
    public boolean renderPlanetBar() {
        return true;
    }

    @Override
    public void doGravity() {
        BlockState belowBlock = this.f_19853_.m_8055_(this.m_20183_());
        if (belowBlock.m_60734_() instanceof LaunchPad && ((LocationState)((Object)belowBlock.m_61143_(LaunchPad.LOCATION))).equals((Object)LocationState.CENTER)) {
            return;
        }
        if (this.getPhase() == 0 || this.getPhase() == 1) {
            super.doGravity();
        }
    }

    private void explodeIfStopped() {
        if (this.m_20184_().m_7098_() < 0.05 && this.m_20184_().m_7098_() > -1.0E-6) {
            this.explode();
        }
    }

    public void explode() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            float tierMultiplier = 1.0f + (float)this.getTier() * 0.25f;
            if (this.m_20184_().m_7098_() > 4.0) {
                tierMultiplier *= 1.25f;
            }
            if (this.m_20186_() <= (double)VehiclesConfig.RocketConfig.atmosphereLeave) {
                serverWorld.m_6907_().forEach(Rocket::stopRocketSoundForRider);
            }
            this.explode(tierMultiplier);
        }
    }

    public void rotateRocketAndPassengers(float rotation) {
        ModUtils.rotateVehicleYaw(this, this.m_146908_() + rotation);
        for (Entity passenger : this.m_20197_()) {
            passenger.m_146922_(passenger.m_146908_() + rotation);
        }
    }
}

