/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.entity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import earth.terrarium.ad_astra.common.item.OxygenTankItem;
import earth.terrarium.ad_astra.common.registry.ModItems;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class LunarianMerchantOffer {
    public static final Map<VillagerProfession, Int2ObjectMap<VillagerTrades.ItemListing[]>> PROFESSION_TO_LEVELED_TRADE = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(VillagerProfession.f_35590_, LunarianMerchantOffer.copyToFastUtilMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)ModItems.CHEESE.get(), 20, 20, 5), new BuyForOneEmeraldFactory((ItemLike)Items.f_151079_, 22, 16, 3), new SellItemFactory(Items.f_42406_, 1, 6, 16, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new SellItemFactory(Items.f_42687_, 1, 4, 5), new SellItemFactory(Items.f_42436_, 8, 1, 8, 20)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new SellItemFactory(Items.f_42572_, 3, 18, 10), new BuyForOneEmeraldFactory((ItemLike)Blocks.f_50186_, 4, 12, 20)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new SellItemFactory(Blocks.f_50145_, 1, 1, 12, 15), new BuyForOneEmeraldFactory((ItemLike)Items.f_42329_, 63, 16, 2), new SellSuspiciousStewFactory(MobEffects.f_19611_, 100, 15), new SellSuspiciousStewFactory(MobEffects.f_19603_, 160, 15), new SellSuspiciousStewFactory(MobEffects.f_19613_, 140, 15), new SellSuspiciousStewFactory(MobEffects.f_19610_, 120, 15), new SellSuspiciousStewFactory(MobEffects.f_19614_, 280, 15), new SellSuspiciousStewFactory(MobEffects.f_19618_, 7, 15)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new SellItemFactory(Items.f_42677_, 3, 3, 30), new SellItemFactory(Items.f_42546_, 4, 3, 30)})));
        map.put(VillagerProfession.f_35591_, LunarianMerchantOffer.copyToFastUtilMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)ModItems.CHEESE.get(), 20, 20, 5), new BuyForOneEmeraldFactory((ItemLike)Items.f_42401_, 20, 16, 2), new BuyForOneEmeraldFactory((ItemLike)Items.f_42413_, 10, 16, 2), new ProcessItemFactory((ItemLike)Items.f_42526_, 6, Items.f_42530_, 6, 16, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42526_, 15, 16, 10), new ProcessItemFactory((ItemLike)Items.f_42527_, 6, Items.f_42531_, 6, 16, 5), new SellItemFactory(Items.f_42782_, 2, 1, 5)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42527_, 13, 16, 20), new SellEnchantedToolFactory(Items.f_42523_, 3, 3, 10, 0.2f)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42528_, 6, 12, 30)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42529_, 4, 12, 30), new SellItemFactory(new ItemStack((ItemLike)Items.f_42447_), 8, 1, 2, 9, 0.2f), new SellItemFactory(new ItemStack((ItemLike)Items.f_41980_), 4, 1, 8, 9, 0.2f)})));
        map.put(VillagerProfession.f_35597_, LunarianMerchantOffer.copyToFastUtilMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Blocks.f_50041_, 18, 16, 2), new BuyForOneEmeraldFactory((ItemLike)Blocks.f_50106_, 18, 16, 2), new BuyForOneEmeraldFactory((ItemLike)Blocks.f_50109_, 18, 16, 2), new BuyForOneEmeraldFactory((ItemLike)Blocks.f_50101_, 18, 16, 2), new SellItemFactory(Items.f_42574_, 2, 1, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42535_, 12, 16, 10), new BuyForOneEmeraldFactory((ItemLike)Items.f_42490_, 12, 16, 10), new BuyForOneEmeraldFactory((ItemLike)Items.f_42498_, 12, 16, 10), new BuyForOneEmeraldFactory((ItemLike)Items.f_42538_, 12, 16, 10), new BuyForOneEmeraldFactory((ItemLike)Items.f_42540_, 12, 16, 10), new SellItemFactory(Blocks.f_50041_, 1, 1, 16, 5), new SellItemFactory(Blocks.f_50042_, 1, 1, 16, 5), new SellItemFactory(Blocks.f_50096_, 1, 1, 16, 5), new SellItemFactory(Blocks.f_50097_, 1, 1, 16, 5), new SellItemFactory(Blocks.f_50098_, 1, 1, 16, 5), new SellItemFactory(Blocks.f_50099_, 1, 1, 16, 5), new SellItemFactory(Blocks.f_50100_, 1, 1, 16, 5), new SellItemFactory(Blocks.f_50101_, 1, 1, 16, 5), new SellItemFactory(Blocks.f_50102_, 1, 1, 16, 5), new SellItemFactory(Blocks.f_50103_, 1, 1, 16, 5), new SellItemFactory(Blocks.f_50104_, 1, 1, 16, 5), new SellItemFactory(Blocks.f_50105_, 1, 1, 16, 5), new SellItemFactory(Blocks.f_50106_, 1, 1, 16, 5), new SellItemFactory(Blocks.f_50107_, 1, 1, 16, 5), new SellItemFactory(Blocks.f_50108_, 1, 1, 16, 5), new SellItemFactory(Blocks.f_50109_, 1, 1, 16, 5), new SellItemFactory(Blocks.f_50336_, 1, 4, 16, 5), new SellItemFactory(Blocks.f_50337_, 1, 4, 16, 5), new SellItemFactory(Blocks.f_50338_, 1, 4, 16, 5), new SellItemFactory(Blocks.f_50339_, 1, 4, 16, 5), new SellItemFactory(Blocks.f_50340_, 1, 4, 16, 5), new SellItemFactory(Blocks.f_50341_, 1, 4, 16, 5), new SellItemFactory(Blocks.f_50342_, 1, 4, 16, 5), new SellItemFactory(Blocks.f_50343_, 1, 4, 16, 5), new SellItemFactory(Blocks.f_50344_, 1, 4, 16, 5), new SellItemFactory(Blocks.f_50345_, 1, 4, 16, 5), new SellItemFactory(Blocks.f_50346_, 1, 4, 16, 5), new SellItemFactory(Blocks.f_50347_, 1, 4, 16, 5), new SellItemFactory(Blocks.f_50348_, 1, 4, 16, 5), new SellItemFactory(Blocks.f_50349_, 1, 4, 16, 5), new SellItemFactory(Blocks.f_50350_, 1, 4, 16, 5), new SellItemFactory(Blocks.f_50351_, 1, 4, 16, 5)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42539_, 12, 16, 20), new BuyForOneEmeraldFactory((ItemLike)Items.f_42491_, 12, 16, 20), new BuyForOneEmeraldFactory((ItemLike)Items.f_42536_, 12, 16, 20), new BuyForOneEmeraldFactory((ItemLike)Items.f_42497_, 12, 16, 20), new BuyForOneEmeraldFactory((ItemLike)Items.f_42489_, 12, 16, 20), new SellItemFactory(Blocks.f_50066_, 3, 1, 12, 10), new SellItemFactory(Blocks.f_50018_, 3, 1, 12, 10), new SellItemFactory(Blocks.f_50028_, 3, 1, 12, 10), new SellItemFactory(Blocks.f_50029_, 3, 1, 12, 10), new SellItemFactory(Blocks.f_50025_, 3, 1, 12, 10), new SellItemFactory(Blocks.f_50026_, 3, 1, 12, 10), new SellItemFactory(Blocks.f_50023_, 3, 1, 12, 10), new SellItemFactory(Blocks.f_50021_, 3, 1, 12, 10), new SellItemFactory(Blocks.f_50027_, 3, 1, 12, 10), new SellItemFactory(Blocks.f_50017_, 3, 1, 12, 10), new SellItemFactory(Blocks.f_50022_, 3, 1, 12, 10), new SellItemFactory(Blocks.f_50019_, 3, 1, 12, 10), new SellItemFactory(Blocks.f_50068_, 3, 1, 12, 10), new SellItemFactory(Blocks.f_50067_, 3, 1, 12, 10), new SellItemFactory(Blocks.f_50020_, 3, 1, 12, 10), new SellItemFactory(Blocks.f_50024_, 3, 1, 12, 10)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42495_, 12, 16, 30), new BuyForOneEmeraldFactory((ItemLike)Items.f_42493_, 12, 16, 30), new BuyForOneEmeraldFactory((ItemLike)Items.f_42494_, 12, 16, 30), new BuyForOneEmeraldFactory((ItemLike)Items.f_42496_, 12, 16, 30), new BuyForOneEmeraldFactory((ItemLike)Items.f_42537_, 12, 16, 30), new BuyForOneEmeraldFactory((ItemLike)Items.f_42492_, 12, 16, 30), new SellItemFactory((Item)ModItems.WHITE_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.BLUE_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.LIGHT_BLUE_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.RED_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.PINK_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.GREEN_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.LIME_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.GRAY_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.PURPLE_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.MAGENTA_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.CYAN_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.BROWN_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.YELLOW_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.ORANGE_FLAG.get(), 3, 1, 12, 25)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new SellItemFactory((Item)ModItems.SPACE_PAINTING.get(), 64, 1, 2, 50)})));
        map.put(VillagerProfession.f_35592_, LunarianMerchantOffer.copyToFastUtilMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)ModItems.IRON_ROD.get(), 8, 16, 6), new SellItemFactory(Items.f_42412_, 1, 16, 1), new ProcessItemFactory((ItemLike)Blocks.f_49994_, 10, Items.f_42484_, 10, 12, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42484_, 26, 12, 10), new SellItemFactory(Items.f_42411_, 2, 1, 5)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42401_, 14, 16, 20), new SellItemFactory(Items.f_42717_, 3, 1, 10)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42402_, 24, 16, 30), new SellEnchantedToolFactory(Items.f_42411_, 2, 3, 15)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42109_, 8, 12, 30), new SellEnchantedToolFactory(Items.f_42717_, 3, 3, 15), new SellPotionHoldingItemFactory(Items.f_42412_, 5, Items.f_42738_, 5, 2, 12, 30)})));
        map.put(VillagerProfession.f_35594_, LunarianMerchantOffer.copyToFastUtilMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42516_, 24, 16, 2), new EnchantBookFactory(1), new SellItemFactory(Blocks.f_50078_, 9, 1, 12, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42517_, 4, 12, 10), new EnchantBookFactory(5), new SellItemFactory(Items.f_42778_, 1, 1, 5)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42532_, 5, 12, 20), new EnchantBookFactory(10), new SellItemFactory(Items.f_42215_, 1, 8, 10)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42614_, 2, 12, 30), new EnchantBookFactory(15), new SellItemFactory(Items.f_42524_, 5, 1, 15), new SellItemFactory(Items.f_42522_, 4, 1, 15)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new SellItemFactory(Items.f_42656_, 20, 1, 30)})));
        map.put(VillagerProfession.f_35588_, LunarianMerchantOffer.copyToFastUtilMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42516_, 24, 16, 2), new SellItemFactory(Items.f_42676_, 7, 1, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42027_, 11, 16, 10)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42522_, 1, 12, 20)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new SellItemFactory(Items.f_42617_, 7, 1, 15), new SellItemFactory((Item)ModItems.WHITE_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.BLUE_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.LIGHT_BLUE_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.RED_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.PINK_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.GREEN_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.LIME_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.GRAY_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.PURPLE_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.MAGENTA_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.CYAN_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.BROWN_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.YELLOW_FLAG.get(), 3, 1, 12, 25), new SellItemFactory((Item)ModItems.ORANGE_FLAG.get(), 3, 1, 12, 25)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new SellItemFactory(Items.f_186364_, 6, 1, 45)})));
        map.put(VillagerProfession.f_35589_, LunarianMerchantOffer.copyToFastUtilMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42583_, 32, 16, 2), new SellItemFactory(Items.f_42451_, 1, 2, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)ModItems.DESH_INGOT.get(), 3, 8, 10), new SellItemFactory(Items.f_42534_, 1, 1, 5)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42648_, 2, 12, 20), new SellItemFactory(Blocks.f_50141_, 4, 1, 12, 10)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42355_, 4, 12, 30), new BuyForOneEmeraldFactory((ItemLike)Items.f_42590_, 9, 12, 30), new SellItemFactory(Items.f_42584_, 5, 1, 15)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42588_, 22, 12, 30), new SellItemFactory(Items.f_42612_, 2, 1, 30), new SellItemFactory((Item)ModItems.OXYGEN_BUCKET.get(), 32, 1, 1, 60)})));
        map.put(VillagerProfession.f_35586_, LunarianMerchantOffer.copyToFastUtilMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)ModItems.ICE_SHARD.get(), 12, 16, 2), new SellItemFactory(new ItemStack((ItemLike)ModItems.SPACE_PANTS.get()), 14, 1, 12, 4, 0.2f), new SellItemFactory(new ItemStack((ItemLike)ModItems.SPACE_BOOTS.get()), 8, 1, 12, 4, 0.2f), new SellItemFactory(new ItemStack((ItemLike)ModItems.SPACE_HELMET.get()), 10, 1, 12, 4, 0.2f), new SellItemFactory(new ItemStack((ItemLike)ModItems.SPACE_SUIT.get()), 36, 1, 12, 8, 0.2f)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)ModItems.DESH_INGOT.get(), 4, 8, 10), new SellItemFactory(new ItemStack((ItemLike)Items.f_42777_), 36, 1, 12, 5, 0.2f), new SellItemFactory(new ItemStack((ItemLike)ModItems.SPACE_BOOTS.get()), 8, 1, 12, 4, 0.2f), new SellItemFactory(new ItemStack((ItemLike)ModItems.SPACE_PANTS.get()), 14, 1, 12, 4, 0.2f)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42448_, 1, 12, 20), new BuyForOneEmeraldFactory((ItemLike)Items.f_42415_, 1, 12, 20), new SellItemFactory(new ItemStack((ItemLike)ModItems.SPACE_HELMET.get()), 10, 1, 12, 4, 0.2f), new SellItemFactory(new ItemStack((ItemLike)ModItems.SPACE_SUIT.get()), 36, 1, 12, 8, 0.2f), new SellItemFactory(new ItemStack((ItemLike)Items.f_42740_), 5, 1, 12, 10, 0.2f)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new SellEnchantedToolFactory((Item)ModItems.SPACE_PANTS.get(), 28, 3, 15, 0.2f), new SellEnchantedToolFactory((Item)ModItems.SPACE_BOOTS.get(), 16, 3, 15, 0.2f)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new SellEnchantedToolFactory((Item)ModItems.SPACE_HELMET.get(), 16, 3, 30, 0.2f), new SellEnchantedToolFactory((Item)ModItems.SPACE_SUIT.get(), 48, 3, 30, 0.2f), new SellItemFactory(OxygenTankItem.createOxygenatedTank(), 24, 1, 2, 40), new SellItemFactory((Item)ModItems.OXYGEN_BUCKET.get(), 32, 1, 1, 60), new SellItemFactory((Item)ModItems.OXYGEN_LOADER.get(), 48, 1, 1, 60), new SellItemFactory((Item)ModItems.COAL_GENERATOR.get(), 32, 1, 1, 60)})));
        map.put(VillagerProfession.f_35599_, LunarianMerchantOffer.copyToFastUtilMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)ModItems.ICE_SHARD.get(), 12, 16, 2), new SellItemFactory(new ItemStack((ItemLike)ModItems.HAMMER.get()), 3, 1, 8, 2, 0.2f), new SellItemFactory(new ItemStack((ItemLike)Items.f_42386_), 3, 1, 12, 1, 0.2f), new SellEnchantedToolFactory(Items.f_42383_, 2, 3, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)ModItems.DESH_INGOT.get(), 4, 12, 10), new SellItemFactory(new ItemStack((ItemLike)Items.f_42777_), 36, 1, 12, 5, 0.2f)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42484_, 24, 12, 20)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42415_, 1, 12, 30), new SellEnchantedToolFactory(Items.f_42391_, 12, 3, 15, 0.2f)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new SellEnchantedToolFactory(Items.f_42388_, 8, 3, 30, 0.2f), new SellItemFactory(OxygenTankItem.createOxygenatedTank(), 24, 1, 2, 40), new SellItemFactory((Item)ModItems.OXYGEN_BUCKET.get(), 32, 1, 1, 60), new SellItemFactory((Item)ModItems.OXYGEN_LOADER.get(), 48, 3, 1, 60)})));
        map.put(VillagerProfession.f_35598_, LunarianMerchantOffer.copyToFastUtilMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)ModItems.ICE_SHARD.get(), 12, 16, 2), new SellItemFactory(new ItemStack((ItemLike)Items.f_42053_), 3, 16, 8, 1, 0.2f), new SellItemFactory(new ItemStack((ItemLike)ModItems.HAMMER.get()), 3, 1, 8, 2, 0.2f), new SellItemFactory((Item)ModItems.WRENCH.get(), 14, 1, 2, 2), new SellItemFactory(new ItemStack((ItemLike)Items.f_42428_), 1, 1, 12, 1, 0.2f), new SellItemFactory(new ItemStack((ItemLike)Items.f_42426_), 1, 1, 12, 1, 0.2f), new SellItemFactory(new ItemStack((ItemLike)Items.f_42427_), 1, 1, 12, 1, 0.2f), new SellItemFactory(new ItemStack((ItemLike)Items.f_42429_), 1, 1, 12, 1, 0.2f)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)ModItems.DESH_INGOT.get(), 4, 12, 10), new SellItemFactory(new ItemStack((ItemLike)Items.f_42777_), 36, 1, 12, 5, 0.2f)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42484_, 30, 12, 20), new SellEnchantedToolFactory(Items.f_42386_, 1, 3, 10, 0.2f), new SellEnchantedToolFactory(Items.f_42384_, 2, 3, 10, 0.2f), new SellEnchantedToolFactory(Items.f_42385_, 3, 3, 10, 0.2f), new SellItemFactory(new ItemStack((ItemLike)Items.f_42392_), 4, 1, 3, 10, 0.2f)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42415_, 1, 12, 30), new SellEnchantedToolFactory(Items.f_42391_, 12, 3, 15, 0.2f), new SellEnchantedToolFactory(Items.f_42389_, 5, 3, 15, 0.2f)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new SellEnchantedToolFactory(Items.f_42390_, 13, 3, 30, 0.2f), new SellItemFactory(OxygenTankItem.createOxygenatedTank(), 24, 1, 2, 40), new SellItemFactory((Item)ModItems.OXYGEN_BUCKET.get(), 32, 1, 1, 60), new SellItemFactory((Item)ModItems.OXYGEN_LOADER.get(), 48, 1, 1, 60), new SellItemFactory((Item)ModItems.COAL_GENERATOR.get(), 32, 1, 1, 60)})));
        map.put(VillagerProfession.f_35587_, LunarianMerchantOffer.copyToFastUtilMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)ModItems.CHEESE.get(), 20, 20, 5), new BuyForOneEmeraldFactory((ItemLike)Items.f_42581_, 14, 16, 2), new BuyForOneEmeraldFactory((ItemLike)Items.f_42485_, 7, 16, 2), new BuyForOneEmeraldFactory((ItemLike)Items.f_42697_, 4, 16, 2), new SellItemFactory(Items.f_42699_, 1, 1, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42413_, 15, 16, 2), new SellItemFactory(Items.f_42486_, 1, 5, 16, 5), new SellItemFactory(Items.f_42582_, 1, 8, 16, 5)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42658_, 7, 16, 20), new BuyForOneEmeraldFactory((ItemLike)Items.f_42579_, 10, 16, 20)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42515_, 10, 12, 30)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42780_, 10, 12, 30)})));
        map.put(VillagerProfession.f_35593_, LunarianMerchantOffer.copyToFastUtilMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42454_, 6, 16, 2), new SellDyedArmorFactory(Items.f_42462_, 3), new SellDyedArmorFactory(Items.f_42408_, 7)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42484_, 26, 12, 10), new SellDyedArmorFactory(Items.f_42407_, 5, 12, 5), new SellDyedArmorFactory(Items.f_42463_, 4, 12, 5)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42649_, 9, 12, 20), new SellDyedArmorFactory(Items.f_42408_, 7)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42355_, 4, 12, 30), new SellDyedArmorFactory(Items.f_42654_, 6, 12, 15)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new SellItemFactory(new ItemStack((ItemLike)Items.f_42450_), 6, 1, 12, 30, 0.2f), new SellDyedArmorFactory(Items.f_42407_, 5, 12, 30)})));
        map.put(VillagerProfession.f_35595_, LunarianMerchantOffer.copyToFastUtilMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)ModItems.CONGLOMERATE.get(), 10, 16, 2), new BuyForOneEmeraldFactory((ItemLike)ModItems.MOON_SAND.get(), 32, 32, 1), new SellItemFactory((Item)ModItems.MOON_STONE_BRICKS.get(), 1, 10, 16, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)ModItems.MOON_STONE.get(), 20, 16, 10), new SellItemFactory((Item)ModItems.CHISELED_MOON_STONE_BRICKS.get(), 1, 4, 16, 5)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)ModItems.MARS_STONE.get(), 16, 16, 20), new BuyForOneEmeraldFactory((ItemLike)ModItems.VENUS_STONE.get(), 16, 16, 20), new BuyForOneEmeraldFactory((ItemLike)ModItems.MERCURY_STONE.get(), 16, 16, 20), new SellItemFactory(Blocks.f_152537_, 1, 4, 16, 10), new SellItemFactory((Item)ModItems.POLISHED_MARS_STONE.get(), 1, 4, 16, 10), new SellItemFactory((Item)ModItems.POLISHED_VENUS_STONE.get(), 1, 4, 16, 10), new SellItemFactory((Item)ModItems.POLISHED_MERCURY_STONE.get(), 1, 4, 16, 10)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new BuyForOneEmeraldFactory((ItemLike)Items.f_42692_, 12, 12, 30), new SellItemFactory(Blocks.f_50288_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50287_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50298_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50290_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50294_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50295_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50302_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50301_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50293_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50289_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50292_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50300_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50296_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50297_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50291_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50299_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50527_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50526_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50537_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50529_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50533_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50534_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50541_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50540_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50532_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50528_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50531_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50539_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50535_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50536_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50530_, 1, 1, 12, 15), new SellItemFactory(Blocks.f_50538_, 1, 1, 12, 15)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new SellItemFactory((Item)ModItems.STEEL_PLATING.get(), 1, 8, 12, 15), new SellItemFactory((Item)ModItems.DESH_PLATING.get(), 1, 8, 12, 15), new SellItemFactory((Item)ModItems.OSTRUM_PLATING.get(), 1, 4, 12, 15), new SellItemFactory((Item)ModItems.STEEL_DOOR.get(), 1, 3, 12, 15), new SellItemFactory(Blocks.f_50283_, 1, 1, 12, 30), new SellItemFactory(Blocks.f_50333_, 1, 1, 12, 30)})));
    });
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> WANDERING_TRADER_TRADES = LunarianMerchantOffer.copyToFastUtilMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new SellItemFactory((Item)ModItems.CHEESE.get(), 1, 3, 6, 1), new SellItemFactory((Item)ModItems.SPACE_PAINTING.get(), 48, 1, 2, 2), new SellItemFactory((Item)ModItems.OXYGEN_TANK.get(), 10, 1, 3, 1), new SellItemFactory(Items.f_42053_, 1, 12, 12, 1), new SellItemFactory(Items.f_42782_, 3, 1, 4, 1), new SellItemFactory((Item)ModItems.WRENCH.get(), 12, 1, 2, 2), new SellItemFactory((Item)ModItems.HAMMER.get(), 3, 1, 4, 1), new SellItemFactory((Item)ModItems.WHITE_FLAG.get(), 10, 1, 3, 2), new SellItemFactory((Item)ModItems.SPACE_HELMET.get(), 10, 1, 2, 1), new SellItemFactory((Item)ModItems.SPACE_SUIT.get(), 16, 1, 2, 1), new SellItemFactory((Item)ModItems.SPACE_PANTS.get(), 14, 1, 2, 1), new SellItemFactory((Item)ModItems.SPACE_BOOTS.get(), 8, 1, 2, 1), new SellItemFactory(Items.f_42413_, 1, 5, 4, 1), new SellItemFactory((Item)ModItems.OXYGEN_BUCKET.get(), 10, 1, 2, 2), new SellItemFactory(Items.f_151052_, 1, 4, 12, 1), new SellItemFactory(Items.f_42447_, 5, 1, 4, 1), new SellItemFactory(Items.f_42448_, 3, 1, 4, 1), new BuyForOneEmeraldFactory((ItemLike)ModItems.DESH_INGOT.get(), 4, 20, 1), new BuyForOneEmeraldFactory((ItemLike)ModItems.OSTRUM_INGOT.get(), 4, 20, 1), new BuyForOneEmeraldFactory((ItemLike)ModItems.CALORITE_INGOT.get(), 4, 20, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new SellItemFactory(OxygenTankItem.createOxygenatedTank(), 16, 1, 3, 2), new SellItemFactory((Item)ModItems.LAUNCH_PAD.get(), 3, 1, 3, 1), new SellItemFactory((Item)ModItems.LAUNCH_PAD.get(), 3, 1, 3, 1), new SellItemFactory((Item)ModItems.GLACIAN_LOG.get(), 5, 16, 20, 1), new SellItemFactory((Item)ModItems.GLACIAN_LEAVES.get(), 5, 16, 20, 1), new SellItemFactory((Item)ModItems.AERONOS_STEM.get(), 5, 16, 20, 1), new SellItemFactory((Item)ModItems.STROPHAR_STEM.get(), 5, 16, 20, 1), new SellItemFactory((Item)ModItems.FUEL_BUCKET.get(), 4, 1, 6, 1)}));

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> copyToFastUtilMap(ImmutableMap<Integer, VillagerTrades.ItemListing[]> map) {
        return new Int2ObjectOpenHashMap(map);
    }

    static class BuyForOneEmeraldFactory
    implements VillagerTrades.ItemListing {
        private final Item buy;
        private final int price;
        private final int maxUses;
        private final int experience;
        private final float multiplier;

        public BuyForOneEmeraldFactory(ItemLike item, int price, int maxUses, int experience) {
            this.buy = item.m_5456_();
            this.price = price;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = 0.05f;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            ItemStack itemStack = new ItemStack((ItemLike)this.buy, this.price);
            return new MerchantOffer(itemStack, new ItemStack((ItemLike)Items.f_42616_), this.maxUses, this.experience, this.multiplier);
        }
    }

    static class SellItemFactory
    implements VillagerTrades.ItemListing {
        private final ItemStack sell;
        private final int price;
        private final int count;
        private final int maxUses;
        private final int experience;
        private final float multiplier;

        public SellItemFactory(Block block, int price, int count, int maxUses, int experience) {
            this(new ItemStack((ItemLike)block), price, count, maxUses, experience);
        }

        public SellItemFactory(Item item, int price, int count, int experience) {
            this(new ItemStack((ItemLike)item), price, count, 12, experience);
        }

        public SellItemFactory(Item item, int price, int count, int maxUses, int experience) {
            this(new ItemStack((ItemLike)item), price, count, maxUses, experience);
        }

        public SellItemFactory(ItemStack stack, int price, int count, int maxUses, int experience) {
            this(stack, price, count, maxUses, experience, 0.05f);
        }

        public SellItemFactory(ItemStack stack, int price, int count, int maxUses, int experience, float multiplier) {
            this.sell = stack;
            this.price = price;
            this.count = count;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            ItemStack stack = new ItemStack((ItemLike)this.sell.m_41720_(), this.count);
            stack.m_41751_(this.sell.m_41783_());
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.price), stack, this.maxUses, this.experience, this.multiplier);
        }
    }

    static class SellSuspiciousStewFactory
    implements VillagerTrades.ItemListing {
        final MobEffect effect;
        final int duration;
        final int experience;
        private final float multiplier;

        public SellSuspiciousStewFactory(MobEffect effect, int duration, int experience) {
            this.effect = effect;
            this.duration = duration;
            this.experience = experience;
            this.multiplier = 0.05f;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            ItemStack itemStack = new ItemStack((ItemLike)Items.f_42718_, 1);
            SuspiciousStewItem.m_43258_((ItemStack)itemStack, (MobEffect)this.effect, (int)this.duration);
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 1), itemStack, 12, this.experience, this.multiplier);
        }
    }

    static class ProcessItemFactory
    implements VillagerTrades.ItemListing {
        private final ItemStack secondBuy;
        private final int secondCount;
        private final int price;
        private final ItemStack sell;
        private final int sellCount;
        private final int maxUses;
        private final int experience;
        private final float multiplier;

        public ProcessItemFactory(ItemLike item, int secondCount, Item sellItem, int sellCount, int maxUses, int experience) {
            this(item, secondCount, 1, sellItem, sellCount, maxUses, experience);
        }

        public ProcessItemFactory(ItemLike item, int secondCount, int price, Item sellItem, int sellCount, int maxUses, int experience) {
            this.secondBuy = new ItemStack(item);
            this.secondCount = secondCount;
            this.price = price;
            this.sell = new ItemStack((ItemLike)sellItem);
            this.sellCount = sellCount;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = 0.05f;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.price), new ItemStack((ItemLike)this.secondBuy.m_41720_(), this.secondCount), new ItemStack((ItemLike)this.sell.m_41720_(), this.sellCount), this.maxUses, this.experience, this.multiplier);
        }
    }

    static class SellEnchantedToolFactory
    implements VillagerTrades.ItemListing {
        private final ItemStack tool;
        private final int basePrice;
        private final int maxUses;
        private final int experience;
        private final float multiplier;

        public SellEnchantedToolFactory(Item item, int basePrice, int maxUses, int experience) {
            this(item, basePrice, maxUses, experience, 0.05f);
        }

        public SellEnchantedToolFactory(Item item, int basePrice, int maxUses, int experience, float multiplier) {
            this.tool = new ItemStack((ItemLike)item);
            this.basePrice = basePrice;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            int i = 5 + random.m_188503_(15);
            ItemStack itemStack = EnchantmentHelper.m_220292_((RandomSource)random, (ItemStack)new ItemStack((ItemLike)this.tool.m_41720_()), (int)i, (boolean)false);
            int j = Math.min(this.basePrice + i, 64);
            ItemStack itemStack2 = new ItemStack((ItemLike)Items.f_42616_, j);
            return new MerchantOffer(itemStack2, itemStack, this.maxUses, this.experience, this.multiplier);
        }
    }

    static class SellPotionHoldingItemFactory
    implements VillagerTrades.ItemListing {
        private final ItemStack sell;
        private final int sellCount;
        private final int price;
        private final int maxUses;
        private final int experience;
        private final Item secondBuy;
        private final int secondCount;
        private final float priceMultiplier;

        public SellPotionHoldingItemFactory(Item arrow, int secondCount, Item tippedArrow, int sellCount, int price, int maxUses, int experience) {
            this.sell = new ItemStack((ItemLike)tippedArrow);
            this.price = price;
            this.maxUses = maxUses;
            this.experience = experience;
            this.secondBuy = arrow;
            this.secondCount = secondCount;
            this.sellCount = sellCount;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            ItemStack itemStack = new ItemStack((ItemLike)Items.f_42616_, this.price);
            List<Potion> list = Registry.f_122828_.m_123024_().filter(potion -> !potion.m_43488_().isEmpty() && PotionBrewing.m_43511_((Potion)potion)).toList();
            Potion potion2 = list.get(random.m_188503_(list.size()));
            ItemStack itemStack2 = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)this.sell.m_41720_(), this.sellCount), (Potion)potion2);
            return new MerchantOffer(itemStack, new ItemStack((ItemLike)this.secondBuy, this.secondCount), itemStack2, this.maxUses, this.experience, this.priceMultiplier);
        }
    }

    static class EnchantBookFactory
    implements VillagerTrades.ItemListing {
        private final int experience;

        public EnchantBookFactory(int experience) {
            this.experience = experience;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            List<Enchantment> list = Registry.f_122825_.m_123024_().filter(Enchantment::m_6594_).toList();
            Enchantment enchantment = list.get(random.m_188503_(list.size()));
            int i = Mth.m_216271_((RandomSource)random, (int)enchantment.m_44702_(), (int)enchantment.m_6586_());
            ItemStack itemStack = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, i));
            int j = 2 + random.m_188503_(5 + i * 10) + 3 * i;
            if (enchantment.m_6591_()) {
                j *= 2;
            }
            if (j > 64) {
                j = 64;
            }
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, j), new ItemStack((ItemLike)Items.f_42517_), itemStack, 12, this.experience, 0.2f);
        }
    }

    static class SellDyedArmorFactory
    implements VillagerTrades.ItemListing {
        private final Item sell;
        private final int price;
        private final int maxUses;
        private final int experience;

        public SellDyedArmorFactory(Item item, int price) {
            this(item, price, 12, 1);
        }

        public SellDyedArmorFactory(Item item, int price, int maxUses, int experience) {
            this.sell = item;
            this.price = price;
            this.maxUses = maxUses;
            this.experience = experience;
        }

        private static DyeItem getDye(RandomSource random) {
            return DyeItem.m_41082_((DyeColor)DyeColor.m_41053_((int)random.m_188503_(16)));
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            ItemStack itemStack = new ItemStack((ItemLike)Items.f_42616_, this.price);
            ItemStack itemStack2 = new ItemStack((ItemLike)this.sell);
            if (this.sell instanceof DyeableArmorItem) {
                ArrayList list = Lists.newArrayList();
                list.add(SellDyedArmorFactory.getDye(random));
                if (random.m_188501_() > 0.7f) {
                    list.add(SellDyedArmorFactory.getDye(random));
                }
                if (random.m_188501_() > 0.8f) {
                    list.add(SellDyedArmorFactory.getDye(random));
                }
                itemStack2 = DyeableLeatherItem.m_41118_((ItemStack)itemStack2, (List)list);
            }
            return new MerchantOffer(itemStack, itemStack2, this.maxUses, this.experience, 0.2f);
        }
    }

    static class TypeAwareBuyForOneEmeraldFactory
    implements VillagerTrades.ItemListing {
        private final Map<VillagerType, Item> map;
        private final int count;
        private final int maxUses;
        private final int experience;

        public TypeAwareBuyForOneEmeraldFactory(int count, int maxUses, int experience, Map<VillagerType, Item> map) {
            Registry.f_122868_.m_123024_().filter(villagerType -> !map.containsKey(villagerType)).findAny().ifPresent(villagerType -> {
                throw new IllegalStateException("Missing trade for villager type: " + Registry.f_122868_.m_7981_(villagerType));
            });
            this.map = map;
            this.count = count;
            this.maxUses = maxUses;
            this.experience = experience;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            if (entity instanceof VillagerDataHolder) {
                ItemStack itemStack = new ItemStack((ItemLike)this.map.get(((VillagerDataHolder)entity).m_7141_().m_35560_()), this.count);
                return new MerchantOffer(itemStack, new ItemStack((ItemLike)Items.f_42616_), this.maxUses, this.experience, 0.05f);
            }
            return null;
        }
    }
}

