/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.common.codecs.yabn.YabnOps;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.utils.readers.ByteBufByteReader;
import com.teamresourceful.resourcefullib.common.utils.readers.ByteReader;
import com.teamresourceful.resourcefullib.common.yabn.YabnParser;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnElement;
import earth.terrarium.ad_astra.AdAstra;
import earth.terrarium.ad_astra.client.AdAstraClient;
import earth.terrarium.ad_astra.common.data.Planet;
import earth.terrarium.ad_astra.common.networking.NetworkHandling;
import earth.terrarium.ad_astra.common.networking.packet.client.RequestPlanetDataPacket;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class PlanetData
extends SimpleJsonResourceReloadListener {
    private static final Set<Planet> PLANETS = new HashSet<Planet>();
    private static final Map<ResourceKey<Level>, Planet> LEVEL_TO_PLANET = new HashMap<ResourceKey<Level>, Planet>();
    private static final Map<ResourceKey<Level>, Planet> ORBIT_TO_PLANET = new HashMap<ResourceKey<Level>, Planet>();
    private static final Set<ResourceKey<Level>> PLANET_LEVELS = new HashSet<ResourceKey<Level>>();
    private static final Set<ResourceKey<Level>> ORBITS_LEVELS = new HashSet<ResourceKey<Level>>();
    private static final Set<ResourceKey<Level>> OXYGEN_LEVELS = new HashSet<ResourceKey<Level>>();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public PlanetData() {
        super(GSON, "planet_data/planets");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
        profiler.m_6180_("Ad Astra Planet Deserialization");
        ArrayList<Planet> planets = new ArrayList<Planet>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : objects.entrySet()) {
            JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"planet");
            Planet newPlanet = (Planet)Planet.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)AdAstra.LOGGER).error(arg_0));
            planets.removeIf(planet -> planet.level().equals(newPlanet.level()));
            planets.add(newPlanet);
        }
        PlanetData.updatePlanets(planets);
        profiler.m_7238_();
    }

    public static void updatePlanets(Collection<Planet> planets) {
        PlanetData.clear();
        for (Planet planet : new HashSet<Planet>(planets)) {
            PLANETS.add(planet);
            LEVEL_TO_PLANET.put(planet.level(), planet);
            ORBIT_TO_PLANET.put(planet.orbitWorld(), planet);
            PLANET_LEVELS.add(planet.level());
            ORBITS_LEVELS.add(planet.orbitWorld());
            if (!planet.hasOxygen()) continue;
            OXYGEN_LEVELS.add(planet.level());
        }
    }

    private static void clear() {
        PLANETS.clear();
        LEVEL_TO_PLANET.clear();
        ORBIT_TO_PLANET.clear();
        ORBITS_LEVELS.clear();
        OXYGEN_LEVELS.clear();
    }

    public static void writePlanetData(FriendlyByteBuf buf) {
        YabnElement element = (YabnElement)Planet.CODEC.listOf().encodeStart((DynamicOps)YabnOps.COMPRESSED, PlanetData.planets().stream().toList()).getOrThrow(false, arg_0 -> ((Logger)AdAstra.LOGGER).error(arg_0));
        buf.writeBytes(element.toData());
    }

    public static void readPlanetData(FriendlyByteBuf buf) {
        try {
            PlanetData.updatePlanets((Collection)Planet.CODEC.listOf().parse((DynamicOps)YabnOps.COMPRESSED, (Object)YabnParser.parse((ByteReader)new ByteBufByteReader((ByteBuf)buf))).result().orElseThrow());
        }
        catch (Exception e) {
            AdAstra.LOGGER.error("Failed to parse planet data!");
            e.printStackTrace();
            PlanetData.updatePlanets(List.of());
        }
    }

    public static Set<Planet> planets() {
        return PLANETS;
    }

    public static Optional<Planet> getPlanetFromLevel(ResourceKey<Level> level) {
        return Optional.ofNullable(LEVEL_TO_PLANET.get(level));
    }

    public static Optional<Planet> getPlanetFromOrbit(ResourceKey<Level> level) {
        return Optional.ofNullable(ORBIT_TO_PLANET.get(level));
    }

    public static boolean isOrbitLevel(ResourceKey<Level> level) {
        return ORBITS_LEVELS.contains(level);
    }

    public static boolean isPlanetLevel(Level level) {
        if (level.f_46443_ && !AdAstraClient.hasUpdatedPlanets) {
            NetworkHandling.CHANNEL.sendToServer((Packet)new RequestPlanetDataPacket());
            AdAstraClient.hasUpdatedPlanets = true;
        }
        return PLANET_LEVELS.contains(level.m_46472_());
    }

    public static boolean isOxygenated(ResourceKey<Level> level) {
        return OXYGEN_LEVELS.contains(level);
    }
}

