/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import earth.terrarium.ad_astra.client.screen.GuiUtil;
import earth.terrarium.ad_astra.common.compat.jei.EnergyBarDrawable;
import earth.terrarium.ad_astra.common.compat.jei.FluidBarDrawable;
import earth.terrarium.ad_astra.common.compat.jei.category.BaseCategory;
import earth.terrarium.ad_astra.common.config.FuelRefineryConfig;
import earth.terrarium.ad_astra.common.recipe.FuelConversionRecipe;
import earth.terrarium.ad_astra.common.registry.ModItems;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public class FuelConversionCategory
extends BaseCategory<FuelConversionRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("ad_astra", "fuel_conversion");
    public static final RecipeType<FuelConversionRecipe> RECIPE = new RecipeType(ID, FuelConversionRecipe.class);
    private final IDrawableAnimated arrow;

    public FuelConversionCategory(IGuiHelper guiHelper) {
        super(guiHelper, RECIPE, (Component)Component.m_237115_((String)((Item)ModItems.FUEL_REFINERY.get()).m_5524_()), (IDrawable)guiHelper.createBlankDrawable(144, 90), guiHelper.createDrawableItemStack(((Item)ModItems.FUEL_REFINERY.get()).m_7968_()));
        this.arrow = guiHelper.drawableBuilder(GuiUtil.ARROW_TEXTURE, 0, 0, 24, 17).setTextureSize(24, 17).buildAnimated(100, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FuelConversionRecipe recipe, IFocusGroup focuses) {
        builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.FUEL_REFINERY.get()}));
        IIngredientAcceptor input = builder.addInvisibleIngredients(RecipeIngredientRole.INPUT);
        recipe.getFluidInput().m_203614_().forEach(fluid -> input.addFluidStack((Fluid)fluid.m_203334_(), FluidHooks.buckets((int)1)));
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addFluidStack(recipe.getFluidOutput(), FluidHooks.buckets((int)1));
    }

    public void draw(FuelConversionRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        new FluidBarDrawable(FluidHooks.newFluidHolder((Fluid)((Fluid)recipe.getFluidInput().m_203662_(0).m_203334_()), (long)FluidHooks.buckets((int)1), null), false, 5000).draw(poseStack, 15, 15);
        new FluidBarDrawable(FluidHooks.newFluidHolder((Fluid)recipe.getFluidOutput(), (long)FluidHooks.buckets((int)1), null), true, 5000).draw(poseStack, 80, 15);
        new EnergyBarDrawable(false, 10000).draw(poseStack, 120, 15);
        this.arrow.draw(poseStack, 40, 30);
    }

    public List<Component> getTooltipStrings(FuelConversionRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        if (mouseX > 118.0 && mouseY > 13.0 && mouseX < 131.0 && mouseY < 59.0) {
            tooltips.add((Component)Component.m_237110_((String)"rei.tooltip.ad_astra.energy_using", (Object[])new Object[]{FuelRefineryConfig.energyPerTick}));
        }
        if (mouseX > 15.0 && mouseY > 13.0 && mouseX < 29.0 && mouseY < 61.0) {
            tooltips.add(GuiUtil.getFluidTranslation((Fluid)recipe.getFluidInput().m_203662_(0).m_203334_()));
        }
        if (mouseX > 80.0 && mouseY > 13.0 && mouseX < 94.0 && mouseY < 61.0) {
            tooltips.add(GuiUtil.getFluidTranslation(recipe.getFluidOutput()));
        }
        return tooltips;
    }
}

