/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.compat.jei;

import earth.terrarium.ad_astra.client.screen.CompressorScreen;
import earth.terrarium.ad_astra.client.screen.ConversionScreen;
import earth.terrarium.ad_astra.client.screen.CryoFreezerScreen;
import earth.terrarium.ad_astra.client.screen.NasaWorkbenchScreen;
import earth.terrarium.ad_astra.client.screen.OxygenDistributorScreen;
import earth.terrarium.ad_astra.common.compat.jei.category.CompressorCategory;
import earth.terrarium.ad_astra.common.compat.jei.category.CryoFuelConversionCategory;
import earth.terrarium.ad_astra.common.compat.jei.category.FuelConversionCategory;
import earth.terrarium.ad_astra.common.compat.jei.category.NasaWorkbenchCategory;
import earth.terrarium.ad_astra.common.compat.jei.category.OxygenConversionCategory;
import earth.terrarium.ad_astra.common.compat.jei.guihandler.CompressorGuiContainerHandler;
import earth.terrarium.ad_astra.common.compat.jei.guihandler.CryoFreezerGuiContainerHandler;
import earth.terrarium.ad_astra.common.compat.jei.guihandler.FuelConversionGuiContainerHandler;
import earth.terrarium.ad_astra.common.compat.jei.guihandler.NasaWorkbenchGuiContainerHandler;
import earth.terrarium.ad_astra.common.compat.jei.guihandler.OxygenConversionGuiContainerHandler;
import earth.terrarium.ad_astra.common.compat.jei.guihandler.OxygenDistributorGuiContainerHandler;
import earth.terrarium.ad_astra.common.compat.jei.transfer.MachineTransferInfo;
import earth.terrarium.ad_astra.common.compat.jei.transfer.NotifyableTransferHandler;
import earth.terrarium.ad_astra.common.recipe.CompressingRecipe;
import earth.terrarium.ad_astra.common.recipe.CryoFuelConversionRecipe;
import earth.terrarium.ad_astra.common.recipe.NasaWorkbenchRecipe;
import earth.terrarium.ad_astra.common.registry.ModItems;
import earth.terrarium.ad_astra.common.registry.ModMenus;
import earth.terrarium.ad_astra.common.registry.ModRecipeTypes;
import earth.terrarium.ad_astra.common.screen.menu.CompressorMenu;
import earth.terrarium.ad_astra.common.screen.menu.CryoFreezerMenu;
import earth.terrarium.ad_astra.common.screen.menu.NasaWorkbenchMenu;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;

@JeiPlugin
public class AdAstraJeiPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("ad_astra", "jei");
    }

    public void registerIngredients(IModIngredientRegistration registration) {
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CompressorCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new NasaWorkbenchCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FuelConversionCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new OxygenConversionCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CryoFuelConversionCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        assert (level != null);
        registration.addRecipes(CompressorCategory.RECIPE, level.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.COMPRESSING_RECIPE.get()));
        registration.addRecipes(NasaWorkbenchCategory.RECIPE, level.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.NASA_WORKBENCH_RECIPE.get()));
        registration.addRecipes(FuelConversionCategory.RECIPE, level.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.FUEL_CONVERSION_RECIPE.get()));
        registration.addRecipes(OxygenConversionCategory.RECIPE, level.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.OXYGEN_CONVERSION_RECIPE.get()));
        registration.addRecipes(CryoFuelConversionCategory.RECIPE, level.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.CRYO_FUEL_CONVERSION_RECIPE.get()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Item)ModItems.COMPRESSOR.get()).m_7968_(), new RecipeType[]{CompressorCategory.RECIPE});
        registration.addRecipeCatalyst(((Item)ModItems.NASA_WORKBENCH.get()).m_7968_(), new RecipeType[]{NasaWorkbenchCategory.RECIPE});
        registration.addRecipeCatalyst(((Item)ModItems.FUEL_REFINERY.get()).m_7968_(), new RecipeType[]{FuelConversionCategory.RECIPE});
        registration.addRecipeCatalyst(((Item)ModItems.OXYGEN_LOADER.get()).m_7968_(), new RecipeType[]{OxygenConversionCategory.RECIPE});
        registration.addRecipeCatalyst(((Item)ModItems.OXYGEN_DISTRIBUTOR.get()).m_7968_(), new RecipeType[]{OxygenConversionCategory.RECIPE});
        registration.addRecipeCatalyst(((Item)ModItems.CRYO_FREEZER.get()).m_7968_(), new RecipeType[]{CryoFuelConversionCategory.RECIPE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(CompressorScreen.class, (IGuiContainerHandler)new CompressorGuiContainerHandler());
        registration.addGuiContainerHandler(NasaWorkbenchScreen.class, (IGuiContainerHandler)new NasaWorkbenchGuiContainerHandler());
        registration.addGuiContainerHandler(ConversionScreen.class, (IGuiContainerHandler)new FuelConversionGuiContainerHandler());
        registration.addGuiContainerHandler(ConversionScreen.class, (IGuiContainerHandler)new OxygenConversionGuiContainerHandler());
        registration.addGuiContainerHandler(OxygenDistributorScreen.class, (IGuiContainerHandler)new OxygenDistributorGuiContainerHandler());
        registration.addGuiContainerHandler(CryoFreezerScreen.class, (IGuiContainerHandler)new CryoFreezerGuiContainerHandler());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        IRecipeTransferHandlerHelper transferHelper = registration.getTransferHelper();
        registration.addRecipeTransferHandler(new MachineTransferInfo<CompressorMenu, CompressingRecipe>(CompressorMenu.class, (MenuType)ModMenus.COMPRESSOR_MENU.get(), CompressorCategory.RECIPE));
        registration.addRecipeTransferHandler(new NotifyableTransferHandler(transferHelper.createUnregisteredRecipeTransferHandler((IRecipeTransferInfo)new MachineTransferInfo<NasaWorkbenchMenu, NasaWorkbenchRecipe>(NasaWorkbenchMenu.class, (MenuType)ModMenus.NASA_WORKBENCH_MENU.get(), NasaWorkbenchCategory.RECIPE){

            @Override
            protected int getInputSlotCount(NasaWorkbenchMenu menu) {
                return 14;
            }
        })), NasaWorkbenchCategory.RECIPE);
        registration.addRecipeTransferHandler(new MachineTransferInfo<CryoFreezerMenu, CryoFuelConversionRecipe>(CryoFreezerMenu.class, (MenuType)ModMenus.CRYO_FREEZER_MENU.get(), CryoFuelConversionCategory.RECIPE));
    }
}

