/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.machine.entity;

import earth.terrarium.ad_astra.common.block.machine.AbstractMachineBlock;
import earth.terrarium.ad_astra.common.block.machine.entity.AbstractMachineBlockEntity;
import earth.terrarium.ad_astra.common.config.WaterPumpConfig;
import earth.terrarium.ad_astra.common.container.WaterPumpFluidTank;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.ad_astra.common.registry.ModParticleTypes;
import earth.terrarium.ad_astra.common.screen.menu.WaterPumpMenu;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.energy.EnergyBlock;
import earth.terrarium.botarium.api.energy.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHoldingBlock;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.WaterFluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaterPumpBlockEntity
extends AbstractMachineBlockEntity
implements FluidHoldingBlock,
EnergyBlock {
    private InsertOnlyEnergyContainer energyContainer;
    private long waterExtracted;
    private WaterPumpFluidTank tank;

    public WaterPumpBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.WATER_PUMP.get(), blockPos, blockState);
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, @NotNull Inventory inv, @NotNull Player player) {
        return new WaterPumpMenu(syncId, inv, this);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.waterExtracted = nbt.m_128454_("WaterExtracted");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128356_("WaterExtracted", this.waterExtracted);
    }

    @Override
    public void tick() {
        if (!this.m_58904_().m_5776_()) {
            FluidState water = this.f_58857_.m_6425_(this.m_58899_().m_7495_());
            if (this.getFluidContainer().getFluids().get(0).getFluidAmount() < this.getFluidContainer().getTankCapacity(0)) {
                if (water.m_76152_() instanceof WaterFluid.Source) {
                    if (!((Boolean)this.m_58900_().m_61143_((Property)AbstractMachineBlock.POWERED)).booleanValue() && this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), true) > 0L) {
                        this.setActive(true);
                        ModUtils.spawnForcedParticles((ServerLevel)this.f_58857_, (SimpleParticleType)ModParticleTypes.OXYGEN_BUBBLE.get(), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() - 0.5, (double)this.m_58899_().m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.01);
                        this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), false);
                        this.waterExtracted += WaterPumpConfig.transferPerTick;
                        FluidHolder waterFluid = FluidHooks.newFluidHolder((Fluid)Fluids.f_76193_, (long)WaterPumpConfig.transferPerTick, null);
                        this.getFluidContainer().insertInternal(waterFluid, false);
                    } else {
                        this.setActive(false);
                    }
                    if (WaterPumpConfig.deleteWaterBelowWaterPump && this.waterExtracted >= FluidHooks.buckets((int)1)) {
                        this.waterExtracted = 0L;
                        this.f_58857_.m_46597_(this.m_58899_().m_7495_(), Blocks.f_50016_.m_49966_());
                    }
                }
            } else {
                this.setActive(false);
            }
            if (this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), true) > 0L && !this.getFluidContainer().isEmpty()) {
                for (Direction direction : new Direction[]{Direction.UP, (Direction)this.m_58900_().m_61143_((Property)AbstractMachineBlock.FACING)}) {
                    FluidHolder fluid = FluidHooks.newFluidHolder((Fluid)this.getFluidContainer().getFluids().get(0).getFluid(), (long)(WaterPumpConfig.transferPerTick * 2L), (CompoundTag)this.getFluidContainer().getFluids().get(0).getCompound());
                    this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), false);
                    if (FluidHooks.moveBlockToBlockFluid((BlockEntity)this, (Direction)direction.m_122424_(), (BlockEntity)this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction)), (Direction)direction, (FluidHolder)fluid) > 0L) break;
                }
            }
        }
    }

    public WaterPumpFluidTank getFluidContainer() {
        return this.tank == null ? (this.tank = new WaterPumpFluidTank((Updatable)this)) : this.tank;
    }

    public long getEnergyPerTick() {
        return WaterPumpConfig.energyPerTick;
    }

    public long getMaxCapacity() {
        return this.getEnergyStorage().getMaxCapacity();
    }

    public InsertOnlyEnergyContainer getEnergyStorage() {
        return this.energyContainer == null ? (this.energyContainer = new InsertOnlyEnergyContainer((Updatable)this, (long)((int)WaterPumpConfig.maxEnergy))) : this.energyContainer;
    }

    public void update() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

