/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.renderer.block.flag;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import earth.terrarium.ad_astra.client.AdAstraClient;
import earth.terrarium.ad_astra.client.renderer.block.flag.FlagTexture;
import earth.terrarium.ad_astra.common.block.flag.EightDirectionProperty;
import earth.terrarium.ad_astra.common.block.flag.FlagBlock;
import earth.terrarium.ad_astra.common.block.flag.FlagBlockEntity;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class FlagBlockEntityRenderer
implements BlockEntityRenderer<FlagBlockEntity> {
    public FlagBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(FlagBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (((DoubleBlockHalf)entity.m_58900_().m_61143_(FlagBlock.HALF)).equals((Object)DoubleBlockHalf.LOWER)) {
            ResourceLocation texture = new ResourceLocation("ad_astra", "block/flag/" + Registry.f_122824_.m_7981_((Object)entity.m_58900_().m_60734_()).m_135815_());
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)((EightDirectionProperty.Direction)((Object)entity.m_58900_().m_61143_((Property)FlagBlock.FACING))).asRotation()));
            poseStack.m_85837_(-0.5, 0.0, -0.5);
            AdAstraClient.renderBlock(texture, poseStack, buffer, packedLight, packedOverlay);
            poseStack.m_85849_();
        } else {
            String url = entity.getUrl();
            if (url != null) {
                FlagBlockEntityRenderer.renderFullTexture(entity, poseStack, buffer, packedLight, packedOverlay, false);
                FlagBlockEntityRenderer.renderFullTexture(entity, poseStack, buffer, packedLight, packedOverlay, true);
            } else {
                FlagBlockEntityRenderer.renderFace(entity, poseStack, buffer, packedLight, packedOverlay, false);
                FlagBlockEntityRenderer.renderFace(entity, poseStack, buffer, packedLight, packedOverlay, true);
            }
        }
    }

    private static void renderFullTexture(FlagBlockEntity entity, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, boolean flip) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.0, 0.5);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)((EightDirectionProperty.Direction)((Object)entity.m_58900_().m_61143_((Property)FlagBlock.FACING))).asRotation()));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        poseStack.m_85837_(-1.375, -0.375, flip ? -0.01 : 0.01);
        if (!flip) {
            FlagBlockEntityRenderer.flipY(poseStack, 1.25f);
        }
        VertexConsumer vertexConsumer = buffer.m_6299_(FlagBlockEntityRenderer.getFlagImage(entity.getUrl()));
        FlagBlockEntityRenderer.renderQuad(poseStack, vertexConsumer, 1.25f, 0.875f, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, packedOverlay);
        poseStack.m_85849_();
    }

    private static void renderFace(FlagBlockEntity entity, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int overlay, boolean flip) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.0, 0.5);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)((EightDirectionProperty.Direction)((Object)entity.m_58900_().m_61143_((Property)FlagBlock.FACING))).asRotation()));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        poseStack.m_85837_(-1.0, -0.25, flip ? -0.01 : 0.01);
        if (flip) {
            FlagBlockEntityRenderer.flipY(poseStack, 0.5f);
        }
        VertexConsumer vertexConsumer = buffer.m_6299_(FlagBlockEntityRenderer.getRenderLayer(entity.getOwner()));
        FlagBlockEntityRenderer.renderQuad(poseStack, vertexConsumer, 0.5f, 0.5f, 0.125f, 0.125f, 0.125f, 0.125f, packedLight, overlay);
        FlagBlockEntityRenderer.renderQuad(poseStack, vertexConsumer, 0.5f, 0.5f, 0.5f, 0.125f, 0.125f, 0.125f, packedLight, overlay);
        poseStack.m_85849_();
    }

    private static void renderQuad(PoseStack poseStack, VertexConsumer consumer, float width, float height, float u, float v, float uWidth, float vHeight, int light, int overlay) {
        consumer.m_85982_(poseStack.m_85850_().m_85861_(), 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_85982_(poseStack.m_85850_().m_85861_(), 0.0f, height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u, v + vHeight).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_85982_(poseStack.m_85850_().m_85861_(), width, height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u + uWidth, v + vHeight).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_85982_(poseStack.m_85850_().m_85861_(), width, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u + uWidth, v).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
    }

    private static void flipY(PoseStack poseStack, float width) {
        Vector4f vec3f = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        vec3f.m_123607_(poseStack.m_85850_().m_85861_());
        poseStack.m_85837_((double)(-vec3f.m_123601_()), (double)(-vec3f.m_123615_()), (double)(-vec3f.m_123616_()));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        poseStack.m_85837_((double)vec3f.m_123601_(), (double)vec3f.m_123615_(), (double)vec3f.m_123616_());
        poseStack.m_85837_((double)(-width), 0.0, 0.0);
    }

    public static RenderType getRenderLayer(@Nullable GameProfile profile) {
        if (profile == null) {
            return RenderType.m_110464_((ResourceLocation)new ResourceLocation("textures/entity/zombie/zombie.png"));
        }
        Minecraft minecraftClient = Minecraft.m_91087_();
        Map map = minecraftClient.m_91109_().m_118815_(profile);
        if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            return RenderType.m_110473_((ResourceLocation)minecraftClient.m_91109_().m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN));
        }
        return RenderType.m_110458_((ResourceLocation)DefaultPlayerSkin.m_118627_((UUID)UUIDUtil.m_235875_((GameProfile)profile)));
    }

    public static RenderType getFlagImage(String url) {
        ResourceLocation id = FlagTexture.getTextureId(url);
        TextureManager manager = Minecraft.m_91087_().m_91097_();
        AbstractTexture texture = manager.m_174786_(id, (AbstractTexture)MissingTextureAtlasSprite.m_118080_());
        if (texture == MissingTextureAtlasSprite.m_118080_()) {
            manager.m_118495_(id, (AbstractTexture)new FlagTexture(url));
        }
        return RenderType.m_110473_((ResourceLocation)id);
    }
}

