/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import earth.terrarium.ad_astra.client.ClientPlatformUtils;
import earth.terrarium.ad_astra.client.registry.ClientModEntities;
import earth.terrarium.ad_astra.client.registry.ClientModKeybindings;
import earth.terrarium.ad_astra.client.registry.ClientModScreens;
import earth.terrarium.ad_astra.client.renderer.armor.ArmourRenderers;
import earth.terrarium.ad_astra.client.renderer.block.ChestItemRenderer;
import earth.terrarium.ad_astra.client.renderer.block.EnergizerBlockEntityRenderer;
import earth.terrarium.ad_astra.client.renderer.block.SlidingDoorBlockEntityRenderer;
import earth.terrarium.ad_astra.client.renderer.block.flag.FlagBlockEntityRenderer;
import earth.terrarium.ad_astra.client.renderer.block.flag.FlagItemRenderer;
import earth.terrarium.ad_astra.client.renderer.block.globe.GlobeRenderer;
import earth.terrarium.ad_astra.client.renderer.entity.vehicle.rocket.tier_1.RocketItemRendererTier1;
import earth.terrarium.ad_astra.client.renderer.entity.vehicle.rocket.tier_2.RocketItemRendererTier2;
import earth.terrarium.ad_astra.client.renderer.entity.vehicle.rocket.tier_3.RocketItemRendererTier3;
import earth.terrarium.ad_astra.client.renderer.entity.vehicle.rocket.tier_4.RocketItemRendererTier4;
import earth.terrarium.ad_astra.client.renderer.entity.vehicle.rover.RoverItemRenderer;
import earth.terrarium.ad_astra.client.resourcepack.Galaxy;
import earth.terrarium.ad_astra.client.resourcepack.PlanetResources;
import earth.terrarium.ad_astra.client.resourcepack.PlanetRing;
import earth.terrarium.ad_astra.client.resourcepack.PlanetSkyRenderer;
import earth.terrarium.ad_astra.client.resourcepack.SolarSystem;
import earth.terrarium.ad_astra.client.screen.PlayerOverlayScreen;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.ad_astra.common.registry.ModBlocks;
import earth.terrarium.ad_astra.common.registry.ModFluids;
import earth.terrarium.ad_astra.common.registry.ModItems;
import earth.terrarium.botarium.client.ClientHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.util.TriConsumer;

@OnlyIn(value=Dist.CLIENT)
public class AdAstraClient {
    public static boolean hasUpdatedPlanets;
    public static List<SolarSystem> solarSystems;
    public static List<PlanetSkyRenderer> skyRenderers;
    public static List<PlanetRing> planetRings;
    public static List<Galaxy> galaxies;

    public static void init() {
        ClientModScreens.init();
        ClientModKeybindings.init();
        ArmourRenderers.init();
        ClientModEntities.registerEntityRenderers();
        ClientHooks.registerBlockEntityRenderers((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.FLAG.get()), FlagBlockEntityRenderer::new);
        ClientHooks.registerBlockEntityRenderers((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.GLOBE.get()), GlobeRenderer::new);
        ClientHooks.registerBlockEntityRenderers((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.ENERGIZER.get()), EnergizerBlockEntityRenderer::new);
        ClientHooks.registerBlockEntityRenderers((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.SLIDING_DOOR.get()), SlidingDoorBlockEntityRenderer::new);
        ClientHooks.registerBlockEntityRenderers((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.SIGN.get()), SignRenderer::new);
        ClientHooks.registerBlockEntityRenderers((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.CHEST.get()), ChestRenderer::new);
        Sheets.f_110743_.put(ModBlocks.GLACIAN_SIGN_TYPE, new Material(Sheets.f_110739_, new ResourceLocation("ad_astra", "entity/signs/glacian")));
    }

    public static void onRegisterHud(Consumer<RenderHud> register) {
        register.accept(PlayerOverlayScreen::render);
    }

    public static void onRegisterFluidRenderTypes(TriConsumer<RenderType, Fluid, Fluid> register) {
        register.accept((Object)RenderType.m_110466_(), (Object)((Fluid)ModFluids.FUEL.get()), (Object)((Fluid)ModFluids.FLOWING_FUEL.get()));
        register.accept((Object)RenderType.m_110466_(), (Object)((Fluid)ModFluids.CRYO_FUEL.get()), (Object)((Fluid)ModFluids.FLOWING_CRYO_FUEL.get()));
        register.accept((Object)RenderType.m_110466_(), (Object)((Fluid)ModFluids.OIL.get()), (Object)((Fluid)ModFluids.FLOWING_OIL.get()));
        register.accept((Object)RenderType.m_110466_(), (Object)((Fluid)ModFluids.OXYGEN.get()), (Object)((Fluid)ModFluids.FLOWING_OXYGEN.get()));
    }

    public static void onRegisterBlockRenderTypes(BiConsumer<RenderType, List<Block>> register) {
        ClientHooks.setRenderLayer((Block)((Block)ModBlocks.VENT.get()), (RenderType)RenderType.m_110463_());
        ModBlocks.GLOBES.stream().forEach(block -> register.accept(RenderType.m_110463_(), List.of((Block)block.get())));
        register.accept(RenderType.m_110463_(), List.of((Block)ModBlocks.WATER_PUMP.get(), (Block)ModBlocks.ENERGIZER.get(), (Block)ModBlocks.STEEL_DOOR.get(), (Block)ModBlocks.STEEL_TRAPDOOR.get(), (Block)ModBlocks.GLACIAN_DOOR.get(), (Block)ModBlocks.GLACIAN_TRAPDOOR.get(), (Block)ModBlocks.AERONOS_DOOR.get(), (Block)ModBlocks.AERONOS_TRAPDOOR.get(), (Block)ModBlocks.STROPHAR_DOOR.get(), (Block)ModBlocks.STROPHAR_TRAPDOOR.get(), (Block)ModBlocks.EXTINGUISHED_TORCH.get(), (Block)ModBlocks.WALL_EXTINGUISHED_TORCH.get(), (Block)ModBlocks.EXTINGUISHED_LANTERN.get(), (Block)ModBlocks.GLACIAN_LEAVES.get(), (Block)ModBlocks.NASA_WORKBENCH.get(), (Block)ModBlocks.AERONOS_MUSHROOM.get(), (Block)ModBlocks.STROPHAR_MUSHROOM.get(), (Block)ModBlocks.AERONOS_LADDER.get(), (Block)ModBlocks.STROPHAR_LADDER.get(), (Block)ModBlocks.AERONOS_CHEST.get(), (Block)ModBlocks.STROPHAR_CHEST.get()));
    }

    public static void onRegisterItemRenderers(BiConsumer<ItemLike, BlockEntityWithoutLevelRenderer> register) {
        register.accept((ItemLike)ModItems.TIER_1_ROCKET.get(), new RocketItemRendererTier1());
        register.accept((ItemLike)ModItems.TIER_2_ROCKET.get(), new RocketItemRendererTier2());
        register.accept((ItemLike)ModItems.TIER_3_ROCKET.get(), new RocketItemRendererTier3());
        register.accept((ItemLike)ModItems.TIER_4_ROCKET.get(), new RocketItemRendererTier4());
        register.accept((ItemLike)ModItems.TIER_1_ROVER.get(), new RoverItemRenderer());
        register.accept((ItemLike)ModBlocks.AERONOS_CHEST.get(), new ChestItemRenderer((Block)ModBlocks.AERONOS_CHEST.get()));
        register.accept((ItemLike)ModBlocks.STROPHAR_CHEST.get(), new ChestItemRenderer((Block)ModBlocks.STROPHAR_CHEST.get()));
        ModItems.GLOBES.stream().forEach(item -> register.accept((ItemLike)item.get(), new GlobeRenderer.ItemRenderer()));
        ModItems.FLAGS.stream().forEach(item -> register.accept((ItemLike)item.get(), new FlagItemRenderer()));
    }

    public static void onRegisterReloadListeners(BiConsumer<ResourceLocation, PreparableReloadListener> registry) {
        registry.accept(new ResourceLocation("ad_astra", "planet_resources"), (PreparableReloadListener)new PlanetResources());
    }

    public static void onRegisterChestSprites(Consumer<ResourceLocation> register) {
        register.accept(new ResourceLocation("ad_astra", "entity/chest/aeronos_chest"));
        register.accept(new ResourceLocation("ad_astra", "entity/chest/aeronos_chest_right"));
        register.accept(new ResourceLocation("ad_astra", "entity/chest/aeronos_chest_left"));
        register.accept(new ResourceLocation("ad_astra", "entity/chest/strophar_chest"));
        register.accept(new ResourceLocation("ad_astra", "entity/chest/strophar_chest_right"));
        register.accept(new ResourceLocation("ad_astra", "entity/chest/strophar_chest_left"));
    }

    public static void onRegisterSprites(Consumer<ResourceLocation> register) {
        register.accept(new ResourceLocation("ad_astra", "particle/flame_1"));
        register.accept(new ResourceLocation("ad_astra", "particle/flame_2"));
        register.accept(new ResourceLocation("ad_astra", "particle/flame_3"));
        register.accept(new ResourceLocation("ad_astra", "particle/flame_4"));
        register.accept(new ResourceLocation("ad_astra", "particle/venus_rain_1"));
        register.accept(new ResourceLocation("ad_astra", "particle/venus_rain_2"));
        register.accept(new ResourceLocation("ad_astra", "particle/venus_rain_3"));
        register.accept(new ResourceLocation("ad_astra", "particle/venus_rain_4"));
    }

    public static void onRegisterModels(Consumer<ResourceLocation> register) {
        ModBlocks.GLOBES.stream().forEach(b -> register.accept(new ResourceLocation("ad_astra", "block/" + b.getId().m_135815_() + "_cube")));
        ModBlocks.FLAGS.stream().forEach(block -> register.accept(new ResourceLocation("ad_astra", "block/flag/" + block.getId().m_135815_())));
        ModBlocks.SLIDING_DOORS.stream().forEach(block -> register.accept(new ResourceLocation("ad_astra", "block/door/" + block.getId().m_135815_())));
        ModBlocks.SLIDING_DOORS.stream().forEach(block -> register.accept(new ResourceLocation("ad_astra", "block/door/" + block.getId().m_135815_() + "_flipped")));
    }

    public static void renderBlock(ResourceLocation model, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Minecraft minecraft = Minecraft.m_91087_();
        ModelManager manager = minecraft.m_91304_();
        BakedModel baked = ClientPlatformUtils.getModel(manager, model);
        VertexConsumer vertexConsumer1 = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)InventoryMenu.f_39692_));
        List quads1 = baked.m_213637_(null, null, minecraft.f_91073_.f_46441_);
        PoseStack.Pose entry1 = poseStack.m_85850_();
        for (BakedQuad quad : quads1) {
            vertexConsumer1.m_85987_(entry1, quad, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
        }
    }

    static {
        solarSystems = new ArrayList<SolarSystem>();
        skyRenderers = new ArrayList<PlanetSkyRenderer>();
        planetRings = new ArrayList<PlanetRing>();
        galaxies = new ArrayList<Galaxy>();
    }

    @FunctionalInterface
    public static interface RenderHud {
        public void renderHud(PoseStack var1, float var2);
    }
}

