/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbauxilium.auxilium;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.platform.GlUtil;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.repository.Pack;

public class SystemStats {
    public String timeZone;
    public String javaVersion;
    public String javaVendor;
    public long memoryTotal;
    public long memoryMax;
    public int cpuCores;
    public String operatingSystemArch;
    public String operatingSystem;
    public String cpu;
    public String gpu;
    public String version;
    public String launchVersion;
    public String clientBrand;
    public double guiScale;
    public int resourcePacks = 0;
    public int refreshRate;
    public boolean vsync;
    public boolean fullscreen;
    public String lang;
    public int packId = -1;
    public int packVersionId = -1;

    public SystemStats(Minecraft minecraft) {
        Runtime runtime = Runtime.getRuntime();
        this.javaVersion = System.getProperty("java.version");
        this.javaVendor = System.getProperty("java.vendor");
        this.memoryTotal = runtime.totalMemory();
        this.memoryMax = runtime.maxMemory();
        this.cpuCores = runtime.availableProcessors();
        this.operatingSystemArch = System.getProperty("os.arch");
        this.operatingSystem = Util.m_137581_().toString();
        this.timeZone = System.getProperty("user.timezone");
        this.cpu = GlUtil.m_84819_();
        this.gpu = GlUtil.m_84820_();
        this.guiScale = minecraft.m_91268_().m_85449_();
        for (Pack pack : minecraft.m_91099_().m_10524_()) {
            if (pack.m_10449_() || pack.m_10449_()) continue;
            ++this.resourcePacks;
        }
        this.refreshRate = minecraft.m_91268_().m_85377_();
        this.vsync = (Boolean)minecraft.f_91066_.m_231817_().m_231551_();
        this.fullscreen = (Boolean)minecraft.f_91066_.m_231829_().m_231551_();
        this.lang = minecraft.f_91066_.f_92075_;
        this.version = SharedConstants.m_183709_().getName();
        this.launchVersion = minecraft.m_91388_();
        this.clientBrand = ClientBrandRetriever.m_129629_();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("timeZone", (Object)this.timeZone).add("javaVersion", (Object)this.javaVersion).add("javaVendor", (Object)this.javaVendor).add("memoryTotal", this.memoryTotal).add("memoryMax", this.memoryMax).add("cpuCores", this.cpuCores).add("operatingSystemArch", (Object)this.operatingSystemArch).add("operatingSystem", (Object)this.operatingSystem).add("cpu", (Object)this.cpu).add("gpu", (Object)this.gpu).add("version", (Object)this.version).add("launchVersion", (Object)this.launchVersion).add("clientBrand", (Object)this.clientBrand).add("guiScale", this.guiScale).add("resourcePacks", this.resourcePacks).add("refreshRate", this.refreshRate).add("vsync", this.vsync).add("fullscreen", this.fullscreen).add("lang", (Object)this.lang).toString();
    }
}

