/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbauxilium.auxilium;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.ftb.mods.ftbauxilium.AuxiliumExpectPlatform;
import dev.ftb.mods.ftbauxilium.FTBAuxilium;
import dev.ftb.mods.ftbauxilium.FTBAuxiliumConfig;
import dev.ftb.mods.ftbauxilium.auxilium.AnonymousIdentification;
import dev.ftb.mods.ftbauxilium.auxilium.ModpackData;
import dev.ftb.mods.ftbauxilium.auxilium.SessionCollector;
import dev.ftb.mods.ftbauxilium.tasks.LaunchTask;
import dev.ftb.mods.ftbauxilium.tasks.LevelExitTask;
import dev.ftb.mods.ftbauxilium.tasks.LevelLoadTask;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import org.jetbrains.annotations.Nullable;

public class StatManager {
    private static final AnonymousIdentification IDENTIFIER = new AnonymousIdentification();
    private final long instanceStartTime = System.currentTimeMillis();
    private float loadTimeInSeconds = 0.0f;
    private ModpackData packData;
    private String sessionToken = "";
    private SessionCollector session;
    private Launchers launcher = Launchers.UNKNOWN;

    public static AnonymousIdentification identifier() {
        return IDENTIFIER;
    }

    public void init() {
        FTBAuxilium.LOGGER.debug("Starting stat system");
        this.packData = new ModpackData();
        ClientLifecycleEvent.CLIENT_SETUP.register(this::clientLoaded);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(this::worldLoaded);
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(this::onLevelExit);
    }

    private void worldLoaded(@Nullable LocalPlayer localPlayer) {
        if (StatManager.identifier().isOptedOut() || !FTBAuxiliumConfig.isEnabled) {
            return;
        }
        Minecraft.m_91087_().execute(() -> FTBAuxilium.runTask(new LevelLoadTask()));
    }

    public void onLevelExit(@Nullable LocalPlayer localPlayer) {
        if (localPlayer == null || StatManager.identifier().isOptedOut() || !FTBAuxiliumConfig.isEnabled) {
            return;
        }
        Minecraft.m_91087_().execute(() -> FTBAuxilium.runTask(new LevelExitTask()));
    }

    public void clientLoaded(Minecraft minecraft) {
        if (StatManager.identifier().isOptedOut() || !FTBAuxiliumConfig.isEnabled) {
            return;
        }
        this.loadTimeInSeconds = (float)(System.currentTimeMillis() - this.instanceStartTime) / 1000.0f;
        this.launcher = this.findLauncher();
        FTBAuxilium.LOGGER.info("Launcher found: {}", (Object)this.launcher.getName());
        minecraft.execute(() -> FTBAuxilium.runTask(new LaunchTask(minecraft, this.launcher)));
    }

    private Launchers findLauncher() {
        File gameDirectory = Minecraft.m_91087_().f_91069_.getAbsoluteFile();
        for (Launchers value : Launchers.VALUES) {
            if (value == Launchers.UNKNOWN) continue;
            if (value.checker != null && value.checker.apply(AuxiliumExpectPlatform.getVersionArg().toLowerCase()).booleanValue()) {
                return value;
            }
            if (value.identifierPath.equals("") || !value.exists(gameDirectory)) continue;
            return value;
        }
        return Launchers.UNKNOWN;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public ModpackData getPackData() {
        return this.packData;
    }

    public float getLoadTimeInSeconds() {
        return this.loadTimeInSeconds;
    }

    public SessionCollector getSession() {
        return this.session;
    }

    public void setSession(SessionCollector session) {
        this.session = session;
    }

    public static enum Launchers {
        FTB(100, "FTB App", "/version.json"),
        CURSE(90, "Curse", "/.curseclient"),
        POLYMC(80, "PolyMC", version -> version.contains("polymc")),
        MULTI(75, "MultiMc", version -> version.contains("multimc")),
        GD(70, "GDLauncher", "/config.json"),
        ATLAUNCHER(60, "ATLancher", "/instance.png"),
        TLAUNCHER(50, "TLancher", "/../../tlauncher_libraries"),
        UNKNOWN(5, "unknown", "");

        final String name;
        final String identifierPath;
        final int priority;
        @Nullable
        final Function<String, Boolean> checker;
        public static final Launchers[] VALUES;

        private Launchers(int priority, String name, String identifierPath) {
            this.name = name;
            this.identifierPath = identifierPath;
            this.priority = priority;
            this.checker = null;
        }

        private Launchers(@Nullable int priority, String name, Function<String, Boolean> checker) {
            this.name = name;
            this.identifierPath = "";
            this.priority = priority;
            this.checker = checker;
        }

        public String getName() {
            return this.name;
        }

        public boolean exists(File minecraftDir) {
            return Files.exists(Paths.get(minecraftDir + this.identifierPath, new String[0]), new LinkOption[0]) || Files.isDirectory(Paths.get(minecraftDir + this.identifierPath, new String[0]), new LinkOption[0]);
        }

        public int getPriority() {
            return this.priority;
        }

        static {
            VALUES = (Launchers[])Arrays.stream(Launchers.values()).sorted(Comparator.comparing(Launchers::getPriority).reversed()).toArray(Launchers[]::new);
        }
    }
}

