/*
 * Decompiled with CFR 0.152.
 */
package net.manmaed.petslow.entity;

import java.util.UUID;
import net.manmaed.petslow.entity.PSEntityTypes;
import net.manmaed.petslow.items.PSItems;
import net.manmaed.petslow.sounds.PSSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class EntityPetSlow
extends TamableAnimal {
    private static final EntityDataAccessor<Integer> RETURN_COOLDOWN = SynchedEntityData.m_135353_(EntityPetSlow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STAY_COOLDOWN = SynchedEntityData.m_135353_(EntityPetSlow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> AWAY = SynchedEntityData.m_135353_(EntityPetSlow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TORCH_COUNT = SynchedEntityData.m_135353_(EntityPetSlow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int NOT_IN_USE = -1;

    protected EntityPetSlow(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.m_7105_(false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RETURN_COOLDOWN, (Object)-1);
        this.f_19804_.m_135372_(STAY_COOLDOWN, (Object)-1);
        this.f_19804_.m_135372_(AWAY, (Object)false);
        this.f_19804_.m_135372_(TORCH_COUNT, (Object)0);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("torchCount", this.getTorchCount());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("torchCount")) {
            this.setTorchCount(compoundTag.m_128451_("torchCount"));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public boolean isAway() {
        return (Boolean)this.f_19804_.m_135370_(AWAY);
    }

    private void setAway(boolean b) {
        this.f_19804_.m_135381_(AWAY, (Object)b);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        EntityPetSlow slowpoke = new EntityPetSlow((EntityType<? extends TamableAnimal>)((EntityType)PSEntityTypes.SLOWPOKE.get()), (Level)serverLevel);
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            slowpoke.m_21816_(uuid);
            slowpoke.m_7105_(true);
        }
        return slowpoke;
    }

    protected SoundEvent m_5508_() {
        return SoundEvents.f_12278_;
    }

    protected SoundEvent m_5509_() {
        return SoundEvents.f_12277_;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_12279_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return SoundEvents.f_12323_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)PSSounds.SLOW_DEATH.get();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || item == PSItems.SLOW_BREW.get() && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (item == PSItems.CLAY_BREW.get() && this.m_21223_() < this.m_21233_()) {
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                    player.m_150109_().m_36054_(new ItemStack((ItemLike)PSItems.MUG.get()));
                }
                this.m_5496_(SoundEvents.f_11911_, this.m_6121_(), 1.0f);
                if (this.f_19796_.m_188503_(25) == 0) {
                    this.m_5496_(SoundEvents.f_12321_, this.m_6121_(), 1.0f);
                }
                this.m_5634_(3.0f);
                return InteractionResult.SUCCESS;
            }
            if (item == Items.f_42000_) {
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                int tc = 0;
                tc = this.getTorchCount();
                this.setTorchCount(++tc);
                this.m_5496_(SoundEvents.f_11912_, this.m_6121_(), 1.0f);
                if (this.f_19796_.m_188503_(25) == 0) {
                    this.m_5496_(SoundEvents.f_12321_, this.m_6121_(), 1.0f);
                }
                return InteractionResult.CONSUME;
            }
            if (!(item instanceof DyeItem)) {
                InteractionResult interactionresult = super.m_6071_(player, hand);
                if ((!interactionresult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player)) {
                    this.m_21839_(!this.m_21827_());
                    this.f_20899_ = false;
                    this.f_21344_.m_26573_();
                    return InteractionResult.SUCCESS;
                }
                return interactionresult;
            }
        } else if (item == PSItems.SLOW_BREW.get()) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_21839_(true);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
                this.m_5496_((SoundEvent)PSSounds.SLOW_TAME.get(), this.m_6121_(), 1.0f);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            this.m_5496_(SoundEvents.f_11911_, this.m_6121_(), 1.0f);
            if (this.f_19796_.m_188503_(25) == 0) {
                this.m_5496_(SoundEvents.f_12321_, this.m_6121_(), 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void addtorch(Level world, BlockPos pos) {
        int torch = 0;
        if (!world.f_46443_ && this.m_21824_() && !this.m_21827_() && world.m_5518_().m_75831_(pos.m_7494_(), 0) < 3 && Blocks.f_50016_.m_49966_() != world.m_8055_(pos.m_7495_()) && this.getTorchCount() >= 1) {
            torch = this.getTorchCount();
            this.setTorchCount(--torch);
            world.m_46597_(pos.m_7494_(), Blocks.f_50081_.m_49966_());
            this.m_5496_(SoundEvents.f_12210_, this.m_6121_(), 0.01f);
        }
    }

    private void shouldafk(Level world) {
        if (!world.f_46443_ && this.m_21824_() && this.m_21827_()) {
            int bool;
            if ((Integer)this.f_19804_.m_135370_(STAY_COOLDOWN) == 0 && (Integer)this.f_19804_.m_135370_(RETURN_COOLDOWN) == -1) {
                bool = this.f_19853_.f_46441_.m_188503_(2500) + 100;
                this.f_19804_.m_135381_(STAY_COOLDOWN, (Object)-1);
                this.f_19804_.m_135381_(RETURN_COOLDOWN, (Object)bool);
                this.setAway(false);
            }
            if ((Integer)this.f_19804_.m_135370_(RETURN_COOLDOWN) == 0 && (Integer)this.f_19804_.m_135370_(STAY_COOLDOWN) == -1) {
                bool = this.f_19853_.f_46441_.m_188503_(25000) + 1000;
                this.f_19804_.m_135381_(RETURN_COOLDOWN, (Object)-1);
                this.f_19804_.m_135381_(STAY_COOLDOWN, (Object)bool);
                this.setAway(true);
            }
        }
    }

    private void countdown(Level world) {
        if (this.m_21824_() && this.m_21827_() && !world.f_46443_) {
            if ((Integer)this.f_19804_.m_135370_(STAY_COOLDOWN) != -1) {
                int sc = (Integer)this.f_19804_.m_135370_(STAY_COOLDOWN);
                int nsc = --sc;
                this.f_19804_.m_135381_(STAY_COOLDOWN, (Object)nsc);
            } else if ((Integer)this.f_19804_.m_135370_(RETURN_COOLDOWN) != -1) {
                int rc = (Integer)this.f_19804_.m_135370_(RETURN_COOLDOWN);
                int nrc = --rc;
                this.f_19804_.m_135381_(RETURN_COOLDOWN, (Object)nrc);
            }
        }
    }

    private void chooseafk(Level world) {
        if (!world.f_46443_ && (Integer)this.f_19804_.m_135370_(STAY_COOLDOWN) == -1 && (Integer)this.f_19804_.m_135370_(RETURN_COOLDOWN) == -1) {
            boolean tobeornottobe = world.f_46441_.m_188499_();
            if (tobeornottobe) {
                this.f_19804_.m_135381_(RETURN_COOLDOWN, (Object)(this.f_19853_.f_46441_.m_188503_(100) + 100));
                this.f_19804_.m_135381_(STAY_COOLDOWN, (Object)-1);
                this.setAway(false);
            } else {
                this.f_19804_.m_135381_(STAY_COOLDOWN, (Object)(this.f_19853_.f_46441_.m_188503_(2500) + 500));
                this.f_19804_.m_135381_(RETURN_COOLDOWN, (Object)-1);
                this.setAway(true);
            }
        }
    }

    public int getTorchCount() {
        return (Integer)this.f_19804_.m_135370_(TORCH_COUNT);
    }

    public void setTorchCount(int amount) {
        this.f_19804_.m_135381_(TORCH_COUNT, (Object)amount);
    }

    public void m_8119_() {
        super.m_8119_();
        this.addtorch(this.f_19853_, this.m_20097_());
        this.isAway();
        this.chooseafk(this.f_19853_);
        this.shouldafk(this.f_19853_);
        this.countdown(this.f_19853_);
    }
}

