/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.world;

import com.lothrazar.cyclic.world.WorldGenPlacements;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BiomeTweaker {
    private static final String MODIFY_BIOMES = "modify_biomes";
    private static final ResourceLocation MODIFY_BIOMES_RL = new ResourceLocation("cyclic", "modify_biomes");

    public static void init(IEventBus bus) {
        DeferredRegister serializers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"cyclic");
        serializers.register(bus);
        serializers.register(MODIFY_BIOMES, TestModifier::makeCodec);
        bus.addListener(BiomeTweaker::onGatherData);
    }

    private static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)RegistryAccess.m_206197_());
        generator.m_236039_(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"cyclic", (RegistryOps)ops, (ResourceKey)Registry.f_194567_, Map.of(new ResourceLocation("cyclic", "cyan"), (PlacedFeature)WorldGenPlacements.PF_FLOWER_CYAN.get())));
        generator.m_236039_(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"cyclic", (RegistryOps)ops, (ResourceKey)Registry.f_194567_, Map.of(new ResourceLocation("cyclic", "lime"), (PlacedFeature)WorldGenPlacements.PF_FLOWER_LIME.get())));
        generator.m_236039_(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"cyclic", (RegistryOps)ops, (ResourceKey)Registry.f_194567_, Map.of(new ResourceLocation("cyclic", "tulip"), (PlacedFeature)WorldGenPlacements.PF_FLOWER_TULIP.get())));
    }

    public record TestModifier(HolderSet<Biome> biomes, Biome.Precipitation precipitation, int waterColor) implements BiomeModifier
    {
        private static final RegistryObject<Codec<? extends BiomeModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)MODIFY_BIOMES_RL, (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"cyclic");

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.MODIFY && this.biomes.m_203333_(biome)) {
                BiomeGenerationSettingsBuilder generation = builder.getGenerationSettings();
                GenerationStep.Decoration step = GenerationStep.Decoration.VEGETAL_DECORATION;
                generation.m_204201_(step, WorldGenPlacements.PF_FLOWER_CYAN);
                generation.m_204201_(step, WorldGenPlacements.PF_FLOWER_LIME);
                generation.m_204201_(step, WorldGenPlacements.PF_FLOWER_TULIP);
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return (Codec)SERIALIZER.get();
        }

        private static Codec<TestModifier> makeCodec() {
            return RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(TestModifier::biomes), (App)Biome.Precipitation.f_47717_.fieldOf("precipitation").forGetter(TestModifier::precipitation), (App)Codec.INT.fieldOf("water_color").forGetter(TestModifier::waterColor)).apply((Applicative)builder, TestModifier::new));
        }
    }
}

