/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.transporter;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.ChatUtil;
import com.lothrazar.cyclic.util.ItemStackUtil;
import com.lothrazar.cyclic.util.SoundUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class TileTransporterItem
extends ItemBaseCyclic {
    public static final String KEY_BLOCKID = "block";
    public static final String KEY_BLOCKTILE = "tile";
    public static final String KEY_BLOCKNAME = "blockname";
    public static final String KEY_BLOCKSTATE = "blockstate";

    public TileTransporterItem(Item.Properties prop) {
        super(prop);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos offset;
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        Level world = context.m_43725_();
        if (!world.m_46859_(offset = pos.m_121945_(side))) {
            return InteractionResult.FAIL;
        }
        if (this.placeStoredTileEntity(player, stack, offset)) {
            player.m_21008_(context.m_43724_(), ItemStack.f_41583_);
            SoundUtil.playSound((Entity)player, (SoundEvent)SoundRegistry.THUNK.get());
            if (!player.m_7500_()) {
                ItemStackUtil.drop(world, player.m_20183_(), new ItemStack((ItemLike)ItemRegistry.TILE_TRANSPORTER_EMPTY.get()));
            }
        }
        return InteractionResult.SUCCESS;
    }

    private boolean placeStoredTileEntity(Player player, ItemStack heldChestSack, BlockPos pos) {
        CompoundTag itemData = heldChestSack.m_41784_();
        ResourceLocation res = new ResourceLocation(itemData.m_128461_(KEY_BLOCKID));
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(res);
        if (block == null) {
            heldChestSack = ItemStack.f_41583_;
            ChatUtil.addChatMessage(player, "Invalid block id " + res);
            return false;
        }
        BlockState toPlace = NbtUtils.m_129241_((CompoundTag)itemData.m_128469_(KEY_BLOCKSTATE));
        Level world = player.m_20193_();
        try {
            world.m_46597_(pos, toPlace);
            BlockEntity tile = world.m_7702_(pos);
            if (tile != null) {
                CompoundTag tileData = itemData.m_128469_(KEY_BLOCKTILE);
                tileData.m_128405_("x", pos.m_123341_());
                tileData.m_128405_("y", pos.m_123342_());
                tileData.m_128405_("z", pos.m_123343_());
                tile.m_142466_(tileData);
                tile.m_6596_();
                world.m_151543_(pos);
            }
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("Error attempting to place block in world", e);
            ChatUtil.sendStatusMessage(player, "chest_sack.error.place");
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            return false;
        }
        heldChestSack = ItemStack.f_41583_;
        heldChestSack.m_41751_(null);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, Level worldIn, List<Component> list, TooltipFlag flagIn) {
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_(KEY_BLOCKNAME)) {
            String blockname = itemStack.m_41783_().m_128461_(KEY_BLOCKNAME);
            if (blockname != null && blockname.length() > 0) {
                MutableComponent t = Component.m_237115_((String)ChatUtil.lang(blockname));
                t.m_130940_(ChatFormatting.DARK_GREEN);
                list.add((Component)t);
            }
        } else {
            MutableComponent t = Component.m_237115_((String)ChatUtil.lang("invalid"));
            t.m_130940_(ChatFormatting.DARK_RED);
            list.add((Component)t);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return stack.m_41782_();
    }
}

