/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.storagebag;

import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.cyclic.item.storagebag.DepositMode;
import com.lothrazar.cyclic.item.storagebag.PickupMode;
import com.lothrazar.cyclic.item.storagebag.RefillMode;
import com.lothrazar.cyclic.item.storagebag.ScreenStorageBag;
import com.lothrazar.cyclic.item.storagebag.StorageBagCapability;
import com.lothrazar.cyclic.item.storagebag.StorageBagContainerProvider;
import com.lothrazar.cyclic.registry.MenuTypeRegistry;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.SoundUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class ItemStorageBag
extends ItemBaseCyclic {
    private static final String NBT_COLOUR = "COLOUR";
    public static final int REFILL_TICKS = 4;
    public static final int SLOTS = 81;
    public int timer = 0;

    public ItemStorageBag(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!worldIn.f_46443_ && !playerIn.m_6047_()) {
            int slot = handIn == InteractionHand.MAIN_HAND ? playerIn.m_150109_().f_35977_ : 40;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)new StorageBagContainerProvider(slot), buf -> buf.writeInt(slot));
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public static void setColour(ItemStack stack, DyeColor col) {
        CompoundTag tags = stack.m_41784_();
        tags.m_128405_(NBT_COLOUR, col.m_41071_());
    }

    public static int getColour(ItemStack stack) {
        CompoundTag tags = stack.m_41784_();
        if (!tags.m_128441_(NBT_COLOUR)) {
            return DyeColor.BROWN.m_41071_();
        }
        return tags.m_128451_(NBT_COLOUR);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Direction face = context.m_43719_();
        Level world = context.m_43725_();
        BlockEntity te = world.m_7702_(pos);
        ItemStack bag = context.m_43722_();
        DepositMode mode = ItemStorageBag.getDepositMode(bag);
        if (mode == DepositMode.NOTHING) {
            return InteractionResult.PASS;
        }
        ItemStackHandler handler = ItemStorageBag.getInventory(bag);
        if (handler != null && te != null && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face).isPresent()) {
            IItemHandler teHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face).orElse(null);
            HashSet<Item> itemsInTargetInventory = new HashSet<Item>();
            if (teHandler != null) {
                for (int j = 0; j < teHandler.getSlots(); ++j) {
                    itemsInTargetInventory.add(teHandler.getStackInSlot(j).m_41720_());
                }
            }
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                ItemStack remaining = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)stack.m_41613_());
                if (stack.m_41619_() || mode != DepositMode.DUMP && (mode != DepositMode.MERGE || !itemsInTargetInventory.contains(stack.m_41720_()))) continue;
                remaining = ItemHandlerHelper.insertItem((IItemHandler)teHandler, (ItemStack)stack, (boolean)false);
                handler.setStackInSlot(i, remaining);
            }
            SoundUtil.playSound((Entity)context.m_43723_(), (SoundEvent)SoundRegistry.BASEY.get());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        CompoundTag nbt = stack.m_41784_();
        String pickupMode = nbt.m_128461_("pickup_mode");
        String depositMode = nbt.m_128461_("deposit_mode");
        String refillMode = nbt.m_128461_("refill_mode");
        if (!pickupMode.equals("")) {
            tooltip.add((Component)Component.m_237110_((String)"item.cyclic.storage_bag.tooltip.pickup", (Object[])new Object[]{Component.m_237115_((String)String.format(pickupMode.equals("nothing") ? "item.cyclic.storage_bag.disabled" : "item.cyclic.storage_bag.pickup.%s", pickupMode))}).m_130940_(ChatFormatting.GREEN));
        }
        if (!depositMode.equals("")) {
            tooltip.add((Component)Component.m_237110_((String)"item.cyclic.storage_bag.tooltip.deposit", (Object[])new Object[]{Component.m_237115_((String)String.format(depositMode.equals("nothing") ? "item.cyclic.storage_bag.disabled" : "item.cyclic.storage_bag.deposit.%s", depositMode))}).m_130940_(ChatFormatting.BLUE));
        }
        if (!refillMode.equals("")) {
            tooltip.add((Component)Component.m_237110_((String)"item.cyclic.storage_bag.tooltip.refill", (Object[])new Object[]{Component.m_237115_((String)String.format(refillMode.equals("nothing") ? "item.cyclic.storage_bag.disabled" : "item.cyclic.storage_bag.refill.%s", refillMode))}).m_130940_(ChatFormatting.RED));
        }
    }

    @Override
    public void registerClient() {
        MenuScreens.m_96206_((MenuType)((MenuType)MenuTypeRegistry.STORAGE_BAG.get()), ScreenStorageBag::new);
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new StorageBagCapability(stack, nbt);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        ++this.timer;
        if (this.timer < 4) {
            return;
        }
        this.timer = 0;
        if (!world.f_46443_ && entity instanceof Player && ItemStorageBag.getRefillMode(stack) == RefillMode.HOTBAR) {
            this.tryRefillHotbar(stack, (Player)entity);
        }
    }

    private void tryRefillHotbar(ItemStack bag, Player player) {
        ItemStackHandler handler = ItemStorageBag.getInventory(bag);
        if (handler == null) {
            return;
        }
        for (int i = 0; i < Math.min(9, player.m_150109_().m_6643_()); ++i) {
            boolean success;
            int slot;
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || (slot = ItemStorageBag.getLastSlotWithStack(bag, stack)) == -1 || !(success = this.refillHotbar(bag, player, slot, i))) continue;
            handler.extractItem(slot, 1, false);
            return;
        }
    }

    private boolean refillHotbar(ItemStack bag, Player player, int bagSlot, int invSlot) {
        ItemStackHandler handler = ItemStorageBag.getInventory(bag);
        boolean success = false;
        if (handler != null) {
            ItemStack extracted = handler.extractItem(bagSlot, 1, true);
            success = player.m_150109_().m_36040_(invSlot, extracted);
        }
        return success;
    }

    private static ItemStackHandler getInventory(ItemStack bag) {
        if (bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
            return (ItemStackHandler)bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().get();
        }
        return null;
    }

    public static ItemStack tryInsert(ItemStack bag, ItemStack stack) {
        AtomicReference<ItemStack> returnStack = new AtomicReference<ItemStack>(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)stack.m_41613_()));
        bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> returnStack.set(ItemHandlerHelper.insertItem((IItemHandler)h, (ItemStack)stack, (boolean)false)));
        return returnStack.get();
    }

    public static ItemStack tryFilteredInsert(ItemStack bag, ItemStack stack) {
        if (bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent() && ItemStorageBag.bagHasItem(bag, stack)) {
            return ItemStorageBag.tryInsert(bag, stack);
        }
        return stack;
    }

    private static boolean bagHasItem(ItemStack bag, ItemStack stack) {
        AtomicBoolean hasItem = new AtomicBoolean(false);
        bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
            for (int i = 0; i < h.getSlots(); ++i) {
                if (h.getStackInSlot(i).m_41720_() != stack.m_41720_()) continue;
                hasItem.set(true);
            }
        });
        return hasItem.get();
    }

    public static int getFirstSlotWithStack(ItemStack bag, ItemStack stack) {
        AtomicInteger slot = new AtomicInteger(-1);
        bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
            for (int i = 0; i < h.getSlots(); ++i) {
                if (h.getStackInSlot(i).m_41720_() != stack.m_41720_()) continue;
                slot.set(i);
            }
        });
        return slot.get();
    }

    private static int getLastSlotWithStack(ItemStack bag, ItemStack stack) {
        AtomicInteger slot = new AtomicInteger(-1);
        bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
            for (int i = h.getSlots() - 1; i >= 0; --i) {
                if (h.getStackInSlot(i).m_41720_() != stack.m_41720_()) continue;
                slot.set(i);
            }
        });
        return slot.get();
    }

    public static PickupMode getPickupMode(ItemStack stack) {
        String mode = stack.m_41784_().m_128461_("pickup_mode");
        for (int i = 0; i < PickupMode.values().length; ++i) {
            if (!mode.equals(PickupMode.values()[i].m_7912_())) continue;
            return PickupMode.values()[i];
        }
        return PickupMode.NOTHING;
    }

    private static DepositMode getDepositMode(ItemStack stack) {
        String mode = stack.m_41784_().m_128461_("deposit_mode");
        for (int i = 0; i < DepositMode.values().length; ++i) {
            if (!mode.equals(DepositMode.values()[i].m_7912_())) continue;
            return DepositMode.values()[i];
        }
        return DepositMode.NOTHING;
    }

    private static RefillMode getRefillMode(ItemStack stack) {
        String mode = stack.m_41784_().m_7916_();
        for (int i = 0; i < RefillMode.values().length; ++i) {
            if (!mode.equals(RefillMode.values()[i].m_7912_())) continue;
            return RefillMode.values()[i];
        }
        return RefillMode.NOTHING;
    }

    public static List<Integer> getAllBagSlots(Player player) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            if (!ItemStorageBag.isBag(player.m_150109_().m_8020_(i))) continue;
            slots.add(i);
        }
        return slots;
    }

    public static int getFirstBagSlot(Player player) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            if (!ItemStorageBag.isBag(player.m_150109_().m_8020_(i))) continue;
            return i;
        }
        return -1;
    }

    private static boolean isBag(ItemStack stack) {
        return stack.m_41720_() instanceof ItemStorageBag;
    }

    public static void setTimestamp(ItemStack myBag) {
        if (myBag.m_41619_()) {
            return;
        }
        myBag.m_41784_().m_128356_("ts", System.currentTimeMillis());
    }
}

