/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.rf;

import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.cyclic.util.ChatUtil;
import com.lothrazar.cyclic.util.ParticleUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class WandHypnoItem
extends ItemBaseCyclic {
    public static ForgeConfigSpec.IntValue COST;
    public static ForgeConfigSpec.IntValue RANGE;

    public WandHypnoItem(Item.Properties properties) {
        super(properties.m_41487_(1));
        this.setUsesEnergy();
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        this.doAction(itemstack, worldIn, playerIn);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    private void doAction(ItemStack stack, Level world, Player player) {
        if (!player.f_19853_.f_46443_) {
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
            int cost = (Integer)COST.get();
            if (storage != null && storage.extractEnergy(cost, true) == cost) {
                storage.extractEnergy(cost, false);
                this.fireHypnoAggression(world, player);
            }
        }
    }

    private void fireHypnoAggression(Level world, Player player) {
        BlockPos p = player.m_20183_();
        int r = (Integer)RANGE.get();
        List all = world.m_45976_(Mob.class, new AABB((double)(p.m_123341_() - r), (double)(p.m_123342_() - r), (double)(p.m_123343_() - r), (double)(p.m_123341_() + r), (double)(p.m_123342_() + r), (double)(p.m_123343_() + r)));
        ArrayList<Mob> trimmedTargets = new ArrayList<Mob>();
        for (Mob target : all) {
            MobCategory type = target.getClassification(false);
            if (target.m_20148_().compareTo(player.m_20148_()) == 0 || type.m_21609_()) continue;
            trimmedTargets.add(target);
        }
        int targeted = 0;
        for (int i = 0; i < trimmedTargets.size(); ++i) {
            Mob cur = (Mob)trimmedTargets.get(i);
            cur.m_6710_(null);
            int j = world.f_46441_.m_188503_(trimmedTargets.size());
            if (j == i) continue;
            Mob curTarget = (Mob)trimmedTargets.get(j);
            cur.m_21335_((Entity)curTarget);
            cur.m_6710_((LivingEntity)curTarget);
            ParticleUtil.spawnParticle(world, (ParticleOptions)ParticleTypes.f_123799_, cur.m_20183_(), 15);
            ++targeted;
        }
        if (targeted == 0) {
            ChatUtil.sendStatusMessage(player, "wand.result.notargets");
        } else {
            player.m_36335_().m_41524_((Item)this, 60);
        }
    }
}

