/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.equipment;

import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.util.ShapeUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public class MattockItem
extends DiggerItem {
    final int radius;

    public MattockItem(Tiers tr, Item.Properties builder, int radius) {
        super(5.0f, -3.0f, (Tier)tr, DataTags.WITH_MATTOCK, builder);
        this.radius = radius;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        Level world = player.f_19853_;
        BlockHitResult ray = MattockItem.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        int yoff = 0;
        if (this.radius == 2 && player.m_6047_()) {
            yoff = 1;
        }
        if (ray != null && ray.m_6662_() == HitResult.Type.BLOCK) {
            List<BlockPos> shape;
            BlockHitResult brt = ray;
            Direction sideHit = brt.m_82434_();
            if (sideHit == Direction.UP || sideHit == Direction.DOWN) {
                shape = ShapeUtil.squareHorizontalHollow(pos, this.radius);
                if (this.radius == 2) {
                    shape.addAll(ShapeUtil.squareHorizontalHollow(pos, this.radius - 1));
                }
            } else if (sideHit == Direction.EAST || sideHit == Direction.WEST) {
                int y = 1 + this.radius - yoff;
                int z = this.radius;
                shape = ShapeUtil.squareVerticalZ(pos, y, z);
            } else {
                int x = this.radius;
                int y = 1 + this.radius - yoff;
                shape = ShapeUtil.squareVerticalX(pos, x, y);
            }
            for (BlockPos posCurrent : shape) {
                BlockState bsCurrent = world.m_8055_(posCurrent);
                if (bsCurrent.m_60795_() || !(bsCurrent.f_60599_ >= 0.0f) || !player.m_36204_(posCurrent, sideHit, stack) || !ForgeEventFactory.doPlayerHarvestCheck((Player)player, (BlockState)bsCurrent, (boolean)true) || !(this.m_8102_(stack, bsCurrent) > 1.0f) || !bsCurrent.canHarvestBlock((BlockGetter)world, pos, player) && !bsCurrent.m_204336_(this.m_43314_().getTag())) continue;
                stack.m_41686_(world, bsCurrent, posCurrent, player);
                Block blockCurrent = bsCurrent.m_60734_();
                if (world.f_46443_) {
                    world.m_46796_(2001, posCurrent, Block.m_49956_((BlockState)bsCurrent));
                    if (!blockCurrent.onDestroyedByPlayer(bsCurrent, world, posCurrent, player, true, bsCurrent.m_60819_())) continue;
                    blockCurrent.m_6786_((LevelAccessor)world, posCurrent, bsCurrent);
                    continue;
                }
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer mp = (ServerPlayer)player;
                int xpGivenOnDrop = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)((ServerPlayer)player).f_8941_.m_9290_(), (ServerPlayer)((ServerPlayer)player), (BlockPos)posCurrent);
                if (xpGivenOnDrop < 0) continue;
                if (blockCurrent.onDestroyedByPlayer(bsCurrent, world, posCurrent, player, true, bsCurrent.m_60819_()) && world instanceof ServerLevel) {
                    BlockEntity tile = world.m_7702_(posCurrent);
                    blockCurrent.m_6786_((LevelAccessor)world, posCurrent, bsCurrent);
                    blockCurrent.m_6240_(world, player, posCurrent, bsCurrent, tile, stack);
                    blockCurrent.m_49805_((ServerLevel)world, posCurrent, xpGivenOnDrop);
                }
                mp.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)world, posCurrent));
            }
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (this.m_43314_() == Tiers.STONE) {
            return Math.max(Items.f_42427_.m_8102_(stack, state), Items.f_42426_.m_8102_(stack, state));
        }
        return Math.max(Items.f_42390_.m_8102_(stack, state), Items.f_42389_.m_8102_(stack, state));
    }
}

