/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.datacard.filter;

import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.cyclic.item.datacard.filter.CapabilityProviderFilterCard;
import com.lothrazar.cyclic.item.datacard.filter.ContainerProviderFilterCard;
import com.lothrazar.cyclic.item.datacard.filter.ScreenFilterCard;
import com.lothrazar.cyclic.registry.MenuTypeRegistry;
import com.lothrazar.cyclic.util.ItemStackUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public class FilterCardItem
extends ItemBaseCyclic {
    public static final int SLOT_FLUID = 8;
    private static final String NBTFILTER = "filter";

    public FilterCardItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            int itemCount;
            boolean isIgnore = FilterCardItem.getIsIgnoreList(stack);
            MutableComponent t = Component.m_237115_((String)("cyclic.screen.filter." + isIgnore));
            t.m_130940_(isIgnore ? ChatFormatting.DARK_GRAY : ChatFormatting.DARK_BLUE);
            tooltip.add((Component)t);
            CompoundTag stackTag = stack.m_41784_();
            if (stackTag.m_128441_("fluidTooltip")) {
                String fluidTooltip = stackTag.m_128461_("fluidTooltip");
                tooltip.add((Component)Component.m_237115_((String)fluidTooltip).m_130940_(ChatFormatting.AQUA));
            }
            if (stackTag.m_128441_("itemCount") && (itemCount = stackTag.m_128451_("itemCount")) > 0) {
                if (stackTag.m_128441_("itemTooltip")) {
                    String itemTooltip = stackTag.m_128461_("itemTooltip");
                    tooltip.add((Component)Component.m_237115_((String)itemTooltip).m_130940_(ChatFormatting.GRAY));
                }
                tooltip.add((Component)Component.m_237115_((String)"cyclic.screen.filter.item.count").m_130946_("" + itemCount).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            super.m_7373_(stack, worldIn, tooltip, flagIn);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!worldIn.f_46443_ && !playerIn.m_6047_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)new ContainerProviderFilterCard(), (BlockPos)playerIn.m_20183_());
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new CapabilityProviderFilterCard();
    }

    @Override
    public void registerClient() {
        MenuScreens.m_96206_((MenuType)((MenuType)MenuTypeRegistry.FILTER_DATA.get()), ScreenFilterCard::new);
    }

    public static void toggleFilterType(ItemStack filter) {
        boolean prev = FilterCardItem.getIsIgnoreList(filter);
        filter.m_41783_().m_128379_(NBTFILTER, !prev);
    }

    public static FluidStack getFluidStack(ItemStack filterStack) {
        ItemStack bucket;
        IFluidHandler fluidInStack;
        if (!(filterStack.m_41720_() instanceof FilterCardItem)) {
            return FluidStack.EMPTY;
        }
        IItemHandler myFilter = (IItemHandler)filterStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (myFilter != null && (fluidInStack = (IFluidHandler)(bucket = myFilter.getStackInSlot(8)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).orElse(null)) != null && fluidInStack.getFluidInTank(0) != null) {
            return fluidInStack.getFluidInTank(0);
        }
        return FluidStack.EMPTY;
    }

    public static boolean filterAllowsExtract(ItemStack filterStack, ItemStack itemTarget) {
        if (!(filterStack.m_41720_() instanceof FilterCardItem)) {
            return true;
        }
        boolean isEmpty = false;
        boolean isMatchingList = false;
        boolean isIgnoreList = FilterCardItem.getIsIgnoreList(filterStack);
        IItemHandler myFilter = (IItemHandler)filterStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (myFilter != null) {
            for (int i = 0; i < myFilter.getSlots(); ++i) {
                ItemStack filterPtr = myFilter.getStackInSlot(i);
                if (filterPtr.m_41619_()) continue;
                isEmpty = false;
                if (!ItemStackUtil.matches(itemTarget, filterPtr)) continue;
                isMatchingList = true;
                break;
            }
        }
        if (isIgnoreList) {
            return !isMatchingList;
        }
        return isEmpty || isMatchingList;
    }

    private static boolean getIsIgnoreList(ItemStack filterStack) {
        return filterStack.m_41784_().m_128471_(NBTFILTER);
    }

    public static boolean filterAllowsExtract(ItemStack filterStack, FluidStack fluidInTank) {
        if (!(filterStack.m_41720_() instanceof FilterCardItem)) {
            return true;
        }
        FluidStack fluidFilter = FilterCardItem.getFluidStack(filterStack);
        boolean isMatchingList = fluidFilter.getFluid() == fluidInTank.getFluid();
        boolean isIgnoreList = FilterCardItem.getIsIgnoreList(filterStack);
        if (isIgnoreList) {
            return !isMatchingList;
        }
        return fluidFilter.isEmpty() || isMatchingList;
    }

    @Override
    public CompoundTag getShareTag(ItemStack stack) {
        IItemHandler cap;
        CompoundTag nbt = stack.m_41784_();
        FluidStack fluidStack = FilterCardItem.getFluidStack(stack);
        if (!fluidStack.isEmpty()) {
            nbt.m_128359_("fluidTooltip", fluidStack.getDisplayName().getString());
        }
        if ((cap = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null)) != null) {
            int count = 0;
            Component first = null;
            for (int i = 0; i < cap.getSlots(); ++i) {
                if (cap.getStackInSlot(i).m_41619_()) continue;
                ++count;
                if (first != null) continue;
                first = cap.getStackInSlot(i).m_41786_();
            }
            nbt.m_128405_("itemCount", count);
            if (first != null) {
                nbt.m_128359_("itemTooltip", first.getString());
            }
        }
        return nbt;
    }

    @Override
    public void readShareTag(ItemStack stack, CompoundTag nbt) {
        if (nbt != null) {
            CompoundTag stackTag = stack.m_41784_();
            stackTag.m_128359_("itemTooltip", nbt.m_128461_("itemTooltip"));
            stackTag.m_128359_("fluidTooltip", nbt.m_128461_("fluidTooltip"));
            stackTag.m_128405_("itemCount", nbt.m_128451_("itemCount"));
        }
        super.readShareTag(stack, nbt);
    }
}

