/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item;

import com.lothrazar.cyclic.capabilities.item.CapabilityProviderEnergyStack;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.util.ItemStackUtil;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemBaseCyclic
extends Item {
    private static final int MAX_ENERGY = 16000;
    public static final String ENERGYTTMAX = "energyttmax";
    public static final String ENERGYTT = "energytt";
    public static final float INACCURACY_DEFAULT = 1.0f;
    public static final float VELOCITY_MAX = 1.5f;
    private boolean hasEnergy;

    public ItemBaseCyclic(Item.Properties properties) {
        super(properties);
        ItemRegistry.ITEMSFIXME.add(this);
    }

    public void setUsesEnergy() {
        this.hasEnergy = true;
    }

    protected void shootMe(Level world, Player shooter, Projectile ball, float pitch, float velocityFactor) {
        if (world.f_46443_) {
            return;
        }
        Vec3 vector3d1 = shooter.m_20289_(1.0f);
        Quaternion quaternion = new Quaternion(new Vector3f(vector3d1), pitch, true);
        Vec3 vector3d = shooter.m_20252_(1.0f);
        Vector3f vector3f = new Vector3f(vector3d);
        vector3f.m_122251_(quaternion);
        ball.m_6686_((double)vector3f.m_122239_(), (double)vector3f.m_122260_(), (double)vector3f.m_122269_(), velocityFactor * 1.5f, 1.0f);
        world.m_7967_((Entity)ball);
    }

    protected ItemStack findAmmo(Player player, Item item) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack = player.m_150109_().m_8020_(i);
            if (itemstack.m_41720_() != item) continue;
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public void tryRepairWith(ItemStack stackToRepair, Player player, Item target) {
        ItemStack torches;
        if (stackToRepair.m_41768_() && !(torches = this.findAmmo(player, target)).m_41619_()) {
            torches.m_41774_(1);
            ItemStackUtil.repairItem(stackToRepair);
        }
    }

    public float getChargedPercent(ItemStack stack, int chargeTimer) {
        return BowItem.m_40661_((int)(this.m_8105_(stack) - chargeTimer));
    }

    public Rarity m_41460_(ItemStack stack) {
        if (this.hasEnergy) {
            return Rarity.EPIC;
        }
        return super.m_41460_(stack);
    }

    public int m_142159_(ItemStack stack) {
        if (this.hasEnergy) {
            return 12192009;
        }
        return super.m_142159_(stack);
    }

    public boolean m_142522_(ItemStack stack) {
        if (this.hasEnergy) {
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
            return storage != null;
        }
        return super.m_142522_(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip")).m_130940_(ChatFormatting.GRAY));
        if (this.hasEnergy) {
            int current = 0;
            int energyttmax = 0;
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
            if (storage != null) {
                current = storage.getEnergyStored();
                energyttmax = storage.getMaxEnergyStored();
                tooltip.add((Component)Component.m_237115_((String)(current + "/" + energyttmax)).m_130940_(ChatFormatting.RED));
            }
        }
    }

    public int m_142158_(ItemStack stack) {
        if (this.hasEnergy) {
            float current = 0.0f;
            float max = 0.0f;
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
            if (storage != null) {
                current = storage.getEnergyStored();
                max = storage.getMaxEnergyStored();
            }
            return max == 0.0f ? 0 : Math.round(13.0f * current / max);
        }
        return super.m_142158_(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient() {
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        if (this.hasEnergy) {
            return new CapabilityProviderEnergyStack(16000);
        }
        return super.initCapabilities(stack, nbt);
    }

    public CompoundTag getShareTag(ItemStack stack) {
        if (this.hasEnergy) {
            CompoundTag nbt = stack.m_41784_();
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
            if (storage != null) {
                nbt.m_128405_(ENERGYTT, storage.getEnergyStored());
                nbt.m_128405_(ENERGYTTMAX, storage.getMaxEnergyStored());
            }
            return nbt;
        }
        return super.getShareTag(stack);
    }

    public void readShareTag(ItemStack stack, CompoundTag nbt) {
        if (this.hasEnergy && nbt != null) {
            CompoundTag stackTag = stack.m_41784_();
            stackTag.m_128405_(ENERGYTT, nbt.m_128451_(ENERGYTT));
            stackTag.m_128405_(ENERGYTTMAX, nbt.m_128451_(ENERGYTTMAX));
        }
        super.readShareTag(stack, nbt);
    }
}

