/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.enchant.EnchantmentCyclic;
import com.lothrazar.cyclic.registry.EnchantRegistry;
import com.lothrazar.cyclic.util.ItemStackUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ExcavationEnchant
extends EnchantmentCyclic {
    public static final String ID = "excavate";
    public static ForgeConfigSpec.BooleanValue CFG;
    private static final Direction[] VALUES;

    public ExcavationEnchant(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public boolean m_6594_() {
        return this.isEnabled() && super.m_6594_();
    }

    public boolean m_6592_() {
        return this.isEnabled() && super.m_6592_();
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled() && super.isAllowedOnBooks();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.isEnabled() && super.canApplyAtEnchantingTable(stack);
    }

    public int m_6586_() {
        return 5;
    }

    public boolean m_6081_(ItemStack stack) {
        return this.isEnabled() && (super.m_6081_(stack) || stack.m_204117_(Tags.Items.SHEARS));
    }

    public boolean m_5975_(Enchantment ench) {
        return super.m_5975_(ench) && ench != EnchantRegistry.EXPERIENCE_BOOST.get();
    }

    private int getHarvestMax(int level) {
        return 26 + 8 * level;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBreakEvent(BlockEvent.BreakEvent event) {
        int harvested;
        if (!this.isEnabled()) {
            return;
        }
        LevelAccessor world = event.getLevel();
        Player player = event.getPlayer();
        if (player.f_20912_ == null || world.m_5776_()) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState eventState = event.getState();
        Block block = eventState.m_60734_();
        ItemStack stackHarvestingWith = player.m_21120_(player.f_20912_);
        int level = this.getCurrentLevelTool(stackHarvestingWith);
        if (level <= 0) {
            return;
        }
        if (ForgeEventFactory.doPlayerHarvestCheck((Player)player, (BlockState)eventState, (boolean)true) && (harvested = this.harvestSurrounding((Level)world, player, pos, block, 1, level, player.f_20912_)) > 0) {
            ItemStackUtil.damageItem((LivingEntity)player, stackHarvestingWith);
        }
    }

    private int harvestSurrounding(Level world, Player player, BlockPos posIn, Block block, int totalBroken, int level, InteractionHand swingingHand) {
        if (totalBroken >= this.getHarvestMax(level) || player.m_21120_(player.f_20912_).m_41619_()) {
            return totalBroken;
        }
        HashSet<BlockPos> wasHarvested = new HashSet<BlockPos>();
        Set<BlockPos> theFuture = this.getMatchingSurrounding(world, posIn, block);
        for (BlockPos targetPos : theFuture) {
            int silklevel;
            int bonusLevel;
            int exp;
            BlockState targetState = world.m_8055_(targetPos);
            if (world.m_46859_(targetPos) || !player.m_36326_() || !player.m_36298_(targetState) || totalBroken >= this.getHarvestMax(level) || player.m_21120_(player.f_20912_).m_41619_()) continue;
            if (world instanceof ServerLevel) {
                Block.m_49881_((BlockState)targetState, (Level)world, (BlockPos)targetPos, (BlockEntity)world.m_7702_(targetPos), (Entity)player, (ItemStack)player.m_21120_(player.f_20912_));
            }
            if ((exp = targetState.getExpDrop((LevelReader)world, world.f_46441_, targetPos, bonusLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)player.m_21205_()), silklevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)player.m_21205_()))) > 0 && world instanceof ServerLevel) {
                block.m_49805_((ServerLevel)world, targetPos, exp);
            }
            world.m_46961_(targetPos, false);
            wasHarvested.add(targetPos);
            ++totalBroken;
        }
        if (wasHarvested.size() == 0) {
            return totalBroken;
        }
        for (BlockPos targetPos : theFuture) {
            if (totalBroken >= this.getHarvestMax(level) || player.m_21120_(player.f_20912_).m_41619_()) break;
            totalBroken += this.harvestSurrounding(world, player, targetPos, block, totalBroken, level, swingingHand);
        }
        return totalBroken;
    }

    private Set<BlockPos> getMatchingSurrounding(Level world, BlockPos start, Block blockIn) {
        HashSet<BlockPos> list = new HashSet<BlockPos>();
        List<Direction> targetFaces = Arrays.asList(VALUES);
        try {
            Collections.shuffle(targetFaces);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Direction fac : targetFaces) {
            Block target = world.m_8055_(start.m_121945_(fac)).m_60734_();
            if (target != blockIn) continue;
            list.add(start.m_121945_(fac));
        }
        return list;
    }

    static {
        VALUES = Direction.values();
    }
}

