/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.google.common.base.Suppliers;
import com.lothrazar.cyclic.enchant.EnchantmentCyclic;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.ItemHandlerHelper;

public class AutoSmeltEnchant
extends EnchantmentCyclic {
    public static final String ID = "auto_smelt";
    public static ForgeConfigSpec.BooleanValue CFG;

    public AutoSmeltEnchant(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean m_6594_() {
        return this.isEnabled() && super.m_6594_();
    }

    public boolean m_6592_() {
        return this.isEnabled() && super.m_6592_();
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled() && super.isAllowedOnBooks();
    }

    public boolean m_6081_(ItemStack stack) {
        return this.isEnabled() && super.m_6081_(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.isEnabled() && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int m_6586_() {
        return 1;
    }

    public boolean m_5975_(Enchantment ench) {
        return ench != Enchantments.f_44985_ && ench != Enchantments.f_44987_ && super.m_5975_(ench);
    }

    public static class EnchantAutoSmeltModifier
    extends LootModifier {
        public static final Supplier<Codec<EnchantAutoSmeltModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> EnchantAutoSmeltModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, EnchantAutoSmeltModifier::new)));

        public EnchantAutoSmeltModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> originalLoot, LootContext context) {
            ObjectArrayList newLoot = new ObjectArrayList();
            originalLoot.forEach(stack -> {
                Optional optional = context.m_78952_().m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), (Level)context.m_78952_());
                if (optional.isPresent()) {
                    ItemStack smeltedItemStack = ((SmeltingRecipe)optional.get()).m_8043_();
                    if (!smeltedItemStack.m_41619_()) {
                        ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)smeltedItemStack, (int)(stack.m_41613_() * smeltedItemStack.m_41613_()));
                        newLoot.add((Object)copy);
                    } else {
                        newLoot.add(stack);
                    }
                } else {
                    newLoot.add(stack);
                }
            });
            return newLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }
}

