/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.data;

import com.lothrazar.cyclic.util.LevelWorldUtil;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BlockPosDim {
    private double x;
    private double y;
    private double z;
    private BlockPos pos;
    private String dimension;
    private String name;
    private Vec3 hitVec = Vec3.f_82478_;
    private Direction side;
    private Direction sidePlayerFacing;

    public BlockPosDim(BlockPos pos, String dimension, CompoundTag stackTag) {
        CompoundTag displayTag;
        this.setX(pos.m_123341_());
        this.setY(pos.m_123342_());
        this.setZ(pos.m_123343_());
        this.setPos(pos);
        this.setDimension(dimension);
        if (stackTag != null && stackTag.m_128441_("display") && (displayTag = stackTag.m_128469_("display")) != null && displayTag.m_128425_("Name", 8)) {
            MutableComponent namec = Component.Serializer.m_130701_((String)displayTag.m_128461_("Name"));
            this.name = namec.getString();
        }
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.pos, this.x, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockPosDim other = (BlockPosDim)obj;
        return Objects.equals(this.dimension, other.dimension) && Objects.equals(this.pos, other.pos) && Double.doubleToLongBits(this.x) == Double.doubleToLongBits(other.x) && Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y) && Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }

    public String toString() {
        return this.getDisplayString();
    }

    public String getDisplayString() {
        Object prefix = "";
        if (this.name != null && !this.name.isEmpty()) {
            prefix = this.name + " ";
        }
        String d = this.dimension == null ? "" : this.dimension.replace("minecraft:", "");
        return (String)prefix + d + " (" + (int)this.getX() + ", " + (int)this.getY() + ", " + (int)this.getZ() + ")";
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public ServerLevel getTargetLevel(Level world) {
        if (world == null || world.m_7654_() == null || this.dimension == null) {
            return null;
        }
        return world.m_7654_().m_129880_(LevelWorldUtil.stringToDimension(this.getDimension()));
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public Direction getSide() {
        return this.side == null ? Direction.UP : this.side;
    }

    public void setSide(Direction side) {
        this.side = side;
    }

    public Vec3 getHitVec() {
        return this.hitVec;
    }

    public void setHitVec(Vec3 hitVec) {
        this.hitVec = hitVec;
    }

    public Direction getSidePlayerFacing() {
        return this.sidePlayerFacing;
    }

    public void setSidePlayerFacing(Direction sidePlayerFacing) {
        this.sidePlayerFacing = sidePlayerFacing;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }
}

