/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.trash;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.capabilities.block.FluidTankBase;
import com.lothrazar.cyclic.registry.TileRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileTrash
extends TileBlockEntityCyclic {
    public static final int CAPACITY = 64000;
    ItemStackHandler inventory = new ItemStackHandler(1){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return ItemStack.f_41583_;
        }
    };
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    FluidTankBase tank;
    private final LazyOptional<FluidTankBase> fluidCap = LazyOptional.of(() -> this.tank);

    public TileTrash(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.TRASH.get(), pos, state);
        this.tank = new FluidTankBase(this, 64000, p -> true);
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        this.fluidCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileTrash e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileTrash e) {
        e.tick();
    }

    public void tick() {
        this.inventory.extractItem(0, 64, false);
        this.tank.drain(64000, IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }
}

