/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.generatorfluid;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.generatorfluid.ContainerGeneratorFluid;
import com.lothrazar.cyclic.block.generatorfluid.RecipeGeneratorFluid;
import com.lothrazar.cyclic.capabilities.ItemStackHandlerWrapper;
import com.lothrazar.cyclic.capabilities.block.CustomEnergyStorage;
import com.lothrazar.cyclic.capabilities.block.FluidTankBase;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.CyclicRecipeType;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileGeneratorFluid
extends TileBlockEntityCyclic
implements MenuProvider {
    public static final int CAPACITY = 64000;
    static final int MAX = 640000;
    CustomEnergyStorage energy = new CustomEnergyStorage(640000, 640000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    ItemStackHandler inputSlots = new ItemStackHandler(0);
    protected final FluidTankBase tank = new FluidTankBase(this, 64000, p -> true);
    private final LazyOptional<FluidTankBase> fluidCap = LazyOptional.of(() -> this.tank);
    ItemStackHandler outputSlots = new ItemStackHandler(0);
    private ItemStackHandlerWrapper inventory = new ItemStackHandlerWrapper(this.inputSlots, this.outputSlots);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private int burnTimeMax = 0;
    private int burnTime = 0;
    private RecipeGeneratorFluid currentRecipe;

    public TileGeneratorFluid(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.GENERATOR_FLUID.get(), pos, state);
        this.needsRedstone = 0;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileGeneratorFluid e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileGeneratorFluid e) {
        e.tick();
    }

    @Override
    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    public void tick() {
        this.syncEnergy();
        if (this.flowing == 1) {
            this.exportEnergyAllSides();
        }
        if (this.burnTime == 0) {
            this.setLitProperty(false);
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        if (this.burnTime <= 0) {
            this.currentRecipe = null;
            this.burnTimeMax = 0;
            this.burnTime = 0;
        }
        this.tryConsumeFuel();
    }

    private void tryConsumeFuel() {
        if (this.burnTime > 0 && this.energy.getEnergyStored() + this.currentRecipe.getRfpertick() <= this.energy.getMaxEnergyStored()) {
            this.setLitProperty(true);
            --this.burnTime;
            this.energy.receiveEnergy(this.currentRecipe.getRfpertick(), false);
        } else if (this.burnTime <= 0) {
            this.findMatchingRecipe();
            if (this.currentRecipe == null) {
                this.burnTime = 0;
                return;
            }
        }
    }

    private void findMatchingRecipe() {
        if (this.currentRecipe != null && this.currentRecipe.matches(this, this.f_58857_)) {
            return;
        }
        this.currentRecipe = null;
        List recipes = this.f_58857_.m_7465_().m_44013_((RecipeType)CyclicRecipeType.GENERATOR_FLUID.get());
        for (RecipeGeneratorFluid rec : recipes) {
            if (!rec.matches(this, this.f_58857_)) continue;
            this.currentRecipe = rec;
            this.burnTime = this.burnTimeMax = this.currentRecipe.getTicks();
            this.tank.drain(this.currentRecipe.fluidIng.getAmount(), IFluidHandler.FluidAction.EXECUTE);
            return;
        }
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.GENERATOR_FLUID.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerGeneratorFluid(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.inventoryCap.invalidate();
        this.fluidCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.tank.readFromNBT(tag.m_128469_("fluid"));
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        CompoundTag fluid = new CompoundTag();
        this.tank.writeToNBT(fluid);
        tag.m_128365_("fluid", (Tag)fluid);
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.burnTime;
            }
            case BURNMAX: {
                return this.burnTimeMax;
            }
            case FLOWING: {
                return this.flowing;
            }
        }
        return 0;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TIMER: {
                this.burnTime = value;
                break;
            }
            case BURNMAX: {
                this.burnTimeMax = value;
                break;
            }
            case FLOWING: {
                this.flowing = value;
            }
        }
    }

    public int getEnergyMax() {
        return 640000;
    }

    static enum Fields {
        TIMER,
        REDSTONE,
        BURNMAX,
        FLOWING;

    }
}

