/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.enderctrl;

import com.lothrazar.cyclic.block.enderctrl.EnderControllerItemHandler;
import com.lothrazar.cyclic.block.endershelf.EnderShelfItemHandler;
import com.lothrazar.cyclic.registry.BlockRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.items.CapabilityItemHandler;

public class EnderShelfHelper {
    public static ForgeConfigSpec.IntValue MAX_DIST;
    public static final int MAX_ITERATIONS = 6400;

    public static BlockPos findConnectedController(Level world, BlockPos shelfPos) {
        return EnderShelfHelper.recursivelyFindConnectedController(world, shelfPos, new HashMap<BlockPos, Integer>(), 0);
    }

    private static BlockPos recursivelyFindConnectedController(Level world, BlockPos pos, Map<BlockPos, Integer> visitedLocations, int iterations) {
        BlockState state = world.m_8055_(pos);
        if (iterations > 6400) {
            return null;
        }
        if (EnderShelfHelper.isController(state)) {
            return pos;
        }
        if (!EnderShelfHelper.isShelf(state) || visitedLocations.containsKey(pos)) {
            return null;
        }
        visitedLocations.put(pos, iterations);
        BlockPos[] possibleControllers = new BlockPos[Direction.values().length];
        BlockPos returnController = null;
        int index = 0;
        ++iterations;
        for (Direction direction : Direction.values()) {
            if (state.m_61143_((Property)BlockStateProperties.f_61374_) != direction) {
                possibleControllers[index] = EnderShelfHelper.recursivelyFindConnectedController(world, pos.m_121945_(direction), visitedLocations, iterations);
            }
            if (possibleControllers[index] == null) continue;
            returnController = possibleControllers[index];
        }
        return returnController;
    }

    public static Set<BlockPos> findConnectedShelves(Level world, BlockPos controllerPos, Direction facing) {
        return EnderShelfHelper.recursivelyFindConnectedShelves(controllerPos, world, controllerPos, new HashSet<BlockPos>(), new HashSet<BlockPos>(), 0);
    }

    public static Set<BlockPos> recursivelyFindConnectedShelves(BlockPos controllerPos, Level world, BlockPos pos, Set<BlockPos> visitedLocations, Set<BlockPos> shelves, int iterations) {
        BlockState state = world.m_8055_(pos);
        if (visitedLocations.contains(pos)) {
            return shelves;
        }
        visitedLocations.add(pos);
        if (iterations > 6400) {
            return shelves;
        }
        if (pos.m_123333_((Vec3i)controllerPos) > (Integer)MAX_DIST.get()) {
            return shelves;
        }
        if (iterations > 0 && !EnderShelfHelper.isShelf(state)) {
            return shelves;
        }
        if (iterations > 0) {
            shelves.add(pos);
        }
        ++iterations;
        for (Direction direction : Direction.values()) {
            if (state.m_61143_((Property)BlockStateProperties.f_61374_) == direction) continue;
            shelves.addAll(EnderShelfHelper.recursivelyFindConnectedShelves(controllerPos, world, pos.m_121945_(direction), visitedLocations, shelves, iterations));
        }
        return shelves;
    }

    public static EnderShelfItemHandler getShelfHandler(BlockEntity te) {
        if (te != null && te.m_58900_().m_60734_() == BlockRegistry.ENDER_SHELF.get() && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent() && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().get() instanceof EnderShelfItemHandler) {
            return (EnderShelfItemHandler)((Object)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().get());
        }
        return null;
    }

    public static EnderControllerItemHandler getControllerHandler(BlockEntity te) {
        if (te != null && te.m_58900_().m_60734_() == BlockRegistry.ENDER_CONTROLLER.get() && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent() && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().get() instanceof EnderControllerItemHandler) {
            return (EnderControllerItemHandler)((Object)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().get());
        }
        return null;
    }

    public static boolean isController(BlockState state) {
        return state.m_60734_() == BlockRegistry.ENDER_CONTROLLER.get();
    }

    public static boolean isShelf(BlockState state) {
        return state.m_60734_() == BlockRegistry.ENDER_SHELF.get();
    }
}

