/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.collectitem;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.collectitem.ContainerItemCollector;
import com.lothrazar.cyclic.item.datacard.filter.FilterCardItem;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.ShapeUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileItemCollector
extends TileBlockEntityCyclic
implements MenuProvider {
    static final int MAX_SIZE = 12;
    static final int MAX_HEIGHT = 64;
    private int height = 1;
    private boolean directionIsUp = false;
    ItemStackHandler inventory = new ItemStackHandler(18);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    ItemStackHandler filter = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41720_() == ItemRegistry.FILTER_DATA.get();
        }
    };
    private int radius = 8;

    public TileItemCollector(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.COLLECTOR.get(), pos, state);
        this.needsRedstone = 0;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileItemCollector e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileItemCollector e) {
        e.tick();
    }

    public void tick() {
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        if (this.f_58857_.f_46443_) {
            return;
        }
        AABB aabb = this.getRange();
        List list = this.f_58857_.m_6443_(ItemEntity.class, aabb, entity -> entity.m_6084_());
        if (list.size() > 0) {
            ItemEntity stackEntity = (ItemEntity)list.get(this.f_58857_.f_46441_.m_188503_(list.size()));
            ItemStack remainder = stackEntity.m_32055_();
            if (!FilterCardItem.filterAllowsExtract(this.filter.getStackInSlot(0), remainder)) {
                return;
            }
            for (int i = 0; i < this.inventory.getSlots() && !remainder.m_41619_(); ++i) {
                remainder = this.inventory.insertItem(i, remainder, false);
            }
            stackEntity.m_32045_(remainder);
            if (remainder.m_41619_()) {
                stackEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.COLLECTOR.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerItemCollector(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.filter.deserializeNBT(tag.m_128469_("filter"));
        this.radius = tag.m_128451_("radius");
        this.height = tag.m_128451_("height");
        this.directionIsUp = tag.m_128471_("directionIsUp");
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("filter", (Tag)this.filter.serializeNBT());
        tag.m_128405_("radius", this.radius);
        tag.m_128405_("height", this.height);
        tag.m_128379_("directionIsUp", this.directionIsUp);
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    private BlockPos getTargetCenter() {
        return this.m_58899_().m_5484_(this.getCurrentFacing(), this.radius + 1);
    }

    public List<BlockPos> getShape() {
        int diff;
        List<BlockPos> shape = ShapeUtil.squareHorizontalHollow(this.getCurrentFacingPos(this.radius + 1), this.radius);
        int n = diff = this.directionIsUp ? 1 : -1;
        if (this.height > 0) {
            shape = ShapeUtil.repeatShapeByHeight(shape, diff * this.height);
        }
        return shape;
    }

    private AABB getRange() {
        BlockPos center = this.getTargetCenter();
        int diff = this.directionIsUp ? 1 : -1;
        int yMin = center.m_123342_();
        int yMax = center.m_123342_() + diff * this.height;
        if (!this.directionIsUp) {
            ++yMin;
        }
        AABB aabb = new AABB((double)(center.m_123341_() - this.radius), (double)yMin, (double)(center.m_123343_() - this.radius), (double)(center.m_123341_() + this.radius + 1), (double)yMax, (double)(center.m_123343_() + this.radius + 1));
        return aabb;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.setNeedsRedstone(value);
                break;
            }
            case RENDER: {
                this.render = value % 2;
                break;
            }
            case SIZE: {
                this.radius = Math.min(value, 12);
                break;
            }
            case HEIGHT: {
                this.height = Math.min(value, 64);
                break;
            }
            case DIRECTION: {
                this.directionIsUp = value == 1;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
            case SIZE: {
                return this.radius;
            }
            case HEIGHT: {
                return this.height;
            }
            case DIRECTION: {
                return this.directionIsUp ? 1 : 0;
            }
        }
        return 0;
    }

    static enum Fields {
        REDSTONE,
        RENDER,
        SIZE,
        HEIGHT,
        DIRECTION;

    }
}

