/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable.fluid;

import com.lothrazar.cyclic.block.cable.CableBase;
import com.lothrazar.cyclic.block.cable.EnumConnectType;
import com.lothrazar.cyclic.block.cable.ShapeCache;
import com.lothrazar.cyclic.block.cable.fluid.ScreenCableFluid;
import com.lothrazar.cyclic.block.cable.fluid.TileCableFluid;
import com.lothrazar.cyclic.registry.MenuTypeRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockCableFluid
extends CableBase {
    public BlockCableFluid(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(0.5f));
    }

    @Override
    public void m_5871_(ItemStack stack, BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"block.cyclic.fluid_pipe.tooltip0").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.cyclic.shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    @Override
    public void registerClient() {
        MenuScreens.m_96206_((MenuType)((MenuType)MenuTypeRegistry.FLUID_PIPE.get()), ScreenCableFluid::new);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ShapeCache.getOrCreate(state, CableBase::createShape);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileCableFluid(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BlockCableFluid.m_152132_(type, (BlockEntityType)((BlockEntityType)TileRegistry.FLUID_PIPE.get()), (BlockEntityTicker)(world.f_46443_ ? TileCableFluid::clientTick : TileCableFluid::serverTick));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState stateIn, LivingEntity placer, ItemStack stack) {
        for (Direction d : Direction.values()) {
            IFluidHandler cap;
            BlockEntity facingTile = worldIn.m_7702_(pos.m_121945_(d));
            IFluidHandler iFluidHandler = cap = facingTile == null ? null : (IFluidHandler)facingTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, d.m_122424_()).orElse(null);
            if (cap == null) continue;
            stateIn = (BlockState)stateIn.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(d), (Comparable)((Object)EnumConnectType.INVENTORY));
            worldIn.m_46597_(pos, stateIn);
        }
        super.m_6402_(worldIn, pos, stateIn, placer, stack);
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            TileCableFluid tileentity = (TileCableFluid)worldIn.m_7702_(pos);
            if (tileentity != null && tileentity.filter != null) {
                Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)tileentity.filter.getStackInSlot(0));
            }
            worldIn.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        EnumProperty property = (EnumProperty)FACING_TO_PROPERTY_MAP.get(facing);
        EnumConnectType oldProp = (EnumConnectType)((Object)stateIn.m_61143_((Property)property));
        if (oldProp.isBlocked() || oldProp.isExtraction()) {
            return stateIn;
        }
        if (BlockCableFluid.isFluid(stateIn, facing, facingState, world, currentPos, facingPos)) {
            BlockState with = (BlockState)stateIn.m_61124_((Property)property, (Comparable)((Object)EnumConnectType.INVENTORY));
            if (world instanceof Level && world.m_8055_(currentPos).m_60734_() == this) {
                ((Level)world).m_46597_(currentPos, with);
            }
            return with;
        }
        return (BlockState)stateIn.m_61124_((Property)property, (Comparable)((Object)EnumConnectType.NONE));
    }
}

