/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.battery;

import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.battery.EnumBatteryPercent;
import com.lothrazar.cyclic.block.battery.ScreenBattery;
import com.lothrazar.cyclic.block.battery.TileBattery;
import com.lothrazar.cyclic.capabilities.block.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.MenuTypeRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class BlockBattery
extends BlockCyclic {
    public static final EnumProperty<EnumBatteryPercent> PERCENT = EnumProperty.m_61587_((String)"percent", EnumBatteryPercent.class);

    public BlockBattery(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(1.8f));
        this.setHasGui();
        this.m_49959_((BlockState)this.m_49966_().m_61124_(PERCENT, (Comparable)((Object)EnumBatteryPercent.ZERO)));
    }

    @Override
    public void registerClient() {
        MenuScreens.m_96206_((MenuType)((MenuType)MenuTypeRegistry.BATTERY.get()), ScreenBattery::new);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT}).m_61104_(new Property[]{PERCENT});
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return new ArrayList<ItemStack>();
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, BlockEntity ent, ItemStack stack) {
        super.m_6240_(world, player, pos, state, ent, stack);
        ItemStack newStackBattery = new ItemStack((ItemLike)this);
        if (ent instanceof TileBattery) {
            TileBattery battery = (TileBattery)ent;
            IEnergyStorage newStackCap = (IEnergyStorage)newStackBattery.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
            if (newStackCap instanceof CustomEnergyStorage) {
                ((CustomEnergyStorage)newStackCap).setEnergy(battery.energy.getEnergyStored());
            } else {
                newStackCap.receiveEnergy(battery.energy.getEnergyStored(), false);
            }
            if (battery.energy.getEnergyStored() > 0) {
                newStackBattery.m_41784_().m_128405_("energytt", battery.energy.getEnergyStored());
                newStackBattery.m_41784_().m_128405_("energyttmax", battery.energy.getMaxEnergyStored());
            }
        }
        if (!world.f_46443_) {
            world.m_7967_((Entity)new ItemEntity(world, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), newStackBattery));
        }
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileBattery(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BlockBattery.m_152132_(type, (BlockEntityType)((BlockEntityType)TileRegistry.BATTERY.get()), (BlockEntityTicker)(world.f_46443_ ? TileBattery::clientTick : TileBattery::serverTick));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        int current = 0;
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        if (stack.m_41782_() && stack.m_41783_().m_128441_("energy")) {
            current = stack.m_41783_().m_128451_("energy");
        } else if (storage != null) {
            current = storage.getEnergyStored();
        }
        TileBattery container = (TileBattery)world.m_7702_(pos);
        CustomEnergyStorage storageTile = (CustomEnergyStorage)((Object)container.getCapability(CapabilityEnergy.ENERGY, null).orElse(null));
        if (storageTile != null) {
            storageTile.setEnergy(current);
        }
        super.m_6402_(world, pos, state, placer, stack);
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            TileBattery tileentity = (TileBattery)worldIn.m_7702_(pos);
            if (tileentity != null && tileentity.batterySlots != null) {
                Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)tileentity.batterySlots.getStackInSlot(0));
            }
            worldIn.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }
}

