/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.world.level.feature.gen;

import com.mojang.serialization.Codec;
import corgitaco.corgilib.world.level.RandomTickScheduler;
import corgitaco.corgilib.world.level.feature.gen.configurations.TreeFromStructureNBTConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class TreeFromStructureNBTFeature
extends Feature<TreeFromStructureNBTConfig> {
    private static final boolean DEBUG = false;

    public TreeFromStructureNBTFeature(Codec<TreeFromStructureNBTConfig> $$0) {
        super($$0);
    }

    public boolean m_142674_(FeaturePlaceContext<TreeFromStructureNBTConfig> featurePlaceContext) {
        TreeFromStructureNBTConfig config = (TreeFromStructureNBTConfig)featurePlaceContext.m_159778_();
        BlockStateProvider logProvider = config.logProvider();
        BlockStateProvider leavesProvider = config.leavesProvider();
        WorldGenLevel level = featurePlaceContext.m_159774_();
        StructureTemplateManager templateManager = level.m_6018_().m_215082_();
        ResourceLocation baseLocation = config.baseLocation();
        Optional baseTemplateOptional = templateManager.m_230407_(baseLocation);
        ResourceLocation canopyLocation = config.canopyLocation();
        Optional canopyTemplateOptional = templateManager.m_230407_(canopyLocation);
        if (baseTemplateOptional.isEmpty()) {
            throw TreeFromStructureNBTFeature.noTreePartPresent(baseLocation);
        }
        if (canopyTemplateOptional.isEmpty()) {
            throw TreeFromStructureNBTFeature.noTreePartPresent(canopyLocation);
        }
        StructureTemplate baseTemplate = (StructureTemplate)baseTemplateOptional.get();
        StructureTemplate canopyTemplate = (StructureTemplate)canopyTemplateOptional.get();
        List basePalettes = baseTemplate.f_74482_;
        List canopyPalettes = canopyTemplate.f_74482_;
        BlockPos origin = featurePlaceContext.m_159777_();
        RandomSource random = featurePlaceContext.m_225041_();
        StructurePlaceSettings placeSettings = new StructurePlaceSettings().m_74379_(Rotation.m_221990_((RandomSource)random));
        StructureTemplate.Palette trunkBasePalette = placeSettings.m_74387_(basePalettes, origin);
        StructureTemplate.Palette randomCanopyPalette = placeSettings.m_74387_(canopyPalettes, origin);
        List center = trunkBasePalette.m_74653_(Blocks.f_50041_);
        if (center.isEmpty()) {
            throw new IllegalArgumentException("No trunk central position was specified for structure NBT palette %s. Trunk central position is specified with white wool.".formatted(config.baseLocation()));
        }
        if (center.size() > 1) {
            throw new IllegalArgumentException("There cannot be more than one trunk central position for structure NBT palette %s. Trunk central position is specified with white wool.".formatted(config.baseLocation()));
        }
        BlockPos centerOffset = ((StructureTemplate.StructureBlockInfo)center.get((int)0)).f_74675_;
        centerOffset = new BlockPos(-centerOffset.m_123341_(), 0, -centerOffset.m_123343_());
        List<StructureTemplate.StructureBlockInfo> logs = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.logTarget(), trunkBasePalette);
        List logBuilders = trunkBasePalette.m_74653_(Blocks.f_50108_);
        if (logBuilders.isEmpty()) {
            throw new UnsupportedOperationException(String.format("\"%s\" is missing log builders.", baseLocation));
        }
        HashSet<BlockPos> leavePositions = new HashSet<BlockPos>();
        HashSet<BlockPos> trunkPositions = new HashSet<BlockPos>();
        int trunkLength = config.height().m_214085_(random);
        int maxTrunkBuildingDepth = config.maxLogDepth();
        for (StructureTemplate.StructureBlockInfo logBuilder : logBuilders) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            if (TreeFromStructureNBTFeature.isOnGround(config.maxLogDepth(), level, pos, config.growableOn())) continue;
            return false;
        }
        TreeFromStructureNBTFeature.placeTrunk(config, logProvider, leavesProvider, level, origin, random, placeSettings, trunkBasePalette, centerOffset, logs, logBuilders, leavePositions, trunkPositions, maxTrunkBuildingDepth);
        List canopyAnchor = trunkBasePalette.m_74653_(Blocks.f_50098_);
        if (!canopyAnchor.isEmpty()) {
            if (canopyAnchor.size() > 1) {
                throw new IllegalArgumentException("There cannot be more than one central canopy position. Canopy central position is specified with yellow wool on the trunk palette.");
            }
            TreeFromStructureNBTFeature.placeCanopy(config, logProvider, leavesProvider, level, TreeFromStructureNBTFeature.getModifiedPos(placeSettings, (StructureTemplate.StructureBlockInfo)canopyAnchor.get(0), centerOffset, origin), random, placeSettings, randomCanopyPalette, leavePositions, trunkPositions, trunkLength, config.growableOn());
        } else {
            TreeFromStructureNBTFeature.placeCanopy(config, logProvider, leavesProvider, level, origin, random, placeSettings, randomCanopyPalette, leavePositions, trunkPositions, trunkLength, config.growableOn());
        }
        TreeFromStructureNBTFeature.placeTreeDecorations(config.treeDecorators(), level, random, leavePositions, trunkPositions);
        return true;
    }

    public static void placeAdditional(TreeFromStructureNBTConfig config, WorldGenLevel level, BlockPos origin, StructurePlaceSettings placeSettings, StructureTemplate.Palette palette, BlockPos centerOffset) {
        List<StructureTemplate.StructureBlockInfo> additionalBlocks = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.placeFromNBT(), palette);
        for (StructureTemplate.StructureBlockInfo additionalBlock : additionalBlocks) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, additionalBlock, centerOffset, origin);
            level.m_7731_(pos, additionalBlock.f_74676_, 2);
        }
    }

    public static void placeTrunk(TreeFromStructureNBTConfig config, BlockStateProvider logProvider, BlockStateProvider leavesProvider, WorldGenLevel level, BlockPos origin, RandomSource random, StructurePlaceSettings placeSettings, StructureTemplate.Palette trunkBasePalette, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logs, List<StructureTemplate.StructureBlockInfo> logBuilders, Set<BlockPos> leavePositions, Set<BlockPos> trunkPositions, int maxTrunkBuildingDepth) {
        TreeFromStructureNBTFeature.fillLogsUnder(random, logProvider, level, origin, placeSettings, centerOffset, logBuilders, maxTrunkBuildingDepth, config.growableOn());
        TreeFromStructureNBTFeature.placeLogsWithRotation(logProvider, level, origin, random, placeSettings, centerOffset, logs, trunkPositions);
        TreeFromStructureNBTFeature.placeLeavesWithCalculatedDistanceAndRotation(leavesProvider, level, origin, random, placeSettings, TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.leavesTarget(), trunkBasePalette), leavePositions, centerOffset, config.leavesPlacementFilter());
        TreeFromStructureNBTFeature.placeAdditional(config, level, origin, placeSettings, trunkBasePalette, centerOffset);
    }

    public static void placeCanopy(TreeFromStructureNBTConfig config, BlockStateProvider logProvider, BlockStateProvider leavesProvider, WorldGenLevel level, BlockPos origin, RandomSource random, StructurePlaceSettings placeSettings, StructureTemplate.Palette randomCanopyPalette, Set<BlockPos> leavePositions, Set<BlockPos> trunkPositions, int trunkLength, BlockPredicate groundFilter) {
        List<StructureTemplate.StructureBlockInfo> leaves = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.leavesTarget(), randomCanopyPalette);
        List<StructureTemplate.StructureBlockInfo> canopyLogs = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.logTarget(), randomCanopyPalette);
        List canopyAnchor = randomCanopyPalette.m_74653_(Blocks.f_50041_);
        if (canopyAnchor.isEmpty()) {
            throw new IllegalArgumentException("No canopy anchor was specified for structure NBT palette %s. Canopy anchor is specified with white wool.".formatted(config.canopyLocation()));
        }
        if (canopyAnchor.size() > 1) {
            throw new IllegalArgumentException("There cannot be more than one canopy anchor for structure NBT palette %s. Canopy anchor is specified with white wool.".formatted(config.canopyLocation()));
        }
        StructureTemplate.StructureBlockInfo structureBlockInfo = (StructureTemplate.StructureBlockInfo)canopyAnchor.get(0);
        BlockPos canopyCenterOffset = structureBlockInfo.f_74675_;
        canopyCenterOffset = new BlockPos(-canopyCenterOffset.m_123341_(), trunkLength, -canopyCenterOffset.m_123343_());
        ArrayList<StructureTemplate.StructureBlockInfo> trunkFillers = new ArrayList<StructureTemplate.StructureBlockInfo>(randomCanopyPalette.m_74653_(Blocks.f_50108_));
        TreeFromStructureNBTFeature.fillLogsUnder(random, logProvider, level, origin, placeSettings, canopyCenterOffset, trunkFillers, level.m_141928_(), groundFilter);
        TreeFromStructureNBTFeature.placeLogsWithRotation(logProvider, level, origin, random, placeSettings, canopyCenterOffset, canopyLogs, trunkPositions);
        TreeFromStructureNBTFeature.placeLeavesWithCalculatedDistanceAndRotation(leavesProvider, level, origin, random, placeSettings, leaves, leavePositions, canopyCenterOffset, config.leavesPlacementFilter());
        TreeFromStructureNBTFeature.placeAdditional(config, level, origin, placeSettings, randomCanopyPalette, canopyCenterOffset);
    }

    public static void placeLogsWithRotation(BlockStateProvider logProvider, WorldGenLevel level, BlockPos origin, RandomSource random, StructurePlaceSettings placeSettings, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logs, Set<BlockPos> trunkPositions) {
        for (StructureTemplate.StructureBlockInfo trunk : logs) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, trunk, centerOffset, origin);
            level.m_7731_(pos, TreeFromStructureNBTFeature.getTransformedState(logProvider.m_213972_(random, pos), trunk.f_74676_, placeSettings.m_74404_()), 2);
            trunkPositions.add(pos);
        }
    }

    public static void placeTreeDecorations(Iterable<TreeDecorator> treeDecorators, WorldGenLevel level, RandomSource random, Set<BlockPos> leavePositions, Set<BlockPos> trunkPositions) {
        for (TreeDecorator treeDecorator : treeDecorators) {
            treeDecorator.m_214187_(new TreeDecorator.Context((LevelSimulatedReader)level, (pos, state) -> level.m_7731_(pos, state, 2), random, trunkPositions, leavePositions, new HashSet()));
        }
    }

    public static void placeLeavesWithCalculatedDistanceAndRotation(BlockStateProvider leavesProvider, WorldGenLevel level, BlockPos origin, RandomSource random, StructurePlaceSettings placeSettings, List<StructureTemplate.StructureBlockInfo> leaves, Set<BlockPos> leavePositions, BlockPos canopyCenterOffset, BlockPredicate leavesPlacementFilter) {
        ArrayList<Runnable> leavesPostApply = new ArrayList<Runnable>(leaves.size());
        for (StructureTemplate.StructureBlockInfo leaf : leaves) {
            FluidState fluidState;
            BlockPos modifiedPos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, leaf, canopyCenterOffset, origin);
            if (!leavesPlacementFilter.test((Object)level, (Object)modifiedPos)) continue;
            BlockState state = leavesProvider.m_213972_(random, modifiedPos);
            if (state.m_61138_((Property)LeavesBlock.f_54418_) && leaf.f_74676_.m_61138_((Property)LeavesBlock.f_54418_)) {
                state = (BlockState)state.m_61124_((Property)LeavesBlock.f_54418_, (Comparable)((Integer)leaf.f_74676_.m_61143_((Property)LeavesBlock.f_54418_)));
            }
            if (state.m_61138_((Property)LeavesBlock.f_221367_) && (fluidState = level.m_6425_(modifiedPos)).m_192917_((Fluid)Fluids.f_76193_) && fluidState.m_76186_() >= 7) {
                state.m_61124_((Property)LeavesBlock.f_221367_, (Comparable)Boolean.valueOf(true));
            }
            level.m_7731_(modifiedPos, state, 2);
            BlockState finalState = state;
            if (state.m_61138_((Property)LeavesBlock.f_54418_)) {
                Runnable postProcess = () -> {
                    BlockState blockState = LeavesBlock.m_54435_((BlockState)finalState, (LevelAccessor)level, (BlockPos)modifiedPos);
                    if ((Integer)blockState.m_61143_((Property)LeavesBlock.f_54418_) < 7) {
                        leavePositions.add(modifiedPos);
                        level.m_7731_(modifiedPos, blockState, 2);
                        level.m_186460_(modifiedPos, blockState.m_60734_(), 0);
                    } else {
                        level.m_7471_(modifiedPos, false);
                    }
                };
                leavesPostApply.add(postProcess);
                continue;
            }
            leavePositions.add(modifiedPos);
        }
        leavesPostApply.forEach(Runnable::run);
    }

    public static void fillLogsUnder(RandomSource randomSource, BlockStateProvider logProvider, WorldGenLevel level, BlockPos origin, StructurePlaceSettings placeSettings, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logBuilders, int maxTrunkBuildingDepth, BlockPredicate groundFilter) {
        block0: for (StructureTemplate.StructureBlockInfo logBuilder : logBuilders) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
            for (int i = 0; i < maxTrunkBuildingDepth; ++i) {
                if (level.m_8055_((BlockPos)mutableBlockPos).m_60815_()) {
                    ((RandomTickScheduler)level.m_46865_((BlockPos)mutableBlockPos)).scheduleRandomTick(mutableBlockPos.m_7949_());
                    continue block0;
                }
                level.m_7731_((BlockPos)mutableBlockPos, logProvider.m_213972_(randomSource, (BlockPos)mutableBlockPos), 2);
                mutableBlockPos.m_122173_(Direction.DOWN);
            }
        }
    }

    @NotNull
    public static BlockState getTransformedState(BlockState state, BlockState canopyLogState, Rotation rotation) {
        Direction.Axis axis;
        for (Property property : state.m_61147_()) {
            if (!canopyLogState.m_61138_(property)) continue;
            Comparable value = canopyLogState.m_61143_(property);
            state = (BlockState)state.m_61124_(property, value);
        }
        if (state.m_61138_((Property)RotatedPillarBlock.f_55923_) && (axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_)).m_122479_() && (rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90)) {
            if (axis == Direction.Axis.X) {
                state = (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z);
            } else if (axis == Direction.Axis.Z) {
                state = (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
            }
        }
        return state;
    }

    public static boolean isOnGround(int maxLogDepth, WorldGenLevel level, BlockPos pos, BlockPredicate growableOn) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        for (int logDepth = 0; logDepth < maxLogDepth; ++logDepth) {
            mutableBlockPos.m_122173_(Direction.DOWN);
            if (!growableOn.test((Object)level, (Object)mutableBlockPos)) continue;
            return true;
        }
        return false;
    }

    public static BlockPos getModifiedPos(StructurePlaceSettings settings, StructureTemplate.StructureBlockInfo placing, BlockPos partCenter, BlockPos featureOrigin) {
        return StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)placing.f_74675_).m_121955_((Vec3i)featureOrigin).m_121955_((Vec3i)StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)partCenter));
    }

    public static IllegalArgumentException noTreePartPresent(ResourceLocation location) {
        return new IllegalArgumentException(String.format("\"%s\" is not a valid tree part.", location));
    }

    public static List<StructureTemplate.StructureBlockInfo> getStructureInfosInStructurePalletteFromBlockList(Iterable<Block> blocks, StructureTemplate.Palette palette) {
        ArrayList<StructureTemplate.StructureBlockInfo> result = new ArrayList<StructureTemplate.StructureBlockInfo>();
        for (Block block : blocks) {
            result.addAll(palette.m_74653_(block));
        }
        return result;
    }
}

