/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import dev.architectury.registry.registries.Registries;
import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.recipe.IgnoredRecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.minecraft.ShapedRecipeJS;
import dev.latvian.mods.kubejs.recipe.minecraft.ShapelessRecipeJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

public record RegisterRecipeTypesEvent(Map<ResourceLocation, RecipeTypeJS> map) {
    public void register(RecipeTypeJS type) {
        this.map.put(Registries.getId(type.serializer, (ResourceKey)Registry.f_122915_), type);
        KubeJS.LOGGER.info("Registered custom recipe handler for type " + type);
    }

    public void register(ResourceLocation id, Supplier<RecipeJS> f) {
        block2: {
            try {
                this.register(new RecipeTypeJS(Objects.requireNonNull((RecipeSerializer)KubeJSRegistries.recipeSerializers().get(id)), f));
            }
            catch (NullPointerException e) {
                if (!DevProperties.get().logErroringRecipes) break block2;
                ConsoleJS.SERVER.warn("Failed to register handler for recipe type " + id + " as it doesn't exist!");
            }
        }
    }

    public void ignore(ResourceLocation id) {
        block2: {
            try {
                this.register(new IgnoredRecipeTypeJS(Objects.requireNonNull((RecipeSerializer)KubeJSRegistries.recipeSerializers().get(id))));
            }
            catch (NullPointerException e) {
                if (!DevProperties.get().logErroringRecipes) break block2;
                ConsoleJS.SERVER.warn("Failed to ignore recipe type " + id + " as it doesn't exist!");
            }
        }
    }

    public void registerShaped(ResourceLocation id) {
        this.register(id, ShapedRecipeJS::new);
    }

    public void registerShapeless(ResourceLocation id) {
        this.register(id, ShapelessRecipeJS::new);
    }

    private void handleMissingSerializer(ResourceLocation id) {
        if (DevProperties.get().logInvalidRecipeHandlers) {
            throw new NullPointerException("Cannot find recipe serializer: " + id);
        }
        if (DevProperties.get().logErroringRecipes) {
            KubeJS.LOGGER.warn("Skipping recipe handler for serializer " + id + " as it does not exist!");
        }
    }
}

