/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.platform.IngredientPlatformHelper;
import dev.latvian.mods.kubejs.recipe.JsonRecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeArguments;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.RecipesEventJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.WrappedJS;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Scriptable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class RecipeFunction
extends BaseFunction
implements WrappedJS {
    private static final Pattern SKIP_ERROR = Pattern.compile("at dev.latvian.mods.kubejs.recipe.RecipeFunction.call");
    private final RecipesEventJS event;
    public final ResourceLocation typeID;
    public final RecipeTypeJS type;

    public RecipeFunction(RecipesEventJS e, ResourceLocation id, @Nullable RecipeTypeJS t) {
        this.event = e;
        this.typeID = id;
        this.type = t;
    }

    public RecipeJS call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args0) {
        return this.createRecipe(args0);
    }

    public RecipeJS createRecipe(Object[] args0) {
        try {
            JsonObject map;
            if (this.type == null) {
                throw new RecipeExceptionJS("Unknown recipe type!");
            }
            List<?> args1 = ListJS.of(args0);
            if (args1 == null || args1.isEmpty()) {
                throw new RecipeExceptionJS("Recipe requires at least one argument!");
            }
            if (this.type.isCustom() && args1.size() != 1) {
                throw new RecipeExceptionJS("Custom recipe has to use a single json object argument!");
            }
            if (args1.size() == 1 && (map = MapJS.json(args1.get(0))) != null) {
                RecipeJS recipe = this.type.factory.get();
                RecipeArguments args = new RecipeArguments(recipe, args1);
                recipe.type = this.type;
                recipe.json = MapJS.json(this.normalize(recipe, map));
                if (!(recipe instanceof JsonRecipeJS)) {
                    recipe.serializeInputs = true;
                    recipe.serializeOutputs = true;
                    recipe.deserializeJson();
                }
                return this.event.addRecipe(recipe, this.type, args);
            }
            RecipeJS recipe = this.type.factory.get();
            RecipeArguments args = new RecipeArguments(recipe, args1);
            recipe.type = this.type;
            recipe.json = new JsonObject();
            recipe.serializeInputs = true;
            recipe.serializeOutputs = true;
            recipe.create(args);
            return this.event.addRecipe(recipe, this.type, args);
        }
        catch (RecipeExceptionJS ex) {
            ex.error();
            ConsoleJS.SERVER.error("Failed to create recipe for type '" + this.typeID + "'", ex, SKIP_ERROR);
        }
        catch (Throwable ex) {
            ConsoleJS.SERVER.handleError(ex, SKIP_ERROR, "Failed to create recipe for type '" + this.typeID + "' with args " + Arrays.toString(args0));
        }
        return new JsonRecipeJS();
    }

    private Object normalize(RecipeJS recipe, Object o) {
        if (o instanceof ItemStack) {
            ItemStack stack = (ItemStack)o;
            return recipe.itemToJson(stack);
        }
        if (o instanceof Ingredient) {
            Ingredient ingr = (Ingredient)o;
            return ingr.m_43942_();
        }
        if (o instanceof String) {
            String s = (String)o;
            if (s.length() >= 4 && s.startsWith("#") && s.indexOf(58) != -1) {
                return IngredientPlatformHelper.get().tag(s.substring(1)).m_43942_();
            }
            return o;
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            HashMap map = new HashMap();
            for (Map.Entry entry : m.entrySet()) {
                map.put(entry.getKey(), this.normalize(recipe, entry.getValue()));
            }
            return map;
        }
        if (o instanceof Iterable) {
            Iterable itr = (Iterable)o;
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object o1 : itr) {
                list.add(this.normalize(recipe, o1));
            }
            return list;
        }
        return o;
    }

    public String toString() {
        return this.typeID.toString();
    }
}

