/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.platform.forge.ingredient;

import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientStack;
import dev.latvian.mods.kubejs.platform.forge.ingredient.KubeJSIngredient;
import dev.latvian.mods.kubejs.platform.forge.ingredient.KubeJSIngredientSerializer;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class IngredientStackImpl
extends KubeJSIngredient
implements IngredientStack {
    public static final KubeJSIngredientSerializer<IngredientStackImpl> SERIALIZER = new KubeJSIngredientSerializer<IngredientStackImpl>(IngredientStackImpl::new, IngredientStackImpl::new);
    private final Ingredient ingredient;
    private final int count;

    public IngredientStackImpl(Ingredient ingredient, int count) {
        this.ingredient = ingredient;
        this.count = count;
    }

    private IngredientStackImpl(JsonObject json) {
        this.ingredient = IngredientJS.ofJson(json.get("ingredient"));
        this.count = json.has("count") ? json.get("count").getAsInt() : 1;
    }

    private IngredientStackImpl(FriendlyByteBuf buf) {
        this.ingredient = IngredientJS.ofNetwork(buf);
        this.count = buf.m_130242_();
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && this.ingredient.test(stack);
    }

    @Override
    public void toJson(JsonObject json) {
        json.add("ingredient", this.ingredient.m_43942_());
        json.addProperty("count", (Number)this.count);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        this.ingredient.m_43923_(buf);
        buf.m_130130_(this.count);
    }

    @Override
    public IngredientStackImpl kjs$asStack() {
        return this;
    }

    @Override
    public Ingredient kjs$withCount(int count) {
        return count < 1 ? f_43901_ : (count == 1 ? this.ingredient : new IngredientStackImpl(this.ingredient, count));
    }

    @Override
    public List<Ingredient> kjs$unwrapStackIngredient() {
        Object[] array = new Ingredient[this.count];
        Arrays.fill(array, this.ingredient);
        return Arrays.asList(array);
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public int getCount() {
        return this.count;
    }
}

