/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.core.IngredientSupplierKJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.platform.IngredientPlatformHelper;
import dev.latvian.mods.kubejs.platform.RecipePlatformHelper;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public interface IngredientJS {
    public static final Map<String, Ingredient> PARSE_CACHE = new HashMap<String, Ingredient>();

    public static Ingredient of(@Nullable Object o) {
        while (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o == null || o == ItemStack.f_41583_ || o == Items.f_41852_ || o == Ingredient.f_43901_) {
            return Ingredient.f_43901_;
        }
        if (o instanceof IngredientSupplierKJS) {
            IngredientSupplierKJS ingr = (IngredientSupplierKJS)o;
            return ingr.kjs$asIngredient();
        }
        if (o instanceof Pattern || o instanceof NativeRegExp) {
            Pattern reg = UtilsJS.parseRegex(o);
            if (reg != null) {
                return IngredientPlatformHelper.get().regex(reg);
            }
            return Ingredient.f_43901_;
        }
        if (o instanceof JsonElement) {
            JsonElement json = (JsonElement)o;
            return IngredientJS.ofJson(json);
        }
        if (o instanceof CharSequence) {
            String os;
            String s = os = o.toString();
            Ingredient cached = PARSE_CACHE.get(os);
            if (cached != null) {
                return cached;
            }
            int count = 1;
            int spaceIndex = s.indexOf(32);
            if (spaceIndex >= 2 && s.indexOf(120) == spaceIndex - 1) {
                count = Integer.parseInt(s.substring(0, spaceIndex - 1));
                s = s.substring(spaceIndex + 1);
            }
            if (RecipeJS.itemErrors && count <= 0) {
                throw new RecipeExceptionJS("Invalid count!").error();
            }
            cached = IngredientJS.parse(s);
            cached = cached.kjs$withCount(count);
            PARSE_CACHE.put(os, cached);
            return cached;
        }
        List<?> list = ListJS.of(o);
        if (list != null) {
            ArrayList<Ingredient> inList = new ArrayList<Ingredient>(list.size());
            for (Object o1 : list) {
                Ingredient ingredient = IngredientJS.of(o1);
                if (ingredient == Ingredient.f_43901_) continue;
                inList.add(ingredient);
            }
            if (inList.isEmpty()) {
                return Ingredient.f_43901_;
            }
            if (inList.size() == 1) {
                return (Ingredient)inList.get(0);
            }
            return IngredientPlatformHelper.get().or(inList.toArray(new Ingredient[0]));
        }
        Map<?, ?> map = MapJS.of(o);
        if (map != null) {
            Ingredient in = Ingredient.f_43901_;
            boolean val = map.containsKey("value");
            if (map.containsKey("type")) {
                if ("forge:nbt".equals(map.get("type"))) {
                    in = ItemStackJS.of(map.get("item")).kjs$withNBT(NBTUtils.toTagCompound(map.get("nbt"))).kjs$strongNBT();
                } else {
                    JsonObject json = MapJS.json(o);
                    if (json == null) {
                        throw new RecipeExceptionJS("Failed to parse custom ingredient (" + o + " is not a json object").fallback();
                    }
                    try {
                        in = RecipePlatformHelper.get().getCustomIngredient(json);
                    }
                    catch (Exception ex) {
                        throw new RecipeExceptionJS("Failed to parse custom ingredient (" + json.get("type") + ") from " + json + ": " + ex).fallback();
                    }
                }
            } else if (val || map.containsKey("ingredient")) {
                in = IngredientJS.of(val ? map.get("value") : map.get("ingredient"));
            } else if (map.containsKey("tag")) {
                in = IngredientPlatformHelper.get().tag(map.get("tag").toString());
            } else if (map.containsKey("item")) {
                in = ItemStackJS.of(map).m_41720_().kjs$asIngredient();
            }
            return in;
        }
        return ItemStackJS.of(o).kjs$asIngredient();
    }

    public static Ingredient parse(String s) {
        if (s.isEmpty() || s.equals("-") || s.equals("air") || s.equals("minecraft:air")) {
            return Ingredient.f_43901_;
        }
        if (s.equals("*")) {
            return IngredientPlatformHelper.get().wildcard();
        }
        if (s.startsWith("#")) {
            return IngredientPlatformHelper.get().tag(s.substring(1));
        }
        if (s.startsWith("@")) {
            return IngredientPlatformHelper.get().mod(s.substring(1));
        }
        if (s.startsWith("%")) {
            CreativeModeTab group = UtilsJS.findCreativeTab(s.substring(1));
            if (group == null) {
                if (RecipeJS.itemErrors) {
                    throw new RecipeExceptionJS("Item group '" + s.substring(1) + "' not found!").error();
                }
                return Ingredient.f_43901_;
            }
            return IngredientPlatformHelper.get().creativeTab(group);
        }
        Pattern reg = UtilsJS.parseRegex(s);
        if (reg != null) {
            return IngredientPlatformHelper.get().regex(reg);
        }
        Item item = (Item)KubeJSRegistries.items().get(new ResourceLocation(s));
        if (item == null || item == Items.f_41852_) {
            return Ingredient.f_43901_;
        }
        return item.kjs$asIngredient();
    }

    public static Ingredient ofJson(JsonElement json) {
        if (json.isJsonArray()) {
            ArrayList<Ingredient> inList = new ArrayList<Ingredient>();
            for (JsonElement e : json.getAsJsonArray()) {
                Ingredient i = IngredientJS.ofJson(e);
                if (i == Ingredient.f_43901_) continue;
                inList.add(i);
            }
            if (inList.isEmpty()) {
                return Ingredient.f_43901_;
            }
            if (inList.size() == 1) {
                return (Ingredient)inList.get(0);
            }
            return IngredientPlatformHelper.get().or(inList.toArray(new Ingredient[0]));
        }
        if (json.isJsonPrimitive()) {
            return IngredientJS.of(json.getAsString());
        }
        if (json.isJsonObject()) {
            int count;
            JsonObject o = json.getAsJsonObject();
            boolean val = o.has("value");
            int n = count = o.has("count") ? o.get("count").getAsInt() : 1;
            if (o.has("type")) {
                try {
                    return RecipePlatformHelper.get().getCustomIngredient(o).kjs$withCount(count);
                }
                catch (Exception ex) {
                    throw new RecipeExceptionJS("Failed to parse custom ingredient (" + o.get("type") + ") from " + o + ": " + ex);
                }
            }
            if (val || o.has("ingredient")) {
                return IngredientJS.ofJson(val ? o.get("value") : o.get("ingredient")).kjs$withCount(count);
            }
            if (o.has("tag")) {
                return IngredientPlatformHelper.get().tag(o.get("tag").getAsString()).kjs$withCount(count);
            }
            if (o.has("item")) {
                return ItemStackJS.of(o.get("item").getAsString()).m_41720_().kjs$asIngredient().kjs$withCount(count);
            }
            return Ingredient.f_43901_;
        }
        return Ingredient.f_43901_;
    }

    public static Ingredient ofNetwork(FriendlyByteBuf buf) {
        return Ingredient.m_43940_((FriendlyByteBuf)buf);
    }
}

